/*
 * Decompiled with CFR 0.152.
 */
package utils.loggingframework;

import java.util.ArrayList;
import java.util.LinkedList;
import utils.loggingframework.LogEventListener;
import utils.loggingframework.events.LogEvent;
import utils.loggingframework.logmapping.LogMapping;
import utils.loggingframework.logmapping.LogMappingRepository;

public class LoggingFramework {
    public static final LoggingFramework INSTANCE = new LoggingFramework();
    private final LogMappingRepository mappingRepository = new LogMappingRepository();
    private final ArrayList<LogEventListener> eventListeners = new ArrayList();
    private final LinkedList<LogEvent> eventList = new LinkedList();
    private static final int MAX_EVENT_LIST_SIZE = 2000;
    private EventProcessingThread processingThread = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logEvent(LogEvent event) {
        if (this.processingThread == null) {
            this.processingThread = new EventProcessingThread();
            this.processingThread.start();
        }
        LinkedList<LogEvent> linkedList = this.eventList;
        synchronized (linkedList) {
            if (this.eventList.size() == 2000) {
                System.out.println("[LoggingFramework] Discaring event since maximum number of events have been reached.");
                this.eventList.removeFirst();
            }
            this.eventList.add(event);
            this.eventList.notify();
        }
    }

    public LogMappingRepository getLogMappingRepository() {
        return this.mappingRepository;
    }

    public void addLogEventListener(LogEventListener eventListener) {
        if (!this.eventListeners.contains(eventListener)) {
            this.eventListeners.add(eventListener);
        }
    }

    public void removeLogEventListener(LogEventListener eventListener) {
        this.eventListeners.remove(eventListener);
    }

    private void notifyListenersOfError(LogEvent event, LogMapping mapping, Throwable t) {
        for (LogEventListener listener : this.eventListeners) {
            listener.logLoggingError(event, mapping, t);
        }
    }

    static /* synthetic */ LinkedList access$000(LoggingFramework x0) {
        return x0.eventList;
    }

    static /* synthetic */ LogMappingRepository access$100(LoggingFramework x0) {
        return x0.mappingRepository;
    }

    static /* synthetic */ void access$200(LoggingFramework x0, LogEvent x1, LogMapping x2, Throwable x3) {
        x0.notifyListenersOfError(x1, x2, x3);
    }

    class EventProcessingThread
    extends Thread {
        EventProcessingThread() {
            super("LoggingFramework-EventProcessingThread");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            block11: while (true) {
                var2_2 = LoggingFramework.access$000(LoggingFramework.this);
                synchronized (var2_2) {
                    while (LoggingFramework.access$000(LoggingFramework.this).size() == 0) {
                        try {
                            LoggingFramework.access$000(LoggingFramework.this).wait();
                        }
                        catch (InterruptedException var3_5) {}
                    }
                    event = (LogEvent)LoggingFramework.access$000(LoggingFramework.this).removeFirst();
                }
                System.out.println("[LoggingFramework] Logging event " + event.getEventType() + " (" + event.getDisplayName() + ")");
                try {
                    it = LoggingFramework.access$100(LoggingFramework.this).mappingsIterator();
                    block13: while (true) {
                        if (!it.hasNext()) continue block11;
                        mapping = it.next();
                        if (!mapping.canLogEvent(event)) continue;
                        System.out.println("[LoggingFramework] Log mapping '" + mapping.getLogMappingDescription() + "' is processing event");
                        var4_6 = mapping.getTargets();
                        var5_8 = var4_6.length;
                        var6_9 = 0;
                        while (true) {
                            if (var6_9 < var5_8) ** break;
                            continue block13;
                            target = var4_6[var6_9];
                            try {
                                target.logEvent(event);
                            }
                            catch (Throwable t) {
                                try {
                                    LoggingFramework.access$200(LoggingFramework.this, event, mapping, t);
                                }
                                catch (Throwable tt) {
                                    tt.printStackTrace();
                                }
                                System.out.println("[LoggingFramework] Target '" + target + "' failed to log event '" + event + "': " + t.getMessage());
                                t.printStackTrace();
                            }
                            ++var6_9;
                        }
                        break;
                    }
                }
                catch (Throwable t) {
                    System.out.println("[LoggingFramework] Severe logging error: " + t.getMessage());
                    t.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }
}

