/*
 * Decompiled with CFR 0.152.
 */
package utils.dataservice.gziplist.aggregator;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import utils.dataservice.gziplist.AggregateChunk;
import utils.dataservice.gziplist.aggregator.Aggregator;
import utils.stream.StreamUtils;

public class StandardDeviationAggregator
extends Aggregator {
    private double n = 0.0;
    private double sumXSqrd = 0.0;
    private double sumX = 0.0;
    double[][] sub_sumsq;
    double[][] sub_sum;
    long count = 0L;

    protected StandardDeviationAggregator(int chunkSpan, boolean subAggregator) {
        super((byte)4, chunkSpan, subAggregator);
        this.initSubAggregator();
        this.reset();
    }

    private void initSubAggregator() {
        if (this.subAggregator) {
            int subLevels = AggregateChunk.SUB_EVENT_SPAN.length;
            this.sub_sum = new double[subLevels][];
            this.sub_sumsq = new double[subLevels][];
            for (int i = 0; i < subLevels; ++i) {
                int subEventSpan = AggregateChunk.SUB_EVENT_SPAN[i];
                int bucketCount = AggregateChunk.AGGREGATE_EVENT_SPANS[0] / subEventSpan;
                this.sub_sum[i] = new double[bucketCount];
                this.sub_sumsq[i] = new double[bucketCount];
            }
        }
    }

    private void writeSubToStream(OutputStream outStream) throws IOException {
        if (this.subAggregator) {
            StreamUtils.writeLong((OutputStream)outStream, (long)this.count);
            int levels = this.sub_sum.length;
            StreamUtils.writeShort((OutputStream)outStream, (short)levels);
            for (int i = 0; i < levels; ++i) {
                StreamUtils.writeDoubleArray((OutputStream)outStream, (double[])this.sub_sum[i]);
                StreamUtils.writeDoubleArray((OutputStream)outStream, (double[])this.sub_sumsq[i]);
            }
        }
    }

    private void readSubFromStream(InputStream inStream) throws IOException {
        if (this.subAggregator) {
            this.count = StreamUtils.readLong((InputStream)inStream);
            int levels = StreamUtils.readShort((InputStream)inStream);
            for (int i = 0; i < levels; ++i) {
                StreamUtils.readDoubleArray((InputStream)inStream, (double[])this.sub_sum[i]);
                StreamUtils.readDoubleArray((InputStream)inStream, (double[])this.sub_sumsq[i]);
            }
        }
    }

    private void resetSubAggregator() {
        if (this.subAggregator) {
            this.count = 0L;
            int subLevels = AggregateChunk.SUB_EVENT_SPAN.length;
            for (int i = 0; i < subLevels; ++i) {
                Arrays.fill(this.sub_sum[i], 0.0);
                Arrays.fill(this.sub_sumsq[i], 0.0);
            }
        }
    }

    private void addSubAggregatorValue(Number number) {
        if (this.subAggregator) {
            int subLevels = AggregateChunk.SUB_EVENT_SPAN.length;
            for (int i = 0; i < subLevels; ++i) {
                int bucket = (int)(this.count / (long)AggregateChunk.SUB_EVENT_SPAN[i]);
                double[] dArray = this.sub_sum[i];
                int n = bucket;
                dArray[n] = dArray[n] + number.doubleValue();
                double[] dArray2 = this.sub_sumsq[i];
                int n2 = bucket;
                dArray2[n2] = dArray2[n2] + Math.pow(number.doubleValue(), 2.0);
            }
            ++this.count;
        }
    }

    private void addSubAggregateValue(Aggregator agg, long startIndex, long eventSpan) {
        int subLevels = AggregateChunk.SUB_EVENT_SPAN.length;
        for (int i = 0; i < subLevels; ++i) {
            if ((long)AggregateChunk.SUB_EVENT_SPAN[i] != eventSpan) continue;
            long subStartIndex = startIndex % (long)AggregateChunk.AGGREGATE_EVENT_SPANS[0];
            int bucket = (int)(subStartIndex / eventSpan);
            this.sumX += ((StandardDeviationAggregator)agg).sub_sum[i][bucket];
            this.sumXSqrd += ((StandardDeviationAggregator)agg).sub_sumsq[i][bucket];
            this.n += (double)eventSpan;
            this.count += eventSpan;
        }
    }

    @Override
    public Object getValue() {
        if (this.n == 0.0 || this.n == 1.0) {
            return new Double(Double.NaN);
        }
        double temp = this.n * this.sumXSqrd - Math.pow(this.sumX, 2.0);
        return new Double(Math.sqrt(temp /= this.n * (this.n - 1.0)));
    }

    @Override
    public void writeToStream(OutputStream outStream) throws IOException {
        StreamUtils.writeDouble((OutputStream)outStream, (double)this.n);
        StreamUtils.writeDouble((OutputStream)outStream, (double)this.sumXSqrd);
        StreamUtils.writeDouble((OutputStream)outStream, (double)this.sumX);
        this.writeSubToStream(outStream);
    }

    @Override
    public void readFromStream(InputStream inStream) throws IOException {
        this.n = StreamUtils.readDouble((InputStream)inStream);
        this.sumXSqrd = StreamUtils.readDouble((InputStream)inStream);
        this.sumX = StreamUtils.readDouble((InputStream)inStream);
        this.readSubFromStream(inStream);
    }

    @Override
    public void reset() {
        this.n = 0.0;
        this.sumXSqrd = 0.0;
        this.sumX = 0.0;
        this.resetSubAggregator();
    }

    @Override
    public void addValue(double timestamp, Object object, double previousTimestamp, Object previousObject) {
        if (object instanceof Number) {
            double value = ((Number)object).doubleValue();
            if (Double.isNaN(value)) {
                return;
            }
            this.addSubAggregatorValue((Number)object);
            this.sumXSqrd += Math.pow(value, 2.0);
            this.sumX += value;
            this.n += 1.0;
        }
    }

    @Override
    public void addAggregateValue(Aggregator agg, long startIndex, long eventSpan) {
        if (agg instanceof StandardDeviationAggregator) {
            if (eventSpan < (long)AggregateChunk.AGGREGATE_EVENT_SPANS[0]) {
                this.addSubAggregateValue(agg, startIndex, eventSpan);
            } else {
                StandardDeviationAggregator sagg = (StandardDeviationAggregator)agg;
                this.sumXSqrd += sagg.sumXSqrd;
                this.sumX += sagg.sumX;
                this.n += sagg.n;
            }
        }
    }
}

