/*
 * Decompiled with CFR 0.152.
 */
package utils.dataservice.gziplist.aggregator;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import utils.dataservice.gziplist.aggregator.AggregateQueryMetadata;
import utils.dataservice.gziplist.aggregator.Aggregator;
import utils.stream.StreamUtils;

public class BooleanDurationAggregator
extends Aggregator {
    private long trueDuration = -1L;
    private long firstValueMS = -1L;
    private long lastValueMS = -1L;
    private long trueStartMS = -1L;
    private boolean firstValue;
    private boolean lastValue;
    private boolean initialValue;

    protected BooleanDurationAggregator(int chunkSpan, boolean subAggregator, Object previousEvent) {
        super((byte)12, chunkSpan, subAggregator);
        if (previousEvent != null) {
            this.initialValue = (Boolean)previousEvent;
        }
    }

    @Override
    public Object getValue() {
        if (this.trueDuration == -1L) {
            return new Double(Double.NaN);
        }
        return new Double(this.trueDuration);
    }

    @Override
    public void writeToStream(OutputStream outStream) throws IOException {
        StreamUtils.writeLong((OutputStream)outStream, (long)this.trueDuration);
    }

    @Override
    public void readFromStream(InputStream inStream) throws IOException {
        this.trueDuration = StreamUtils.readLong((InputStream)inStream);
    }

    @Override
    public void reset() {
        this.trueDuration = -1L;
        this.firstValueMS = -1L;
        this.lastValueMS = -1L;
        this.firstValue = false;
        this.lastValue = false;
        this.trueStartMS = -1L;
    }

    @Override
    public void addValue(double timestamp, Object object, double previousTimestamp, Object previousObject) {
        if (object instanceof Boolean) {
            boolean newValue = (Boolean)object;
            if (this.firstValueMS == -1L) {
                this.firstValueMS = (long)timestamp;
                this.firstValue = newValue;
                this.lastValueMS = this.firstValueMS;
                this.lastValue = this.firstValue;
                if (this.firstValue) {
                    this.trueStartMS = this.firstValueMS;
                }
                return;
            }
            boolean previousValue = this.lastValue;
            this.lastValueMS = (long)timestamp;
            this.lastValue = newValue;
            if (previousValue && !newValue) {
                if (this.trueDuration == -1L) {
                    this.trueDuration = 0L;
                }
                this.trueDuration = (long)((double)this.trueDuration + (timestamp - (double)this.trueStartMS));
                this.trueStartMS = -1L;
            } else if (newValue && this.trueStartMS == -1L) {
                this.trueStartMS = (long)timestamp;
            }
        }
    }

    @Override
    public void addAggregateValue(Aggregator agg, long startIndex, long eventSpan) {
        if (agg instanceof BooleanDurationAggregator) {
            BooleanDurationAggregator trueAgg = (BooleanDurationAggregator)agg;
            if (trueAgg.trueDuration > -1L) {
                if (this.trueDuration == -1L) {
                    this.trueDuration = 0L;
                }
                this.trueDuration += trueAgg.trueDuration;
            }
        }
    }

    @Override
    public void finished(AggregateQueryMetadata metadata) {
        if (this.trueStartMS > -1L) {
            if (this.trueDuration == -1L) {
                this.trueDuration = 0L;
            }
            this.trueDuration = (long)((double)this.trueDuration + (metadata.endTime - (double)this.trueStartMS));
        }
        if (this.trueDuration == -1L) {
            this.trueDuration = 0L;
        }
        if (this.initialValue) {
            this.trueDuration = this.firstValueMS != -1L ? (long)((double)this.trueDuration + ((double)this.firstValueMS - metadata.startTime)) : (long)((double)this.trueDuration + (metadata.endTime - metadata.startTime));
        }
    }
}

