/*
 * Decompiled with CFR 0.152.
 */
package org.jdatepicker.graphics;

import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.UIManager;

public class JNextIcon
implements Icon {
    private int width;
    private int height;
    private int[] xPoints = new int[3];
    private int[] yPoints = new int[3];
    private boolean doubleArrow;
    private boolean enabled;

    public JNextIcon(int width, int height, boolean doubleArrow, boolean enabled) {
        this.setDimension(width, height);
        this.doubleArrow = doubleArrow;
        this.enabled = enabled;
    }

    public void setDoubleArrow(boolean doubleArrow) {
        this.doubleArrow = doubleArrow;
    }

    public boolean getDoubleArrow() {
        return this.doubleArrow;
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    public void setDimension(int width, int height) {
        this.width = width;
        this.height = height;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        if (this.enabled) {
            g.setColor(UIManager.getColor("textText"));
        } else {
            g.setColor(UIManager.getColor("textInactiveText"));
        }
        if (this.doubleArrow) {
            this.xPoints[0] = x + this.width / 2;
            this.yPoints[0] = y + this.height / 2;
            this.xPoints[1] = x;
            this.yPoints[1] = y - 1;
            this.xPoints[2] = x;
            this.yPoints[2] = y + this.height;
            g.fillPolygon(this.xPoints, this.yPoints, 3);
            this.xPoints[0] = x + this.width;
            this.yPoints[0] = y + this.height / 2;
            this.xPoints[1] = x + this.width / 2;
            this.yPoints[1] = y - 1;
            this.xPoints[2] = x + this.width / 2;
            this.yPoints[2] = y + this.height;
            g.fillPolygon(this.xPoints, this.yPoints, 3);
        } else {
            this.xPoints[0] = x + this.width;
            this.yPoints[0] = y + this.height / 2;
            this.xPoints[1] = x;
            this.yPoints[1] = y - 1;
            this.xPoints[2] = x;
            this.yPoints[2] = y + this.height;
            g.fillPolygon(this.xPoints, this.yPoints, 3);
        }
    }
}

