/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.x9;

import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;

public class X9FieldID
extends ASN1Object
implements X9ObjectIdentifiers {
    private ASN1ObjectIdentifier id;
    private ASN1Primitive parameters;

    public X9FieldID(BigInteger primeP) {
        this.id = prime_field;
        this.parameters = new ASN1Integer(primeP);
    }

    public X9FieldID(int m, int k1, int k2, int k3) {
        this.id = characteristic_two_field;
        ASN1EncodableVector fieldIdParams = new ASN1EncodableVector();
        fieldIdParams.add((ASN1Encodable)new ASN1Integer((long)m));
        if (k2 == 0) {
            fieldIdParams.add((ASN1Encodable)tpBasis);
            fieldIdParams.add((ASN1Encodable)new ASN1Integer((long)k1));
        } else {
            fieldIdParams.add((ASN1Encodable)ppBasis);
            ASN1EncodableVector pentanomialParams = new ASN1EncodableVector();
            pentanomialParams.add((ASN1Encodable)new ASN1Integer((long)k1));
            pentanomialParams.add((ASN1Encodable)new ASN1Integer((long)k2));
            pentanomialParams.add((ASN1Encodable)new ASN1Integer((long)k3));
            fieldIdParams.add((ASN1Encodable)new DERSequence(pentanomialParams));
        }
        this.parameters = new DERSequence(fieldIdParams);
    }

    public X9FieldID(ASN1Sequence seq) {
        this.id = (ASN1ObjectIdentifier)seq.getObjectAt(0);
        this.parameters = (ASN1Primitive)seq.getObjectAt(1);
    }

    public ASN1ObjectIdentifier getIdentifier() {
        return this.id;
    }

    public ASN1Primitive getParameters() {
        return this.parameters;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((ASN1Encodable)this.id);
        v.add((ASN1Encodable)this.parameters);
        return new DERSequence(v);
    }
}

