/*
 * Decompiled with CFR 0.152.
 */
package com.kitfox.svg;

import com.kitfox.svg.Group;
import com.kitfox.svg.RenderableElement;
import com.kitfox.svg.SVGElement;
import com.kitfox.svg.SVGElementException;
import com.kitfox.svg.SVGException;
import com.kitfox.svg.SVGLoaderHelper;
import com.kitfox.svg.xml.StyleAttribute;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

public class Mask
extends SVGElement {
    public static final String TAG_NAME = "mask";
    public static final int CP_USER_SPACE_ON_USE = 0;
    public static final int CP_OBJECT_BOUNDING_BOX = 1;
    int maskUnits = 1;
    int maskContentUnits = 0;
    int x;
    int y;
    int w;
    int h;
    private BufferedImage image = null;

    @Override
    public String getTagName() {
        return TAG_NAME;
    }

    @Override
    public void loaderAddChild(SVGLoaderHelper helper, SVGElement child) throws SVGElementException {
        super.loaderAddChild(helper, child);
    }

    @Override
    protected void build() throws SVGException {
        super.build();
        StyleAttribute sty = new StyleAttribute(this.colorOp);
        this.maskUnits = this.getPres(sty.setName("maskUnits")) && sty.getStringValue().equals("objectBoundingBox") ? 1 : 0;
        this.maskContentUnits = this.getPres(sty.setName("maskContentUnits")) && sty.getStringValue().equals("objectBoundingBox") ? 1 : 0;
        this.getPres(sty.setName("x"));
        int x = sty.getIntValue();
        this.getPres(sty.setName("y"));
        int y = sty.getIntValue();
        this.getPres(sty.setName("w"));
        int w = sty.getIntValue();
        this.getPres(sty.setName("h"));
        int h = sty.getIntValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage renderToImage(Graphics2D oldGraphics, Rectangle2D boundingBox) throws SVGException {
        boolean clear = false;
        if (this.image == null || (double)this.image.getWidth() < boundingBox.getWidth() || (double)this.image.getHeight() < boundingBox.getHeight()) {
            this.image = new BufferedImage((int)boundingBox.getWidth(), (int)boundingBox.getHeight(), 2);
        } else {
            clear = true;
        }
        Graphics2D g = this.image.createGraphics();
        if (clear) {
            AlphaComposite composite = AlphaComposite.getInstance(1, 0.0f);
            Composite old = g.getComposite();
            try {
                g.setComposite(composite);
                g.setColor(new Color(0, 0, 0, 0));
                g.fillRect(0, 0, this.image.getWidth(), this.image.getHeight());
            }
            finally {
                g.setComposite(old);
            }
        }
        g.translate(-boundingBox.getX(), -boundingBox.getY());
        for (SVGElement ele : this.children) {
            if (!(ele instanceof RenderableElement)) continue;
            RenderableElement rendEle = (RenderableElement)ele;
            if (!(ele instanceof Group)) {
                // empty if block
            }
            rendEle.render(g);
        }
        g.dispose();
        return this.image;
    }

    public BufferedImage getImage() {
        return this.image;
    }

    @Override
    public boolean updateTime(double curTime) throws SVGException {
        int newH;
        int newW;
        int newY;
        int newX;
        int newUnits;
        String newUnitsStrn;
        StyleAttribute sty = new StyleAttribute(this.colorOp);
        boolean shapeChange = false;
        if (this.getPres(sty.setName("maskUnits"))) {
            newUnitsStrn = sty.getStringValue();
            int n = newUnits = newUnitsStrn.equals("objectBoundingBox") ? 1 : 0;
            if (newUnits != this.maskUnits) {
                this.maskUnits = newUnits;
                shapeChange = true;
            }
        }
        if (this.getPres(sty.setName("maskContentUnits"))) {
            newUnitsStrn = sty.getStringValue();
            int n = newUnits = newUnitsStrn.equals("objectBoundingBox") ? 1 : 0;
            if (newUnits != this.maskContentUnits) {
                this.maskContentUnits = newUnits;
                shapeChange = true;
            }
        }
        if (this.getPres(sty.setName("x")) && (newX = sty.getIntValue()) != this.x) {
            this.x = newX;
            shapeChange = true;
        }
        if (this.getPres(sty.setName("y")) && (newY = sty.getIntValue()) != this.y) {
            this.y = newY;
            shapeChange = true;
        }
        if (this.getPres(sty.setName("w")) && (newW = sty.getIntValue()) != this.w) {
            this.w = newW;
            shapeChange = true;
        }
        if (this.getPres(sty.setName("h")) && (newH = sty.getIntValue()) != this.h) {
            this.h = newH;
            shapeChange = true;
        }
        if (shapeChange) {
            this.build();
        }
        for (Object aChildren : this.children) {
            SVGElement ele = (SVGElement)aChildren;
            ele.updateTime(curTime);
        }
        return shapeChange;
    }
}

