/*
 * Decompiled with CFR 0.152.
 */
package com.grahamedgecombe.jterminal.vt100;

import com.grahamedgecombe.jterminal.vt100.AnsiControlSequence;
import com.grahamedgecombe.jterminal.vt100.AnsiControlSequenceListener;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;

class AnsiControlSequenceParser {
    private static final char[] MULTI_CSI = new char[]{'\u001b', '['};
    private static final char[] OSC_CSI = new char[]{'\u001b', ']'};
    private static final char SINGLE_CSI = '\u009b';
    private StringBuilder buffer = new StringBuilder();
    private final AnsiControlSequenceListener listener;

    public AnsiControlSequenceParser(AnsiControlSequenceListener listener) {
        this.listener = listener;
    }

    public void parse(String str) {
        if (this.buffer.length() > 0) {
            str = this.buffer.toString().concat(str);
            this.buffer = new StringBuilder();
        }
        StringReader reader = new StringReader(str);
        try {
            try {
                this.parse(reader);
            }
            finally {
                ((Reader)reader).close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void parse(Reader reader) throws IOException {
        int character;
        StringBuilder text = new StringBuilder();
        while ((character = reader.read()) != -1) {
            boolean introducedControlSequence = false;
            if (character == 155) {
                introducedControlSequence = true;
            } else if (character == MULTI_CSI[0]) {
                int nextCharacter = reader.read();
                if (nextCharacter == -1) {
                    this.buffer.append((char)character);
                    break;
                }
                if (nextCharacter == OSC_CSI[1]) {
                    this.parseOSCSequence(reader);
                } else if (nextCharacter == MULTI_CSI[1]) {
                    introducedControlSequence = true;
                } else {
                    text.append((char)character);
                    text.append((char)nextCharacter);
                }
            } else if (character != 14 && character != 15) {
                text.append((char)character);
            }
            if (!introducedControlSequence) continue;
            if (text.length() > 0) {
                this.listener.parsedString(text.toString());
                text = new StringBuilder();
            }
            this.parseControlSequence(reader);
        }
        if (text.length() > 0) {
            this.listener.parsedString(text.toString());
        }
    }

    private void parseOSCSequence(Reader reader) throws IOException {
        reader.read();
        int prev = reader.read();
        if (prev == 7) {
            return;
        }
        int next = reader.read();
        while (next != 7 && prev != 27 && next != 92) {
            prev = next;
            next = reader.read();
        }
    }

    private void parseControlSequence(Reader reader) throws IOException {
        int character;
        boolean finishedSequence = false;
        StringBuilder parameters = new StringBuilder();
        while ((character = reader.read()) != -1) {
            if (character >= 97 && character <= 122 || character >= 65 && character <= 90) {
                String[] array = parameters.toString().split(";");
                AnsiControlSequence seq = new AnsiControlSequence((char)character, array);
                this.listener.parsedControlSequence(seq);
                finishedSequence = true;
                break;
            }
            parameters.append((char)character);
        }
        if (!finishedSequence) {
            this.buffer.append('\u009b');
            this.buffer.append((CharSequence)parameters);
        }
    }
}

