/*
 * Decompiled with CFR 0.152.
 */
package com.aem.utils.streamenc;

import com.aem.utils.streamenc.ChunkFilter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ChunkFilterOutputStream
extends OutputStream {
    ChunkFilter filter;
    OutputStream out;
    ByteArrayOutputStream bout = new ByteArrayOutputStream();

    public ChunkFilterOutputStream(OutputStream out, ChunkFilter filter) {
        this.out = out;
        this.filter = filter;
    }

    public ChunkFilterOutputStream(OutputStream out, ChunkFilter[] filters) {
        this.out = out;
        for (int i = filters.length - 1; i > 0; --i) {
            this.out = new ChunkFilterOutputStream(this.out, filters[i]);
        }
        this.filter = filters[0];
    }

    @Override
    public final void flush() throws IOException {
        if (this.bout.size() > 0) {
            this.writeChunk();
        }
        this.out.flush();
    }

    @Override
    public final void write(byte[] b) throws IOException {
        this.bout.write(b);
        if (this.bout.size() > 1024) {
            this.writeChunk();
        }
    }

    @Override
    public final void write(byte[] b, int off, int len) throws IOException {
        this.bout.write(b, off, len);
        if (this.bout.size() > 1024) {
            this.writeChunk();
        }
    }

    @Override
    public final void write(int b) throws IOException {
        this.bout.write(b);
        if (this.bout.size() > 1024) {
            this.writeChunk();
        }
    }

    private void writeChunk() throws IOException {
        this.filter.writeChunk(this.bout.toByteArray(), this.out);
        this.bout.reset();
    }
}

