/*
 * Decompiled with CFR 0.152.
 */
package com.aem.utils.sound;

import com.aem.utils.sound.SampledSound;
import java.util.ArrayList;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Control;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;

public class SoundUtils {
    public static boolean SOUND_PLAYER_DEBUG = false;

    public static boolean playSound(SampledSound sample, Mixer mixer) throws Exception {
        if (mixer == null) {
            return false;
        }
        Player p = new Player(sample, mixer);
        p.start();
        return true;
    }

    private static boolean playSound(SampledSound sample) throws Exception {
        return SoundUtils.playSound(sample, SoundUtils.getMixer(sample));
    }

    public static Mixer getSourceDataLineMixerByName(String name) {
        Mixer.Info[] mixers;
        for (Mixer.Info info : mixers = AudioSystem.getMixerInfo()) {
            if (!info.getName().equals(name)) continue;
            return AudioSystem.getMixer(info);
        }
        return null;
    }

    public static SourceDataLine getSourceDataLine(Mixer m, AudioFormat format) {
        try {
            return AudioSystem.getSourceDataLine(format, m.getMixerInfo());
        }
        catch (LineUnavailableException ex) {
            return null;
        }
    }

    public static SourceDataLine getSourceDataLine(AudioFormat format) {
        try {
            return AudioSystem.getSourceDataLine(format);
        }
        catch (LineUnavailableException ex) {
            return null;
        }
    }

    public static Mixer[] getMixersWithSourceDataLine() {
        Mixer.Info[] mixers;
        ArrayList<Mixer> result = new ArrayList<Mixer>();
        for (Mixer.Info info : mixers = AudioSystem.getMixerInfo()) {
            try {
                Mixer mixer = AudioSystem.getMixer(info);
                Line.Info[] sourceLineInfos = mixer.getSourceLineInfo();
                if (sourceLineInfos == null || sourceLineInfos.length <= 0) continue;
                for (Line.Info sourceLineInfo : sourceLineInfos) {
                    if (sourceLineInfo.getLineClass() != SourceDataLine.class) continue;
                    result.add(mixer);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return result.toArray(new Mixer[0]);
    }

    public static Mixer getMixer(SampledSound sample) {
        Mixer.Info[] mixers = AudioSystem.getMixerInfo();
        if (mixers == null || mixers.length == 0) {
            System.out.println("[SoundUtils] No audio mixers found.");
        } else {
            for (int i = 0; i < mixers.length; ++i) {
                DataLine.Info info;
                Mixer m;
                if (SOUND_PLAYER_DEBUG) {
                    System.out.println("[SoundUtils] Mixer " + i + ": " + mixers[i]);
                }
                if (!(m = AudioSystem.getMixer(mixers[i])).isLineSupported(info = new DataLine.Info(SourceDataLine.class, sample.format))) continue;
                return m;
            }
        }
        System.out.println("[SoundUtils] Unable to find suitable mixer");
        return null;
    }

    static class Player
    extends Thread {
        SampledSound sample;
        Mixer mixer;
        SourceDataLine line;
        float volume = 1.0f;
        float pitch_adjust = 0.0f;
        float balance = 0.5f;

        public Player(SampledSound sample, Mixer mixer) throws Exception {
            super("[SoundUtils]");
            this.sample = sample;
            this.mixer = mixer;
            this.init();
        }

        public Player(SampledSound sample, Mixer mixer, float volume, float balance, float pitch_adjust) throws Exception {
            super("[SoundUtils]");
            this.sample = sample;
            this.mixer = mixer;
            this.volume = volume;
            this.balance = balance;
            this.pitch_adjust = pitch_adjust;
            this.init();
        }

        public void init() throws Exception {
            DataLine.Info info = new DataLine.Info(SourceDataLine.class, this.sample.format);
            if (!this.mixer.isLineSupported(info)) {
                throw new Exception("[SoundUtils] Line (" + info.toString() + ") not supported by mixer");
            }
            this.line = (SourceDataLine)this.mixer.getLine(info);
            this.line.open(this.sample.format, 16384);
            FloatControl pitch = null;
            FloatControl gain = null;
            FloatControl pan = null;
            Control[] controls = this.line.getControls();
            for (int i = 0; i < controls.length; ++i) {
                Control.Type type = controls[i].getType();
                if (type == FloatControl.Type.MASTER_GAIN || type == FloatControl.Type.VOLUME) {
                    gain = (FloatControl)controls[i];
                } else if (type == FloatControl.Type.BALANCE || type == FloatControl.Type.PAN) {
                    pan = (FloatControl)controls[i];
                } else if (type == FloatControl.Type.SAMPLE_RATE) {
                    pitch = (FloatControl)controls[i];
                }
                if (!SOUND_PLAYER_DEBUG) continue;
                System.out.println("[SoundUtils] Control " + i + ": " + controls[i]);
            }
            if (pan != null) {
                float base = pan.getMinimum();
                float delta = pan.getMaximum() - base;
                pan.setValue(base + this.balance * delta);
            }
            if (pitch != null) {
                pitch.setValue(this.sample.format.getSampleRate() + this.pitch_adjust);
            }
        }

        @Override
        public void run() {
            this.line.start();
            this.line.write(this.sample.data, 0, this.sample.data.length);
            this.line.drain();
            if (this.line != null) {
                this.line.stop();
            }
            if (this.line != null) {
                this.line.flush();
            }
            if (this.line != null) {
                this.line.close();
            }
        }
    }
}

