/*
 * Decompiled with CFR 0.152.
 */
package com.aem.utils.rsa;

import com.aem.utils.rsa.RSAConstants;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;

public class RSAEncryptor
implements RSAConstants {
    private int MAXBITS = 960;
    private int MAXLEN = this.MAXBITS / 8;
    private BigInteger BASE = new BigInteger("2").pow(this.MAXBITS);
    private BigInteger[] key;

    public RSAEncryptor(BigInteger[] public_key) {
        this.key = public_key;
        BigInteger n = this.key[0];
        this.MAXBITS = (int)((double)n.bitLength() * 0.9);
        this.MAXLEN = this.MAXBITS / 8;
        this.MAXBITS = this.MAXLEN * 8;
        this.BASE = new BigInteger("2").pow(this.MAXBITS);
    }

    private void encryptAndWrite(BigInteger toencrypt, OutputStream out) throws IOException {
        toencrypt = toencrypt.add(this.BASE);
        toencrypt = toencrypt.modPow(this.key[1], this.key[0]);
        byte[] b = toencrypt.toByteArray();
        int x = b.length;
        out.write((byte)(x >>> 24 & 0xFF));
        out.write((byte)(x >>> 16 & 0xFF));
        out.write((byte)(x >>> 8 & 0xFF));
        out.write((byte)(x >>> 0 & 0xFF));
        out.write(b);
    }

    public byte[] encrypt(byte[] data) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try {
            byte[] tmp = new byte[this.MAXLEN];
            this.encryptAndWrite(new BigInteger("" + data.length), bout);
            for (int n = 0; n < data.length; n += this.MAXLEN) {
                for (int i = 0; i < tmp.length; ++i) {
                    tmp[i] = 0;
                }
                System.arraycopy(data, n, tmp, 0, Math.min(tmp.length, data.length - n));
                BigInteger intdat = new BigInteger(tmp);
                this.encryptAndWrite(intdat, bout);
            }
        }
        catch (IOException e) {
            return null;
        }
        return bout.toByteArray();
    }
}

