/*
 * Decompiled with CFR 0.152.
 */
package com.aem.utils.random;

import com.aem.utils.BMPFile;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.FileOutputStream;
import java.util.Random;

public abstract class GenericRandom
extends Random {
    private boolean normalise = true;
    private long norm = 0L;

    public abstract void init();

    public abstract void init(int var1);

    public abstract void init(long var1);

    public abstract void init(int[] var1);

    public void init(byte[] seed) {
        int[] c = new int[seed.length / 4];
        int bi = 0;
        for (int i = 0; i < c.length; ++i) {
            c[i] = seed[bi++] << 24;
            c[i] = c[i] | seed[bi++] << 16;
            c[i] = c[i] | seed[bi++] << 8;
            c[i] = c[i] | seed[bi++];
        }
        this.init(c);
    }

    public abstract void addEntropy(int var1);

    public abstract void addEntropy(long var1);

    public abstract void addEntropy(int[] var1);

    public abstract int getMaximumSeedComplexity();

    public final void setNormalise(boolean b) {
        this.normalise = b;
    }

    public final boolean getNormalise() {
        return this.normalise;
    }

    public abstract boolean isCryptographicallySecure();

    protected abstract int nextUniformInt();

    @Override
    public final int nextInt() {
        int i = this.nextUniformInt();
        if (this.normalise) {
            this.norm = this.nextUniformInt();
            if (this.norm < 0L) {
                this.norm = -this.norm;
            }
            i = i < 0 ? (int)((long)i + this.norm) : (int)((long)i - this.norm);
        }
        return i;
    }

    @Override
    public final long nextLong() {
        long l = this.nextInt();
        l <<= 32;
        return l |= (long)this.nextInt() & 0xFFFFFFFFFFFFFFFFL;
    }

    public final short nextShort() {
        short s = (short)(this.nextInt() >>> 16);
        return s;
    }

    public final byte nextByte() {
        byte b = (byte)(this.nextInt() >>> 24);
        return b;
    }

    public final byte[] nextBytes(int n) {
        byte[] b = new byte[n];
        this.nextBytes(b);
        return b;
    }

    @Override
    public final void nextBytes(byte[] b) {
        int n;
        int len = b.length / 4;
        for (int i = 0; i < len; ++i) {
            n = this.nextInt();
            b[4 * i] = (byte)(n >> 24 & 0xFF);
            b[4 * i + 1] = (byte)(n >> 16 & 0xFF);
            b[4 * i + 2] = (byte)(n >> 8 & 0xFF);
            b[4 * i + 3] = (byte)(n & 0xFF);
        }
        n = this.nextInt();
        len = b.length % 4;
        if (len > 0) {
            b[b.length - 1] = (byte)(n >> 24 & 0xFF);
        }
        if (len > 1) {
            b[b.length - 2] = (byte)(n >> 16 & 0xFF);
        }
        if (len > 2) {
            b[b.length - 3] = (byte)(n >> 8 & 0xFF);
        }
    }

    @Override
    public final float nextFloat() {
        return Float.intBitsToFloat(this.nextInt());
    }

    @Override
    public final double nextDouble() {
        return Double.longBitsToDouble(this.nextLong());
    }

    @Override
    public void setSeed(long seed) {
        this.init(seed);
    }

    @Override
    public double nextGaussian() {
        boolean b = this.getNormalise();
        this.setNormalise(true);
        double d = this.nextDouble();
        this.setNormalise(b);
        return d;
    }

    public final int numbersPerSec() {
        this.nextInt();
        long MINTIME = 1000L;
        int MAX = 50;
        long t = 0L;
        while (t < MINTIME) {
            MAX *= 2;
            t = System.currentTimeMillis();
            for (int i = 0; i < MAX; ++i) {
                this.nextInt();
            }
            t = System.currentTimeMillis() - t;
        }
        System.out.println("Numbers = " + MAX + ", t = " + t + "ms");
        double d = t;
        d /= 1000.0;
        d = (double)MAX / d;
        return (int)d;
    }

    public static void main(String[] args) {
        int i;
        if (args.length < 1) {
            System.out.println("Usage: java GenericRandom <-bmp> <class e.g.\"ISAAC\">");
            System.exit(0);
        }
        boolean BMP = false;
        for (i = 0; i < args.length; ++i) {
            if (!args[i].equalsIgnoreCase("-bmp")) continue;
            BMP = true;
            System.arraycopy(args, i + 1, args, i, args.length - i - 1);
            args[i - 1] = "";
            break;
        }
        for (i = 0; i < args.length; ++i) {
            try {
                int j;
                Class<?> c = Class.forName(args[i]);
                GenericRandom gr = (GenericRandom)c.newInstance();
                gr.setNormalise(false);
                System.out.println(c + " can generate " + gr.numbersPerSec() + " numbers per second");
                BufferedImage bmp = new BufferedImage(1000, 1000, 1);
                Graphics g = bmp.getGraphics();
                g.setColor(Color.white);
                g.fillRect(0, 0, 1000, 1000);
                g.setColor(new Color(0, 0, 0, 40));
                long div = Integer.MAX_VALUE;
                div -= Integer.MIN_VALUE;
                div /= 1000L;
                if (BMP) {
                    long y;
                    long x;
                    int h;
                    gr.setNormalise(false);
                    for (h = 0; h < 1000000; ++h) {
                        x = gr.nextInt();
                        x -= Integer.MIN_VALUE;
                        y = gr.nextInt();
                        y -= Integer.MIN_VALUE;
                        g.fillRect((int)(x /= div), (int)(y /= div), 1, 1);
                    }
                    BMPFile.saveBitmap(c.getName() + "_uniform.bmp", bmp, 1000, 1000);
                    System.out.println(c + " wrote uniform distribution BMP ok");
                    gr.setNormalise(true);
                    for (h = 0; h < 1000000; ++h) {
                        x = gr.nextInt();
                        x -= Integer.MIN_VALUE;
                        y = gr.nextInt();
                        y -= Integer.MIN_VALUE;
                        g.fillRect((int)(x /= div), (int)(y /= div), 1, 1);
                    }
                    BMPFile.saveBitmap(c.getName() + "_normal.bmp", bmp, 1000, 1000);
                    System.out.println(c + " wrote normal distribution BMP ok");
                }
                int s1 = -1412623820;
                long s2 = -1412623820L;
                int[] s3 = new int[]{-1412623820, 0, 305419896};
                int[] s4 = new int[]{0, -1412623820, 305419896};
                int rlen = 50;
                int[] rands = new int[rlen * 4];
                int off = 0;
                gr.init(s1);
                for (j = 0; j < rlen; ++j) {
                    rands[off + j] = gr.nextInt();
                }
                off += rlen;
                gr.init(s2);
                for (j = 0; j < rlen; ++j) {
                    rands[off + j] = gr.nextInt();
                }
                off += rlen;
                gr.init(s3);
                for (j = 0; j < rlen; ++j) {
                    rands[off + j] = gr.nextInt();
                }
                off += rlen;
                gr.init(s4);
                for (j = 0; j < rlen; ++j) {
                    rands[off + j] = gr.nextInt();
                }
                for (j = 0; j < rands.length; ++j) {
                    for (int k = j + 1; k < rands.length; ++k) {
                        if (rands[j] != rands[k]) continue;
                        System.out.println("Warning - " + j + " = " + k);
                    }
                }
                rands = new int[50];
                gr.init(s1);
                for (j = 0; j < rands.length; ++j) {
                    rands[j] = gr.nextInt();
                }
                gr.init(s1);
                for (j = 0; j < rands.length; ++j) {
                    if (rands[j] == gr.nextInt()) continue;
                    System.out.println("s1 init error @ " + j);
                }
                gr.init(s2);
                for (j = 0; j < rands.length; ++j) {
                    rands[j] = gr.nextInt();
                }
                gr.init(s2);
                for (j = 0; j < rands.length; ++j) {
                    if (rands[j] == gr.nextInt()) continue;
                    System.out.println("s2 init error @ " + j);
                }
                gr.init(s3);
                for (j = 0; j < rands.length; ++j) {
                    rands[j] = gr.nextInt();
                }
                gr.init(s3);
                for (j = 0; j < rands.length; ++j) {
                    if (rands[j] == gr.nextInt()) continue;
                    System.out.println("s3 init error @ " + j);
                }
                gr.init(s4);
                for (j = 0; j < rands.length; ++j) {
                    rands[j] = gr.nextInt();
                }
                gr.init(s4);
                for (j = 0; j < rands.length; ++j) {
                    if (rands[j] == gr.nextInt()) continue;
                    System.out.println("s4 init error @ " + j);
                }
                gr.init();
                FileOutputStream fout = new FileOutputStream(c.getName() + ".ent");
                fout.write(gr.nextBytes(1024000));
                fout.close();
                continue;
            }
            catch (Exception e) {
                System.out.println("Error loading " + args[i] + " " + e);
                e.printStackTrace();
            }
        }
    }
}

