/*
 * Decompiled with CFR 0.152.
 */
package com.aem.utils.os;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.TimeZone;
import jwrapper.jwutils.JWGenericOS;

public class SystemInfo {
    private static int DEFLEN = 18;

    private static String padString(String s) {
        StringBuffer sb = new StringBuffer();
        sb.append(s);
        while (sb.length() < DEFLEN) {
            sb.append(' ');
        }
        return sb.toString();
    }

    public static String getJVMInfo() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(SystemInfo.padString("Java Version: ") + System.getProperty("java.version") + " (" + System.getProperty("java.vendor") + " - " + System.getProperty("java.runtime.version") + ")\n");
        buffer.append(SystemInfo.padString("JavaVM: ") + System.getProperty("java.vm.name") + " " + System.getProperty("java.vm.version") + " (" + System.getProperty("java.vm.vendor") + ")\n");
        return buffer.toString();
    }

    private static String getDefaultCharSet() {
        String enc = "-";
        try {
            OutputStreamWriter writer = new OutputStreamWriter(new ByteArrayOutputStream());
            enc = writer.getEncoding();
            writer.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return enc;
    }

    public static String getEnvironmentInfo() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(SystemInfo.padString("Current Dir: ") + new File(".").getAbsoluteFile().getParentFile().getAbsolutePath() + "\n");
        buffer.append(SystemInfo.padString("Classpath: ") + System.getProperty("java.class.path") + "\n");
        buffer.append(SystemInfo.padString("Ext Dirs: ") + System.getProperty("java.ext.dirs") + "\n");
        buffer.append(SystemInfo.padString("Temp Dir: ") + System.getProperty("java.io.tmpdir") + "\n");
        buffer.append(SystemInfo.padString("Separators: ") + System.getProperty("file.separator") + " " + System.getProperty("path.separator") + "\n");
        buffer.append(SystemInfo.padString("File Encoding: ") + System.getProperty("file.encoding") + "\n");
        buffer.append(SystemInfo.padString("Default Charset: ") + Charset.defaultCharset() + "\n");
        buffer.append(SystemInfo.padString("Default Charset in Use: ") + SystemInfo.getDefaultCharSet() + "\n");
        buffer.append(SystemInfo.padString("Headless AWT: ") + System.getProperty("java.awt.headless") + "\n");
        try {
            buffer.append(SystemInfo.padString("Line Separator: ") + System.getProperty("line.separator").charAt(0) + " (ASCII value)\n");
        }
        catch (Exception e) {
            buffer.append(SystemInfo.padString("Line Separator: ") + "(error - " + e + ")\n");
        }
        return buffer.toString();
    }

    public static String getOSInfo() {
        Runtime runtime = Runtime.getRuntime();
        StringBuffer buffer = new StringBuffer();
        String osname = System.getProperty("os.name");
        try {
            osname = JWGenericOS.getInstance().getOSName();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        buffer.append(SystemInfo.padString("OS: ") + osname + " " + System.getProperty("os.version") + " (" + System.getProperty("os.arch") + ") (" + runtime.availableProcessors() + " cores))\n");
        return buffer.toString();
    }

    public static String getUserInfo() {
        return SystemInfo.padString("User: ") + System.getProperty("user.name") + "\n" + SystemInfo.padString("User Home: ") + System.getProperty("user.home") + "\n" + SystemInfo.padString("User Dir: ") + System.getProperty("user.dir") + "\n";
    }

    public static String getMemoryInfo() {
        Runtime runtime = Runtime.getRuntime();
        return SystemInfo.padString("Memory: ") + "Max=" + runtime.maxMemory() + ", Total=" + runtime.totalMemory() + ", Free=" + runtime.freeMemory() + "\n";
    }

    public static String getLocaleInfo() {
        return SystemInfo.padString("Language: ") + System.getProperty("user.country") + " (" + System.getProperty("user.language") + ", " + Locale.getDefault() + ", " + TimeZone.getDefault().getDisplayName() + ")\n";
    }

    public static String getBrowserInfo() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(SystemInfo.padString("Browser: ") + System.getProperty("browser") + " " + System.getProperty("browser.version") + " (" + System.getProperty("browser.vendor") + ")\n");
        return buffer.toString();
    }

    public static String getFullInfo() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(SystemInfo.getJVMInfo());
        buffer.append(SystemInfo.getMemoryInfo());
        buffer.append(SystemInfo.getOSInfo());
        buffer.append(SystemInfo.getBrowserInfo());
        buffer.append(SystemInfo.getUserInfo());
        buffer.append(SystemInfo.getEnvironmentInfo());
        buffer.append(SystemInfo.getLocaleInfo());
        return buffer.toString();
    }

    public static void main(String[] args) {
        System.out.println(SystemInfo.getFullInfo());
    }
}

