/*
 * Decompiled with CFR 0.152.
 */
package com.aem.utils.blowfish;

import com.aem.utils.blowfish.Blowfish;
import com.aem.utils.blowfish.BlowfishDecryptionStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Random;

public class BlowfishEncryptionStream
extends FilterOutputStream {
    public static final int MIN_BLOCK_SIZE = 512;
    public static final int DEFAULT_BLOCK_SIZE = 16384;
    private int MAX_BLOCK_SIZE = 16384;
    private byte[] buffer = null;
    private int buffered = 0;
    private Blowfish bf;
    private OutputStream out;

    public BlowfishEncryptionStream(OutputStream out, byte[] key) {
        this(out, key, 16384);
    }

    public BlowfishEncryptionStream(OutputStream out, byte[] key, int blocksiz) {
        super(out);
        this.out = out;
        if (blocksiz < 512) {
            blocksiz = 512;
        }
        this.MAX_BLOCK_SIZE = blocksiz;
        this.buffer = new byte[blocksiz];
        this.bf = new Blowfish();
        this.bf.init(key);
    }

    public BlowfishEncryptionStream(OutputStream out, byte[] key, boolean old) {
        this(out, key);
    }

    public BlowfishEncryptionStream(OutputStream out, String key) {
        this(out, key, 16384);
    }

    public BlowfishEncryptionStream(OutputStream out, String key, int blocksiz) {
        super(out);
        this.out = out;
        if (blocksiz < 512) {
            blocksiz = 512;
        }
        this.MAX_BLOCK_SIZE = blocksiz;
        this.buffer = new byte[blocksiz];
        this.bf = new Blowfish();
        this.bf.init(key);
    }

    public BlowfishEncryptionStream(OutputStream out, Blowfish bf) {
        super(out);
        this.out = out;
        int blocksiz = 16384;
        if (blocksiz < 512) {
            blocksiz = 512;
        }
        this.MAX_BLOCK_SIZE = blocksiz;
        this.buffer = new byte[blocksiz];
        this.bf = bf;
    }

    public void resetToSupportTestError() {
        this.bf.test();
    }

    @Override
    public void close() throws IOException {
        this.flush();
        super.close();
    }

    @Override
    public void flush() throws IOException {
        this.writeBuffer();
        this.out.flush();
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        int max = off + len;
        int index = off;
        while (this.buffered + (max - index) > this.MAX_BLOCK_SIZE) {
            System.arraycopy(b, index, this.buffer, this.buffered, this.MAX_BLOCK_SIZE - this.buffered);
            index += this.MAX_BLOCK_SIZE - this.buffered;
            this.buffered = this.MAX_BLOCK_SIZE;
            this.writeBuffer();
        }
        System.arraycopy(b, index, this.buffer, this.buffered, max - index);
        this.buffered += max - index;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.buffered == this.MAX_BLOCK_SIZE) {
            this.writeBuffer();
        }
        this.buffer[this.buffered++] = (byte)b;
    }

    private void writeBuffer() throws IOException {
        int i;
        if (this.buffered == 0) {
            return;
        }
        int len = this.buffered;
        int rounded_len = len / 8 * 8;
        if (len % 8 > 0) {
            rounded_len += 8;
        }
        int shift = 32;
        for (i = 0; i < 4; ++i) {
            this.out.write((byte)(4 + rounded_len >>> (shift -= 8)));
        }
        shift = 32;
        for (i = 0; i < 4; ++i) {
            this.out.write((byte)(len >>> (shift -= 8)));
        }
        this.bf.streamSecure(this.buffer, this.buffered, this.out, true);
        this.buffered = 0;
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println("usage BlowfishEncryptionStream <test string size>");
            return;
        }
        int size = Integer.parseInt(args[0]);
        try {
            BlowfishEncryptionStream.testOneByteRead(size, -1);
            BlowfishEncryptionStream.testBufferRead(size, -1);
            BlowfishEncryptionStream.testOneByteRead(size, 1024);
            BlowfishEncryptionStream.testBufferRead(size, 1024);
            BlowfishEncryptionStream.testOneByteRead(size, size * 2);
            BlowfishEncryptionStream.testBufferRead(size, size * 2);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void testOneByteRead(int size, int block) {
        System.out.println("Testing one byte reading with data size " + size + ", block size " + block);
        try {
            byte[] data = new byte[size];
            byte[] key = new byte[72];
            Random r = new Random(5555L);
            Random rr = new Random(6666L);
            r.nextBytes(data);
            rr.nextBytes(key);
            byte[] orig = new byte[size];
            System.arraycopy(data, 0, orig, 0, size);
            ByteArrayOutputStream e_out = new ByteArrayOutputStream();
            BlowfishEncryptionStream f_out = new BlowfishEncryptionStream((OutputStream)e_out, key, block);
            f_out.write(data);
            f_out.flush();
            ByteArrayInputStream e_in = new ByteArrayInputStream(e_out.toByteArray());
            BlowfishDecryptionStream f_in = new BlowfishDecryptionStream((InputStream)e_in, key);
            int i = 0;
            while (true) {
                int n;
                if ((n = f_in.read()) == -1) break;
                if ((byte)n != orig[i]) {
                    System.out.println("Error - data changed (" + i + ", " + (byte)n + ", " + orig[i] + ")");
                    System.exit(0);
                }
                ++i;
            }
            System.out.println("EOF");
            if (i < orig.length) {
                System.out.println("EOF premature (" + i + " < " + orig.length + ")");
            } else {
                System.out.println("data ok");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void testBufferRead(int size, int block) {
        System.out.println("Testing buffer reading with data size " + size + ", block size " + block);
        try {
            byte[] data = new byte[size];
            byte[] key = new byte[72];
            Random r = new Random(5555L);
            Random rr = new Random(6666L);
            r.nextBytes(data);
            rr.nextBytes(key);
            byte[] orig = new byte[size];
            System.arraycopy(data, 0, orig, 0, size);
            ByteArrayOutputStream e_out = new ByteArrayOutputStream();
            BlowfishEncryptionStream f_out = new BlowfishEncryptionStream((OutputStream)e_out, key, block);
            f_out.write(data);
            f_out.flush();
            ByteArrayInputStream e_in = new ByteArrayInputStream(e_out.toByteArray());
            BlowfishDecryptionStream f_in = new BlowfishDecryptionStream((InputStream)e_in, key);
            int i = 0;
            byte[] buff = new byte[1024];
            int n = 0;
            while (n != -1) {
                n = f_in.read(buff, 0, buff.length);
                if (n > 0) {
                    for (int x = 0; x < n; ++x) {
                        if (buff[x] != orig[i]) {
                            System.out.println("Error - data changed (" + i + ", " + buff[x] + ", " + orig[i] + ")");
                            System.exit(0);
                        }
                        ++i;
                    }
                    continue;
                }
                System.out.println("n = 0");
            }
            System.out.println("EOF");
            if (i < orig.length) {
                System.out.println("EOF premature (" + i + " < " + orig.length + ")");
            } else {
                System.out.println("data ok");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

