/*
 * Decompiled with CFR 0.152.
 */
package com.aem.utils.authentication;

import com.aem.utils.authentication.AuthenticationRequest;
import com.aem.utils.authentication.AuthenticationResult;
import java.util.ArrayList;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ServerAuthenticationHandler {
    private static final ThreadPoolExecutor executorService = new ThreadPoolExecutor(0, 100, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
    public static final int STRATEGY_SEQUENTIAL = 0;
    public static final int STRATEGY_STAGGERED = 1;
    private final int strategy;
    private final int delay;

    public ServerAuthenticationHandler() {
        this(1, 1000);
    }

    public ServerAuthenticationHandler(int strategy, int delay) {
        this.strategy = strategy;
        this.delay = delay;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuthenticationResult authenticateUser(AuthenticationRequest[] requests) {
        System.out.println("[ServerAuthenticationHandler] Attempting " + requests.length + " authentication requests...");
        if (this.strategy == 0) {
            System.out.println("[ServerAuthenticationHandler] Sequentially authenticating");
            for (AuthenticationRequest request : requests) {
                try {
                    return request.authenticate();
                }
                catch (ServerConnectException ex) {
                    System.out.println("[ServerAuthenticationHandler] Authentication server unavailable (" + ex.getMessage() + ")");
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    System.out.println("[ServerAuthenticationHandler] Authentication failed (" + ex.getMessage() + ")");
                    return new AuthenticationResult(false);
                }
            }
        } else {
            System.out.println("[ServerAuthenticationHandler] Staggered authentication");
            ArrayList<Future<AuthenticationResult>> allResults = new ArrayList<Future<AuthenticationResult>>();
            ArrayList<AuthenticationRequest> allRequests = new ArrayList<AuthenticationRequest>();
            for (AuthenticationRequest request : requests) {
                allRequests.add(request);
                Future<AuthenticationResult> futureResult = executorService.submit(request);
                allResults.add(futureResult);
                Object object = request.requestSempahore.finishedLock;
                synchronized (object) {
                    AuthenticationRequest connectedRequest = null;
                    int sleepSoFar = 0;
                    while (connectedRequest == null && sleepSoFar < this.delay) {
                        sleepSoFar += 100;
                        try {
                            request.requestSempahore.finishedLock.wait(sleepSoFar);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        connectedRequest = this.getConnectedRequest(allRequests);
                    }
                    if (connectedRequest != null) {
                        System.out.println("[ServerAuthenticationHandler] Identified connected request - cancelling others...");
                        for (int i = 0; i < allRequests.size(); ++i) {
                            AuthenticationRequest otherRequest = allRequests.get(i);
                            if (connectedRequest != otherRequest) {
                                allResults.get(i).cancel(false);
                                System.out.println("[ServerAuthenticationHandler] Cancelled " + allResults.get(i));
                                continue;
                            }
                            System.out.println("[ServerAuthenticationHandler] Keeping " + allResults.get(i));
                        }
                        break;
                    }
                }
            }
            System.out.println("[ServerAuthenticationHandler] Waiting for connected request to return");
            AuthenticationResult res = this.waitForResult(allResults);
            System.out.println("[ServerAuthenticationHandler] Received a connected request response: " + res);
            if (res != null) {
                return res;
            }
        }
        return new AuthenticationResult(false);
    }

    private AuthenticationRequest getConnectedRequest(ArrayList<AuthenticationRequest> allRequests) {
        for (AuthenticationRequest request : allRequests) {
            if (!request.connected) continue;
            return request;
        }
        return null;
    }

    private AuthenticationResult waitForResult(ArrayList<Future<AuthenticationResult>> allResults) {
        for (Future<AuthenticationResult> result : allResults) {
            if (result.isCancelled()) continue;
            try {
                return result.get();
            }
            catch (Exception ex) {
                if (ex instanceof ExecutionException && ex.getCause() != null && ex.getCause() instanceof CancelledException || ex instanceof CancellationException) {
                    System.out.println("[ServerAuthenticationHandler] waitForResult is skipping a cancelled task.");
                    continue;
                }
                ex.printStackTrace();
            }
        }
        return null;
    }

    public static class CancelledException
    extends Exception {
    }

    public static class ServerConnectException
    extends Exception {
        public ServerConnectException(String message) {
            super(message);
        }
    }
}

