/*
 * Decompiled with CFR 0.152.
 */
package com.aem.utils;

import com.aem.utils.NativeLibraryLoader;
import com.aem.utils.NativeMacUtils;
import com.aem.utils.NativeUtilsMonitor;
import java.awt.AWTException;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.Window;
import java.io.File;
import utils.ostools.OS;

public class NativeUtils {
    public static int SIMKEY_DOWN = 0;
    public static int SIMKEY_UP = 2;
    public static int TS_GET_SESSION_FAILED = -999;
    private static boolean firstRun = true;
    static NativeUtils nutils;
    static Object LOCK;
    public static final int BUTTON_LEFT = 0;
    public static final int BUTTON_MIDDLE = 1;
    public static final int BUTTON_RIGHT = 2;
    private Thread blankScreenThread = null;
    private Thread monitorOffThread = null;
    private Object BLANK_SCREEN_LOCK = new Object();
    private Object MONITOR_OFF_LOCK = new Object();
    public static final int VK_TAB = 9;
    public static final int VK_WINL = 91;
    public static final int VK_WINR = 92;
    public static final int VK_ALTR = 165;
    public static final int VK_ALTL = 164;
    public static final int VK_ALT = 18;
    public static final int VK_ESCAPE = 27;
    private static Robot robot;

    private NativeUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NativeUtils getInstance() {
        Object object = LOCK;
        synchronized (object) {
            if (nutils == null) {
                if (NativeLibraryLoader.isNativeLibraryLoadedOK()) {
                    NativeUtils nutils;
                    block9: {
                        nutils = new NativeUtils();
                        try {
                            nutils.getPointerX();
                            System.out.println("[NativeUtils] loaded OK, storing global copy");
                        }
                        catch (Throwable t) {
                            nutils = null;
                            if (!firstRun) break block9;
                            firstRun = false;
                            System.out.println("[NativeUtils] Library loaded but getPointer has not been implemented");
                        }
                    }
                    NativeUtils.nutils = nutils;
                } else if (firstRun) {
                    firstRun = false;
                    System.out.println("[NativeUtils] unable to load since NativeLibraryLoader was not successful");
                }
            }
        }
        return nutils;
    }

    public static void nonNativeLogOff() {
        try {
            Runtime.getRuntime().exec(new String[]{"rundll32.exe", "shell32.dll,", "SHExitWindowsEx"});
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void nonNativeRestart() {
        try {
            Runtime.getRuntime().exec(new String[]{"rundll32.exe", "shell32.dll,", "SHExitWindowsEx", "2"});
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void nonNativeShutdown() {
        try {
            Runtime.getRuntime().exec(new String[]{"rundll32.exe", "shell32.dll,", "SHExitWindowsEx", "3"});
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void nonNativeLockScreen() {
        try {
            Runtime.getRuntime().exec(new String[]{"rundll32.exe", "user32.dll,", "LockWorkStation"});
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public native void dumpLastError();

    public native int disableHardwareAcceleration();

    public native int restoreHardwareAcceleration();

    public native int windowsNativeBitmapGrabBytes(byte[] var1, int var2);

    public native int windowsNativeBitmapGrabInts(int[] var1, int var2);

    public native void setPointerBySendInputNormalizedCoords(int var1, int var2);

    public native void setPointerBySetCursorPos(int var1, int var2);

    public native void setPointerBySetPhysicalCursorPos(int var1, int var2);

    public native void printScreenSizes();

    public native void logicalToPhysicalPoint(Point var1);

    public native void physicalToLogicalPoint(Point var1);

    public native NativeUtilsMonitor[] getMonitorSizes();

    public void mouseDown(int button) {
        if (OS.isWindowsVistaOrAbove()) {
            this.mouseDownWithSENDINPUT(button);
        } else {
            this.mouseDownWithMOUSEEVENT(button);
        }
    }

    public void mouseUp(int button) {
        if (OS.isWindowsVistaOrAbove()) {
            this.mouseUpWithSENDINPUT(button);
        } else {
            this.mouseUpWithMOUSEEVENT(button);
        }
    }

    public native void mouseDownWithMOUSEEVENT(int var1);

    public native void mouseUpWithMOUSEEVENT(int var1);

    public native void mouseDownWithSENDINPUT(int var1);

    public native void mouseUpWithSENDINPUT(int var1);

    public native int getPointerX();

    public native int getPointerY();

    public native int getCaretX();

    public native int getCaretY();

    public native void debugPrintWindowsSessionInfo();

    public native void doCtrlAltDel();

    public native boolean is32Bit();

    public native void setDPIAware();

    public native boolean isNumLockOn();

    public native boolean isKeyStateOn(int var1);

    public void setFrameAlwaysOnTop(Frame window) {
        this.setForceOnTop(window.getTitle());
    }

    public void setWindowAlwaysOnTop(Window window) {
        window.setAlwaysOnTop(true);
    }

    public native String getWindowsEnv(String var1);

    public native void setForceOnTop(String var1);

    public native void createDesktop(String var1, String var2, String var3);

    public native void destroyDesktop();

    public native void switchToNextWindowStation();

    public native void switchToNextDesktop();

    public native void switchWallpaperOn();

    public native void switchWallpaperOff();

    public native void pickupWallpaperChange(int var1, String var2);

    public native void setUacToInsecureDesktop();

    public native void setUacToSecureDesktop();

    public native void jiggleMouseBySendInput();

    private native void enableBlankScreen(String var1);

    private native void disableBlankScreen();

    private native void enableMonitorOff();

    private native void disableMonitorOff();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopBlankScreenThread() {
        Object object = this.BLANK_SCREEN_LOCK;
        synchronized (object) {
            this.disableBlankScreen();
            if (this.blankScreenThread == null) {
                return;
            }
            try {
                this.blankScreenThread.join(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.blankScreenThread = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startBlankScreenThread(final File imageLocation) {
        Object object = this.BLANK_SCREEN_LOCK;
        synchronized (object) {
            if (this.blankScreenThread != null && this.blankScreenThread.isAlive()) {
                return;
            }
            this.blankScreenThread = new Thread(){

                @Override
                public void run() {
                    if (imageLocation != null) {
                        NativeUtils.this.enableBlankScreen(imageLocation.getAbsolutePath());
                    } else {
                        NativeUtils.this.enableBlankScreen(null);
                    }
                }
            };
            this.blankScreenThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startMonitorOffThread() {
        Object object = this.MONITOR_OFF_LOCK;
        synchronized (object) {
            if (this.monitorOffThread != null && this.monitorOffThread.isAlive()) {
                return;
            }
            this.monitorOffThread = new Thread(){

                @Override
                public void run() {
                    NativeUtils.this.enableMonitorOff();
                }
            };
            this.monitorOffThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopMonitorOffThread() {
        Object object = this.MONITOR_OFF_LOCK;
        synchronized (object) {
            this.disableMonitorOff();
            if (this.monitorOffThread == null) {
                return;
            }
            try {
                this.monitorOffThread.join(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.monitorOffThread = null;
        }
    }

    public static void setCapsLock(boolean on) {
        NativeUtils.setLockingKeyState(on, 20, 57);
    }

    public static void setScrollLock(boolean on) {
        NativeUtils.setLockingKeyState(on, 145, -1);
    }

    public static void setLockingKeyState(boolean on, int keyEvent, int macKeyCode) {
        boolean currentState = keyEvent == 20 ? NativeUtils.getCapsLockState() : NativeUtils.getScrollLockState();
        if (on && currentState) {
            return;
        }
        if (!on && !currentState) {
            return;
        }
        if (OS.isMacOS()) {
            if (macKeyCode > 0) {
                if (on) {
                    NativeMacUtils.getInstance().keyDown(macKeyCode);
                } else {
                    NativeMacUtils.getInstance().keyUp(macKeyCode);
                }
            }
        } else if (OS.isWindows()) {
            NativeUtils.getInstance().simulateKeyDown(keyEvent);
            NativeUtils.getInstance().simulateKeyUp(keyEvent);
        } else if (OS.isLinux()) {
            try {
                if (robot == null) {
                    robot = new Robot();
                }
            }
            catch (AWTException e) {
                e.printStackTrace();
            }
            robot.keyPress(keyEvent);
            robot.keyRelease(keyEvent);
        }
    }

    public void setNumLock(boolean on) {
        boolean currentState = NativeUtils.getInstance().isNumLockOn();
        System.out.println("[NativeUtils] Setting numlock to " + on + "(current state is " + currentState + ")");
        if (on == currentState) {
            return;
        }
        Toolkit.getDefaultToolkit().setLockingKeyState(144, on);
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        if (NativeUtils.getInstance().isNumLockOn() != currentState) {
            return;
        }
        System.out.println("\t[NativeUtils] Called Toolkit but it is still " + currentState);
        try {
            if (robot == null) {
                robot = new Robot();
            }
            robot.keyPress(144);
            robot.keyRelease(144);
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.out.println("[NativeUtils] Called via robot and the state is now:" + NativeUtils.getInstance().isNumLockOn());
    }

    public void simulateKeyDown_SendInput(short VK) {
        this.simulateKeyWithSendInput(VK, (short)0, SIMKEY_DOWN, 0L);
    }

    public void simulateKeyUp_SendInput(short VK) {
        this.simulateKeyWithSendInput(VK, (short)0, SIMKEY_UP, 0L);
    }

    public void simulateKeyPressSendInputUnicode(char c) {
        this.simulateKeyWithSendInput((short)0, (short)c, 4, 0L);
    }

    public native int simulateKeyWithSendInputTest();

    public native int simulateKeyWithSendInput(short var1, short var2, int var3, long var4);

    public native int mapVirtualKey(int var1);

    public native short vkKeyScanEx(short var1, long var2);

    public native short vkKeyScanW(short var1);

    public native short vkKeyScanA(short var1);

    public static int getMaskForCrazyKeys(int VK) {
        if (VK == 39 || VK == 37 || VK == 38 || VK == 40 || VK == 35 || VK == 36 || VK == 33 || VK == 34 || VK == 20) {
            return 1;
        }
        return 0;
    }

    public void simulateKeyDown(int VK) {
        int scan = this.mapVirtualKey(VK);
        int flag = SIMKEY_DOWN | NativeUtils.getMaskForCrazyKeys(VK);
        this.simulateKey((byte)VK, (byte)scan, flag, 0L);
    }

    public void simulateKeyUp(int VK) {
        int scan = this.mapVirtualKey(VK) | 0x80;
        int flag = SIMKEY_UP | NativeUtils.getMaskForCrazyKeys(VK);
        this.simulateKey((byte)VK, (byte)scan, flag, 0L);
    }

    public native void simulateKey(byte var1, byte var2, int var3, long var4);

    public native int getVirtualDesktopX();

    public native int getVirtualDesktopY();

    public native int getVirtualDesktopW();

    public native int getVirtualDesktopH();

    public native int getLogicalDesktopX();

    public native int getLogicalDesktopY();

    public native int getLogicalDesktopW();

    public native int getLogicalDesktopH();

    public native int simulateCharacter(int var1, int var2);

    public native int getProcessID();

    public native boolean setProcessPriorityHigh(int var1);

    public native boolean setProcessPriorityNormal(int var1);

    public native boolean notifyUser(String var1, int var2);

    public static boolean getCapsLockState() {
        if (OS.isWindows()) {
            return NativeUtils.getInstance().isKeyStateOn(20);
        }
        return Toolkit.getDefaultToolkit().getLockingKeyState(20);
    }

    public static boolean getScrollLockState() {
        if (OS.isWindows()) {
            return NativeUtils.getInstance().isKeyStateOn(145);
        }
        return Toolkit.getDefaultToolkit().getLockingKeyState(145);
    }

    public static void main(String[] args) throws Throwable {
        try {
            NativeLibraryLoader.loadLibrary(new File("../SimpleHelp/lib"));
        }
        catch (Throwable t) {
            NativeLibraryLoader.loadLibrary(new File("."));
        }
        System.out.println("CAPS LOCK is " + (NativeUtils.getCapsLockState() ? "on" : "off"));
        Thread.sleep(3000L);
        if (args.length > 0) {
            System.out.println("Setting caps lock to " + Boolean.parseBoolean(args[0]));
            NativeUtils.setCapsLock(Boolean.parseBoolean(args[0]));
            Thread.sleep(3000L);
            System.out.println("CAPS LOCK is " + (NativeUtils.getCapsLockState() ? "on" : "off"));
        }
    }

    static {
        LOCK = new Object();
        robot = null;
    }
}

