/*
 * Decompiled with CFR 0.152.
 */
package com.aem.utils;

import com.aem.utils.CursorInfo;
import com.aem.utils.NativeFilteringUtil;
import com.aem.utils.NativeLibraryLoader;
import com.aem.utils.NonNativeLogicalArray;
import com.aem.utils.ScreenUtil;
import java.awt.Dimension;
import java.awt.Point;
import java.io.File;
import utils.ostools.OS;

public class NativeScreenUtil
implements ScreenUtil {
    private static final boolean JNI_SCREEN_GRAB_VERBOSE = false;
    static String libdir;
    static NativeScreenUtil nutils;
    int[] chunk = new int[0];

    public static String getLibDir() {
        return libdir;
    }

    private NativeScreenUtil() {
    }

    public boolean workingOK() {
        boolean jniFast = NativeFilteringUtil.getInstance(255).workingOK();
        return jniFast;
    }

    public static NativeScreenUtil getInstance() {
        if (NativeLibraryLoader.isNativeLibraryLoadedOK() && nutils == null) {
            nutils = new NativeScreenUtil();
        }
        return nutils;
    }

    public Dimension getPhysicalScreenSize() {
        return new Dimension(this.nativeAllScreensWidth(), this.nativeAllScreensHeight());
    }

    @Override
    public boolean updateGrabArea(int grab_x, int grab_y, int grab_w, int grab_h) {
        boolean result = false;
        result = this.nativeUpdateGrab(grab_x, grab_y, grab_w, grab_h);
        return result;
    }

    @Override
    public NonNativeLogicalArray fetchArray(int chunk_x, int chunk_y, int chunk_w, int chunk_h) {
        int len = chunk_w * chunk_h;
        if (this.chunk.length < len) {
            this.chunk = new int[len];
        }
        int offset = 0;
        for (int y = 0; y < chunk_h; ++y) {
            this.fetchLine(chunk_x, chunk_y + y, chunk_w, this.chunk, offset);
            offset += chunk_w;
        }
        return new NonNativeLogicalArray(chunk_w, chunk_h, this.chunk, chunk_w, 0);
    }

    public native int nativeAllScreensWidth();

    public native int nativeAllScreensHeight();

    private native void showApplication();

    public native void switchOnDisplayMacOSX();

    public static void showMacOSXDockApplication() {
        if (OS.isMacOS()) {
            System.out.println("[NativeUtil] Enabling Mac OS X Dock Icon");
            NativeScreenUtil instance = NativeScreenUtil.getInstance();
            instance.showApplication();
        }
    }

    public native boolean nativeUpdateGrab(int var1, int var2, int var3, int var4);

    public native boolean nativeIsBlank();

    public native void useCaptureBLTGrabs(boolean var1);

    public native void fetchLine(int var1, int var2, int var3, int[] var4, int var5);

    public native void mouseMoved(int var1, int var2);

    public native void mousePressed(int var1);

    public native void mouseRelease(int var1);

    public static void main(String[] args) throws Exception {
        System.out.println("WOOT " + System.getProperty("user.name"));
        NativeLibraryLoader.loadLibrary(new File("."));
        if (!NativeLibraryLoader.isNativeLibraryLoadedOK()) {
            NativeLibraryLoader.loadLibrary(new File("../SimpleHelp/lib"));
        }
        for (int i = 0; i < 1000; ++i) {
            NativeScreenUtil.getInstance().mouseMoved(i, 0);
        }
        Thread.sleep(200L);
        NativeScreenUtil.getInstance().mousePressed(0);
        Thread.sleep(200L);
        NativeScreenUtil.getInstance().mouseRelease(0);
        Thread.sleep(200L);
        NativeScreenUtil.getInstance().mousePressed(0);
        Thread.sleep(200L);
        NativeScreenUtil.getInstance().mouseRelease(0);
    }

    public int getCursorInfo(CursorInfo cInfo) {
        return this.getCursor(cInfo);
    }

    private native int getCursor(CursorInfo var1);

    public native boolean cursorHasChanged();

    public native void listForUserSwitches();

    public native boolean isConsoleSession();

    public native void getMouseLocation(Point var1);
}

