/*
 * Decompiled with CFR 0.152.
 */
package com.aem.utils;

import com.aem.utils.multiplex.MultiplexerByteInputStream;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import utils.switches.Switches;

public class DualPrintstream {
    private static final boolean VERBOSE = false;
    private final Object LOCK = new Object();
    private ArrayList<PrintStream> ps = new ArrayList();
    private ArrayList<PrintStream> ds = new ArrayList();
    private SimpleDateFormat sdf = new SimpleDateFormat("dd/MM HH:mm:ss.SSS: ");

    public OutputStream addOutputStream() {
        MultiplexerByteInputStream bin = new MultiplexerByteInputStream(Switches.SH_1839_dualPrintStreamNoBufferLimit ? -1 : 100000, false);
        ByteArrayInPrinter printer = new ByteArrayInPrinter(bin);
        RePrinter reprinter = new RePrinter(new BufferedReader(new InputStreamReader(bin)));
        reprinter.start();
        return printer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDateStream(PrintStream pp) {
        Object object = this.LOCK;
        synchronized (object) {
            this.ds.add(pp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addThroughStream(PrintStream pp) {
        Object object = this.LOCK;
        synchronized (object) {
            this.ps.add(pp);
        }
    }

    class ByteArrayInPrinter
    extends OutputStream {
        MultiplexerByteInputStream bin;

        public ByteArrayInPrinter(MultiplexerByteInputStream bin) {
            this.bin = bin;
        }

        @Override
        public void close() {
        }

        @Override
        public void flush() {
        }

        @Override
        public void write(byte[] b) {
            this.bin.addData(b);
        }

        @Override
        public void write(byte[] b, int off, int len) {
            byte[] dat = new byte[len];
            System.arraycopy(b, off, dat, 0, len);
            this.bin.addData(dat);
        }

        @Override
        public void write(int b) {
            this.bin.addData(new byte[]{(byte)b});
        }
    }

    public class RePrinter
    extends Thread {
        BufferedReader bread;

        RePrinter(BufferedReader bread) {
            super("DualPrintStream-Reprinter");
            this.bread = bread;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                while (true) {
                    String s = this.bread.readLine();
                    Date date = new Date(System.currentTimeMillis());
                    if (s == null) {
                        return;
                    }
                    Object object = DualPrintstream.this.LOCK;
                    synchronized (object) {
                        String dates = DualPrintstream.this.sdf.format(date);
                        for (PrintStream pp : DualPrintstream.this.ps) {
                            pp.println(s);
                            pp.flush();
                        }
                        for (PrintStream pp : DualPrintstream.this.ds) {
                            pp.print(dates);
                            pp.print(s);
                            pp.print("\r\n");
                            pp.flush();
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

