/*
 * Decompiled with CFR 0.152.
 */
package com.aem.utils;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.Timer;
import utils.swing.ExponentialSlider;
import utils.swing.layout.GbPanel;
import utils.swing.listeners.HandCursorMouseListener;

public class DropDownComponent {
    private ArrayList<Notification> allNotifications = new ArrayList();
    private ArrayList<Notification> showingStaticNotifications = new ArrayList();
    private DropDownLayoutManager rootLayout = new DropDownLayoutManager();
    private JPanel rootComponent = new JPanel(this.rootLayout){

        @Override
        public boolean isOptimizedDrawingEnabled() {
            return false;
        }
    };
    private JPanel mainContent = new JPanel(new BorderLayout());
    private GbPanel staticNotificationPanel = new GbPanel();
    private JComponent contentPanel;
    private MouseAdapter clickListener = new MouseAdapter(){

        @Override
        public void mousePressed(MouseEvent e) {
            for (Notification notification : DropDownComponent.this.allNotifications) {
                if (notification.summary != e.getSource()) continue;
                notification.biggerPanel.removeMouseListener(this);
                notification.biggerPanel.remove(notification.summary);
                notification.biggerPanel.add(notification.notificationPanel);
                notification.biggerPanel.revalidate();
                notification.currentlyShownComponent = notification.notificationPanel;
                return;
            }
        }
    };

    public JPanel getRootComponent() {
        return this.rootComponent;
    }

    public DropDownComponent(JComponent contentPanel) {
        this.contentPanel = contentPanel;
        this.initUI();
    }

    private void initUI() {
        this.rootComponent.add((Component)this.mainContent, new NotificationPosition());
        this.mainContent.add((Component)this.staticNotificationPanel, "North");
        this.mainContent.add((Component)this.contentPanel, "Center");
    }

    public Notification addNotification(JComponent summaryComponent, JComponent notificationPanel, int summaryHeight) {
        return this.addNotification(summaryComponent, notificationPanel, summaryHeight, -1);
    }

    public Notification addNotification(JComponent summaryComponent, JComponent notificationPanel, int summaryHeight, int width) {
        Notification notification = new Notification();
        notification.notificationPanel = notificationPanel;
        notification.summary = summaryComponent;
        notification.summaryPanelHeight = summaryHeight;
        notification.biggerPanel = new JPanel();
        notification.biggerPanel.setLayout(new GridLayout(1, 1));
        notification.biggerPanel.add(summaryComponent);
        if (notificationPanel != null) {
            notification.summary.addMouseListener(new HandCursorMouseListener());
            notification.summary.addMouseListener(this.clickListener);
        }
        notification.width = width;
        notification.currentlyShownComponent = notification.biggerPanel;
        return notification;
    }

    public void showDropDownNotification(Notification notification) {
        this.rootComponent.add((Component)notification.biggerPanel, notification.offsetPosition);
        this.rootComponent.revalidate();
        this.allNotifications.add(notification);
        new ShowThread(notification);
    }

    public void showStaticNotification(Notification notification) {
        this.showingStaticNotifications.add(notification);
        this.staticNotificationPanel.add((Component)notification.summary, 0, this.showingStaticNotifications.size() - 1, 1, 1, 1, 0, 10, 2);
        this.staticNotificationPanel.revalidate();
        this.staticNotificationPanel.repaint();
    }

    public void removeNotification(Notification notification) {
        boolean isInRoot = false;
        for (Component c : this.rootComponent.getComponents()) {
            if (c != notification.biggerPanel) continue;
            isInRoot = true;
        }
        if (isInRoot) {
            new HideThread(notification);
        } else {
            this.staticNotificationPanel.remove((Component)notification.summary);
            this.rootComponent.revalidate();
            this.rootComponent.repaint();
        }
    }

    public void mouseReleased(MouseEvent e) {
    }

    class DropDownLayoutManager
    implements LayoutManager2 {
        private HashMap<Component, NotificationPosition> componentToPositionMap = new HashMap();
        private ArrayList<Component> components = new ArrayList();

        DropDownLayoutManager() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
            this.addLayoutComponent(comp, new NotificationPosition());
        }

        @Override
        public void removeLayoutComponent(Component comp) {
            this.components.remove(comp);
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(0, 0);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return new Dimension(0, 0);
        }

        @Override
        public void layoutContainer(Container parent) {
            int i;
            Rectangle r = parent.getBounds();
            DropDownComponent.this.rootComponent.setBounds(r);
            Insets insets = parent.getInsets();
            int y = 0;
            int staticOffset = 0;
            for (Notification notification : DropDownComponent.this.showingStaticNotifications) {
                staticOffset += notification.summaryPanelHeight;
            }
            for (i = 0; i < this.components.size(); ++i) {
                Component child = this.components.get(i);
                if (i == 0) {
                    child.setBounds(r.x + insets.left, r.y + insets.top, r.width - insets.left - insets.right, r.height - insets.bottom - insets.top);
                    continue;
                }
                NotificationPosition pos = this.componentToPositionMap.get(child);
                child.setBounds(r.x + insets.left, r.y + insets.top + y + pos.yOffset + staticOffset, r.width - insets.left - insets.right, child.getPreferredSize().height);
                y = (int)((double)y + (child.getPreferredSize().getHeight() + (double)pos.yOffset));
            }
            for (i = 0; i < this.components.size(); ++i) {
                if (i == 0) {
                    DropDownComponent.this.rootComponent.setComponentZOrder(this.components.get(i), this.components.size() - 1);
                    continue;
                }
                DropDownComponent.this.rootComponent.setComponentZOrder(this.components.get(i), i - 1);
            }
        }

        @Override
        public void addLayoutComponent(Component comp, Object constraints) {
            this.components.add(comp);
            this.componentToPositionMap.put(comp, (NotificationPosition)constraints);
        }

        @Override
        public Dimension maximumLayoutSize(Container target) {
            return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
        }

        @Override
        public float getLayoutAlignmentX(Container target) {
            return 0.5f;
        }

        @Override
        public float getLayoutAlignmentY(Container target) {
            return 0.5f;
        }

        @Override
        public void invalidateLayout(Container target) {
        }
    }

    class GrowThread
    implements ActionListener {
        private Notification notification;
        private ExponentialSlider es;
        private int stepCount;
        private int startY;
        private int i;
        private Timer timer;

        public GrowThread(Notification notification) {
            this.notification = notification;
            int increaseInHeight = ((Notification)notification).biggerPanel.getPreferredSize().height - notification.summaryPanelHeight;
            this.es = new ExponentialSlider((double)increaseInHeight, 400L, 4.0, true);
            this.stepCount = this.es.getPositionCount();
            this.startY = -increaseInHeight;
            this.i = 0;
            Notification notification2 = notification;
            notification2.summaryPanelHeight = notification2.summaryPanelHeight + increaseInHeight;
            this.timer = new Timer((int)this.es.get25fpsSleep(), this);
            this.timer.setInitialDelay(0);
            this.timer.start();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ((Notification)this.notification).offsetPosition.yOffset = this.startY + this.es.getPositionForStepRounded(this.i);
            DropDownComponent.this.rootComponent.revalidate();
            DropDownComponent.this.rootComponent.repaint();
            if (this.i < this.stepCount - 1) {
                ++this.i;
            } else {
                this.timer.stop();
            }
        }
    }

    class HideThread
    implements ActionListener {
        private Notification notification;
        private ExponentialSlider es;
        private int stepCount;
        private double size;
        private int i;
        private Timer timer;

        public HideThread(Notification notification) {
            this.size = notification.biggerPanel.getPreferredSize().getHeight();
            this.notification = notification;
            this.es = new ExponentialSlider(this.size, 400L, 2.0, false);
            this.stepCount = this.es.getPositionCount();
            this.i = this.stepCount - 1;
            this.timer = new Timer((int)this.es.get25fpsSleep(), this);
            this.timer.setInitialDelay(0);
            this.timer.start();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ((Notification)this.notification).offsetPosition.yOffset = (int)(-this.size + (double)this.es.getPositionForStepRounded(this.i));
            if (this.i > 0) {
                --this.i;
            } else {
                this.timer.stop();
                if (this.notification.currentlyShownComponent != null) {
                    DropDownComponent.this.rootComponent.remove(this.notification.currentlyShownComponent);
                    DropDownComponent.this.allNotifications.remove(this.notification);
                }
            }
            DropDownComponent.this.rootComponent.revalidate();
            DropDownComponent.this.rootComponent.repaint();
        }
    }

    public class Notification {
        private NotificationPosition offsetPosition;
        private JComponent currentlyShownComponent;
        private JPanel biggerPanel;
        private JComponent notificationPanel;
        private JComponent summary;
        private int style;
        private int summaryPanelHeight;
        public int width;

        public Notification() {
            this.offsetPosition = new NotificationPosition();
            this.currentlyShownComponent = null;
            this.width = -1;
        }

        public void setBackground(Color c) {
            if (this.notificationPanel != null) {
                this.notificationPanel.setBackground(c);
                this.notificationPanel.repaint();
            }
            if (this.summary != null) {
                this.summary.setBackground(c);
                this.summary.repaint();
            }
            if (this.biggerPanel != null) {
                this.biggerPanel.setBackground(c);
                this.biggerPanel.repaint();
            }
        }

        public Color getBackground() {
            return this.currentlyShownComponent.getBackground();
        }
    }

    class NotificationPosition {
        int yOffset;

        NotificationPosition() {
        }
    }

    class ShowThread
    implements ActionListener {
        private Notification notification;
        private ExponentialSlider es;
        private int stepCount;
        private int i;
        private Timer timer;

        public ShowThread(Notification notification) {
            this.notification = notification;
            this.es = new ExponentialSlider((double)notification.summaryPanelHeight, true);
            this.stepCount = this.es.getPositionCount();
            this.i = 0;
            this.timer = new Timer((int)this.es.get25fpsSleep(), this);
            this.timer.setInitialDelay(0);
            this.timer.start();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ((Notification)this.notification).offsetPosition.yOffset = -this.notification.summaryPanelHeight + this.es.getPositionForStepRounded(this.i);
            DropDownComponent.this.rootComponent.revalidate();
            DropDownComponent.this.rootComponent.repaint();
            if (this.i < this.stepCount - 1) {
                ++this.i;
            } else {
                this.timer.stop();
            }
        }
    }
}

