/*
 * Decompiled with CFR 0.152.
 */
package com.aem.utils;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;

public class Debugger {
    public static boolean PRINT_INFO = false;
    public static boolean PRINT_WARNING = true;
    public static boolean PRINT_ERROR = true;
    public static boolean SHOW_DEBUG_STUFF = true;
    public static boolean LOG_TO_CLI = true;
    public static boolean LOG_PER_THREAD = false;
    public static String LOG_DIR = "";
    public static boolean PRINT_STACKTRACE = true;
    public static boolean GENERATE_STACKTRACE = false;
    private static HashMap log_map = new HashMap();
    private static HashMap mark_map = new HashMap();
    private static StringBuffer sb = new StringBuffer();
    private static SimpleDateFormat sformat = new SimpleDateFormat("[H-m-s]");
    private static String log_prefix;

    private static void log(String message, String thread) {
        if (LOG_TO_CLI) {
            System.out.print(message);
        }
        if (LOG_PER_THREAD) {
            try {
                OutputStream fout = (OutputStream)log_map.get(thread);
                if (fout == null) {
                    fout = new FileOutputStream(new File(LOG_DIR + log_prefix + thread + ".log"));
                    fout = new BufferedOutputStream(fout);
                    log_map.put(thread, fout);
                }
                fout.write(message.getBytes());
                fout.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void mark(String textToPrint) {
        if (PRINT_INFO) {
            String caller = Debugger.getCallerStackTrace();
            String thread = Thread.currentThread().getName();
            long tmp = 0L;
            try {
                long now = System.currentTimeMillis();
                Long mark = (Long)mark_map.get(thread);
                if (mark == null) {
                    mark = new Long(System.currentTimeMillis());
                }
                tmp = now - mark;
                mark_map.put(thread, new Long(now));
            }
            catch (Exception now) {
                // empty catch block
            }
            String message = "M:(" + thread + "):(" + tmp + "ms):" + caller + ":" + textToPrint + "\n";
            Debugger.log(message, thread);
        }
    }

    public static void info(String textToPrint, Throwable t) {
        if (PRINT_INFO) {
            String message;
            String thread = Thread.currentThread().getName();
            if (SHOW_DEBUG_STUFF) {
                String caller = Debugger.getCallerStackTrace();
                message = "I:(" + thread + "):" + caller + ":" + textToPrint + ": " + t + "\n";
            } else {
                message = "INFO:" + textToPrint + ": " + t + "\n";
            }
            if (PRINT_STACKTRACE) {
                message = message + Debugger.getStackTrace(t);
            }
            Debugger.log(message, thread);
        }
    }

    public static void info(String textToPrint) {
        if (PRINT_INFO) {
            String message;
            String thread = Thread.currentThread().getName();
            if (SHOW_DEBUG_STUFF) {
                String caller = Debugger.getCallerStackTrace();
                message = "I:(" + thread + "):" + caller + ":" + textToPrint + "\n";
            } else {
                message = "INFO:" + textToPrint + "\n";
            }
            Debugger.log(message, thread);
        }
    }

    public static void warning(String textToPrint, Throwable t) {
        if (PRINT_WARNING) {
            String message;
            String thread = Thread.currentThread().getName();
            if (SHOW_DEBUG_STUFF) {
                String caller = Debugger.getCallerStackTrace();
                message = "W:(" + thread + "):" + caller + ":" + textToPrint + ": " + t + "\n";
            } else {
                message = "WARNING:" + textToPrint + ": " + t + "\n";
            }
            if (PRINT_STACKTRACE) {
                message = message + Debugger.getStackTrace(t);
            }
            Debugger.log(message, thread);
        }
    }

    public static void warning(String textToPrint) {
        if (PRINT_WARNING) {
            String message;
            String thread = Thread.currentThread().getName();
            if (SHOW_DEBUG_STUFF) {
                String caller = Debugger.getCallerStackTrace();
                message = "W:(" + thread + "):" + caller + ":" + textToPrint + "\n";
            } else {
                message = "WARNING:" + textToPrint + "\n";
            }
            if (GENERATE_STACKTRACE) {
                message = message + Debugger.getStackTrace();
            }
            Debugger.log(message, thread);
        }
    }

    public static void error(String textToPrint, Throwable error) {
        if (PRINT_ERROR) {
            String message;
            String thread = Thread.currentThread().getName();
            if (SHOW_DEBUG_STUFF) {
                String caller = Debugger.getCallerStackTrace();
                message = "E:(" + thread + "):" + caller + ":" + textToPrint;
            } else {
                message = "ERROR:" + textToPrint;
            }
            if (error != null) {
                message = message + ": " + error + "\n";
                if (PRINT_STACKTRACE) {
                    message = message + Debugger.getStackTrace(error);
                }
            } else {
                message = message + "\n";
            }
            Debugger.log(message, thread);
        }
    }

    public static void error(String textToPrint) {
        if (PRINT_ERROR) {
            String message;
            String thread = Thread.currentThread().getName();
            if (SHOW_DEBUG_STUFF) {
                String caller = Debugger.getCallerStackTrace();
                message = "E:(" + thread + "):" + caller + ":" + textToPrint + "\n";
            } else {
                message = "ERROR:" + textToPrint + "\n";
            }
            if (GENERATE_STACKTRACE) {
                message = message + Debugger.getStackTrace();
            }
            Debugger.log(message, thread);
        }
    }

    private static String getCallerStackTrace() {
        return Debugger.getLineOfStackTrace(Debugger.getStackTrace(new Throwable()), 4);
    }

    private static String getLineOfStackTrace(String stackTrace, int lineNumber) {
        int beginIndex = 0;
        int endIndex = 0;
        int index = 0;
        for (int i = 0; i < lineNumber; ++i) {
            beginIndex = index + 5;
            index = stackTrace.indexOf("\n", index + 1);
            endIndex = index - 1;
        }
        return stackTrace.substring(beginIndex, endIndex);
    }

    public static String getStackTrace(Throwable t) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(os);
        t.printStackTrace(ps);
        return os.toString();
    }

    public static String getStackTrace() {
        Throwable t = new Throwable("DEBUGGER GENERATED STACKTRACE");
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(os);
        t.printStackTrace(ps);
        return os.toString();
    }

    public static void main(String[] args) {
        Thread.currentThread().setName("The Main Thread");
        System.out.println("begin");
        Debugger.info("Information");
        Debugger.warning("Warning");
        Debugger.error("Error");
        System.out.println("end");
    }

    static {
        sformat.format(new Date(System.currentTimeMillis()), sb, new FieldPosition(0));
        log_prefix = sb.toString();
        try {
            String key = System.getProperty("DEBUG_LEVEL");
            PRINT_INFO = false;
            PRINT_WARNING = true;
            PRINT_ERROR = true;
            if (key != null) {
                if (key.equalsIgnoreCase("info")) {
                    System.out.println("DEBUGGER:INFO level debugging");
                    PRINT_INFO = true;
                    PRINT_WARNING = true;
                    PRINT_ERROR = true;
                } else if (key.equalsIgnoreCase("warning")) {
                    System.out.println("DEBUGGER:WARNING level debugging");
                    PRINT_INFO = false;
                    PRINT_WARNING = true;
                    PRINT_ERROR = true;
                } else if (key.equalsIgnoreCase("error")) {
                    System.out.println("DEBUGGER:ERROR level debugging");
                    PRINT_INFO = false;
                    PRINT_WARNING = false;
                    PRINT_ERROR = true;
                } else if (key.equalsIgnoreCase("off")) {
                    PRINT_INFO = false;
                    PRINT_WARNING = false;
                    PRINT_ERROR = false;
                } else {
                    System.out.println("DEBUGGER:Unrecognised PRINT_LEVEL option " + key);
                }
            }
            if ((key = System.getProperty("DEBUG_DIR")) != null) {
                LOG_DIR = key;
                if (!LOG_DIR.endsWith("/") && !LOG_DIR.endsWith("\\")) {
                    LOG_DIR = LOG_DIR + File.separatorChar;
                }
                System.out.println("DEBUGGER:Logging directory set to " + LOG_DIR);
            }
            key = System.getProperty("DEBUG_LOG");
            LOG_TO_CLI = true;
            LOG_PER_THREAD = false;
            if (key != null) {
                if (key.equalsIgnoreCase("both")) {
                    LOG_TO_CLI = true;
                    LOG_PER_THREAD = true;
                } else if (key.equalsIgnoreCase("cli")) {
                    LOG_TO_CLI = true;
                    LOG_PER_THREAD = false;
                } else if (key.equalsIgnoreCase("file")) {
                    LOG_TO_CLI = false;
                    LOG_PER_THREAD = true;
                } else {
                    System.out.println("DEBUGGER:Unrecognised DEBUG_LOG option " + key);
                }
                if (LOG_TO_CLI) {
                    System.out.println("DEBUGGER:Logging to cli (blackscreen) ON");
                } else {
                    System.out.println("DEBUGGER:Logging to cli (blackscreen) OFF");
                }
                if (LOG_PER_THREAD) {
                    System.out.println("DEBUGGER:Logging per thread ON, prefix for this session = " + log_prefix);
                } else {
                    System.out.println("DEBUGGER:Logging per thread OFF");
                }
            }
            key = System.getProperty("DEBUG_TRACE");
            PRINT_STACKTRACE = true;
            GENERATE_STACKTRACE = true;
            if (key != null) {
                if (key.equalsIgnoreCase("generate")) {
                    PRINT_STACKTRACE = true;
                    GENERATE_STACKTRACE = true;
                } else if (key.equalsIgnoreCase("print")) {
                    PRINT_STACKTRACE = true;
                    GENERATE_STACKTRACE = false;
                } else if (key.equalsIgnoreCase("off")) {
                    PRINT_STACKTRACE = false;
                    GENERATE_STACKTRACE = false;
                } else {
                    System.out.println("DEBUGGER:Unrecognised DEBUG_TRACE option " + key);
                }
                if (PRINT_STACKTRACE) {
                    System.out.println("DEBUGGER:Stacktrace printouts for exceptions ON");
                } else {
                    System.out.println("DEBUGGER:Stacktrace printouts for exceptions OFF");
                }
                if (GENERATE_STACKTRACE) {
                    System.out.println("DEBUGGER:Stacktrace generation for errors and warnings ON");
                } else {
                    System.out.println("DEBUGGER:Stacktrace generation for errors and warnings OFF");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

