/*
 * Decompiled with CFR 0.152.
 */
package com.aem.utils;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import utils.ostools.OS;
import utils.progtools.ProcessPrinter;

public class ChModUtil {
    private static void chmodReadForAll(File file) throws IOException {
        System.out.println("[ChModUtil] Managing read only permissions for " + file);
        Process p = Runtime.getRuntime().exec(new String[]{"chmod", "-R", "a+r", file.getAbsolutePath()});
        new ProcessPrinter(p, (OutputStream)System.out, (OutputStream)System.err);
    }

    private static void chmodFreeForAll(File file) throws IOException {
        System.out.println("[ChModUtil] Managing recursive full access permissions for " + file);
        Process p = Runtime.getRuntime().exec(new String[]{"chmod", "-R", "777", file.getAbsolutePath()});
        new ProcessPrinter(p, (OutputStream)System.out, (OutputStream)System.err);
    }

    public static void chmodFreeForAllMacOnly(File file) throws IOException {
        String prop = System.getProperty("simplehelp.disable_chmod");
        if (prop != null) {
            System.out.println("[ChModUtil] Chmod Disabled.");
            return;
        }
        try {
            if (OS.isMacOS()) {
                ChModUtil.chmodFreeForAll(file);
            }
        }
        catch (Throwable t) {
            System.out.println("[ChModUtil] Unable to set permissions for " + file.getName() + ": " + t.getMessage());
        }
    }

    public static void chmodReadForAllMacOnly(File file) throws IOException {
        String prop = System.getProperty("simplehelp.disable_chmod");
        if (prop != null) {
            System.out.println("[ChModUtil] Chmod Disabled.");
            return;
        }
        try {
            if (OS.isMacOS()) {
                ChModUtil.chmodReadForAll(file);
            }
        }
        catch (Throwable t) {
            System.out.println("[ChModUtil] Unable to set read permissions for " + file.getName() + ": " + t.getMessage());
        }
    }
}

