/*
 * Decompiled with CFR 0.152.
 */
package com.aem.tests.suites.tests;

import com.aem.tests.TestUtils;
import com.aem.tests.suites.ContinuousTestSpec;
import com.aem.tests.suites.LargeContinuousTest;
import java.io.IOException;
import java.util.Properties;
import jwrapper.jwutils.swing.JWAutomate;
import jwrapper.jwutils.test.JWTestControl;
import jwrapper.jwutils.test.JWTestable;
import jwrapper.jwutils.test.JWTesting;
import utils.progtools.RobustThread;

public class LongChurnTest
extends LargeContinuousTest {
    private LongChurnTest(ContinuousTestSpec spec) {
        super(spec);
    }

    public static LongChurnTest createLongChurnTest(boolean small) {
        ContinuousTestSpec spec = new ContinuousTestSpec();
        if (small) {
            spec.N_remoteAccess = 2;
            spec.N_techUi = 2;
            spec.N_cust = 2;
        } else {
            spec.N_remoteAccess = 20;
            spec.N_techUi = 3;
            spec.N_cust = 3;
        }
        return new LongChurnTest(spec);
    }

    @Override
    protected void launchTestControl() throws Exception {
        int i;
        for (i = 0; i < 4; ++i) {
            new RAOfflineDriver().start();
        }
        for (i = 0; i < 2; ++i) {
            new LongRunningSessionDriver(true).start();
        }
        for (i = 0; i < 2; ++i) {
            new LongRunningSessionDriver(false).start();
        }
        for (i = 0; i < 2; ++i) {
            new TechUiSessionsDriver().start();
        }
        for (i = 0; i < 2; ++i) {
            new TechUiMonitoringDriver().start();
        }
        new RAChurnDriver().start();
    }

    @Override
    public Properties getLaunchProperties() {
        return null;
    }

    class LongRunningSessionDriver
    extends RobustThread {
        boolean accessSession;
        String name;

        public LongRunningSessionDriver(boolean accessSession) {
            this.accessSession = accessSession;
            this.name = accessSession ? "Long SH Session " + this.hashCode() % 1000 : "Long SG Session " + this.hashCode() % 1000;
        }

        @Override
        public String getRobustName() {
            return "Long Run Session Driver";
        }

        @Override
        public boolean isShutdown() {
            return false;
        }

        @Override
        public void reInit() throws Throwable {
            System.out.println("[Long Session] Long Session Driver re-initing, launching session");
            JWTesting.countdownStatus((String)this.name, (String)"Beginning", (int)((int)(Math.random() * 3.0)));
            while (true) {
                try {
                    if (this.accessSession) {
                        JWTestControl.callOne((String)TestUtils.APP_TECH_UI, (String)TestUtils.TU_CMD_launchAccessSession);
                        break;
                    }
                    JWTestControl.callOne((String)TestUtils.APP_TECH_UI, (String)TestUtils.TU_CMD_launchCustomerSession);
                }
                catch (NullPointerException xx) {
                    System.out.println("[Long Session] no TechUis available right now");
                    JWAutomate.sleep((long)5000L);
                    continue;
                }
                break;
            }
        }

        @Override
        public void robustRun() throws Throwable {
            System.out.println("[Long Session] Long Session Driver Running");
            JWTesting.reportStatus((String)this.name, (String)"Waiting for available Tech Session");
            JWTestable session = JWTestControl.popShared((String)TestUtils.APP_TECH_SESSION_GUI, (int)120000);
            if (session == null) {
                System.out.println("[Long Session] Failed to connect to launched session");
                JWAutomate.sleepMins((double)1.0);
                return;
            }
            System.out.println("[Long Session] Connected to session");
            while (true) {
                double rand;
                if ((rand = Math.random()) < 0.1) {
                    JWTesting.reportStatus((String)this.name, (String)"Checking stability of random transport");
                    JWAutomate.sleepMins((double)3.0);
                } else if (rand < 0.2) {
                    JWTesting.reportStatus((String)this.name, (String)"Switching to random transport");
                    JWAutomate.sleepMins((double)1.0);
                }
                JWTesting.countdownStatus((String)this.name, (String)"Running further interactions", (int)1);
            }
        }
    }

    class RAChurnDriver
    extends Thread {
        RAChurnDriver() {
        }

        @Override
        public void run() {
            System.out.println("[RA Churn] RA Churn Driver Running");
            String name = "RA Churn " + this.hashCode() % 1000;
            while (true) {
                JWAutomate.sleepMins((double)1.0);
                try {
                    JWTesting.countdownStatus((String)name, (String)"May kill some RA Service HTTP sockets", (int)30);
                    if (Math.random() < 0.7) {
                        System.out.println("[RA Churn] Killing 0-6 RA service HTTP sockets (simulating small network event)");
                        JWTestControl.callN((int)6, (String)TestUtils.APP_RA_SERVICE, (String)TestUtils.RA_CMD_killHttpSocket);
                        System.out.println("[RA Churn] Continuing...");
                    }
                    JWTesting.countdownStatus((String)name, (String)"Will force renegotiations for one or all RA services", (int)10);
                    if (Math.random() < 0.2) {
                        System.out.println("[RA Churn] Forcing renegotiate of ALL RA services");
                        JWTestControl.callAll((String)TestUtils.APP_RA_SERVICE, (String)TestUtils.RA_CMD_renegotiate);
                        System.out.println("[RA Churn] Continuing...");
                        continue;
                    }
                    if (!(Math.random() < 0.8)) continue;
                    System.out.println("[RA Churn] Forcing renegotiate of 1 RA service");
                    JWTestControl.callOne((String)TestUtils.APP_RA_SERVICE, (String)TestUtils.RA_CMD_renegotiate);
                    System.out.println("[RA Churn] Continuing...");
                    continue;
                }
                catch (Exception x) {
                    x.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }

    class RAOfflineDriver
    extends Thread {
        RAOfflineDriver() {
        }

        @Override
        public void run() {
            String name = "RA Offline " + this.hashCode() % 1000;
            System.out.println("[RA Offline] RA Offline Driver Running");
            try {
                JWTestable raService = JWTestControl.popShared((String)TestUtils.APP_RA_SERVICE, (int)120000);
                JWTesting.countdownStatus((String)name, (String)"Beginning", (int)((int)(Math.random() * 5.0)));
                while (true) {
                    try {
                        while (true) {
                            JWTesting.countdownStatus((String)name, (String)"Stopping one RA service polling", (int)25);
                            System.out.println("[RA Offline] Stopping polling");
                            raService.call(TestUtils.RA_CMD_stopPolling, null);
                            System.out.println("[RA Offline] Continuing...");
                            JWTesting.countdownStatus((String)name, (String)"Restarting RA service polling", (int)20);
                            System.out.println("[RA Offline] Starting polling");
                            raService.call(TestUtils.RA_CMD_startPolling, null);
                            System.out.println("[RA Offline] Continuing...");
                        }
                    }
                    catch (Exception x) {
                        x.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
            catch (IOException x) {
                x.printStackTrace();
                return;
            }
        }
    }

    class ShortRunningSessionDriver
    extends Thread {
        ShortRunningSessionDriver() {
        }

        @Override
        public void run() {
            String name = "Short Session " + this.hashCode() % 1000;
            try {
                System.out.println("[Short Session] Short Session Driver connecting to session...");
                JWTestable session = JWTestControl.popShared((String)TestUtils.APP_TECH_SESSION_GUI, (int)120000);
                System.out.println("[Short Session] Continuing...");
                int runs = 1 + (int)(Math.random() * 9.0);
                for (int i = 0; i < runs; ++i) {
                    session.call(TestUtils.SS_CMD_switchToRandomTransport, null);
                    JWTesting.countdownStatus((String)name, (String)"Running further interactions", (int)1);
                }
                JWTesting.countdownStatus((String)name, (String)"Terminating", (int)1);
                session.call(TestUtils.SS_CMD_terminate, null);
            }
            catch (IOException x) {
                x.printStackTrace();
            }
        }
    }

    class TechUiMonitoringDriver
    extends RobustThread {
        JWTestable tech;
        String name = "Tech UI Monitoring " + this.hashCode() % 1000;

        @Override
        public String getRobustName() {
            return "TechUi Monitoring Driver";
        }

        @Override
        public boolean isShutdown() {
            return false;
        }

        @Override
        public void reInit() throws Throwable {
            System.out.println("[TechUi Monitoring] TechUi Monitoring Driver re-initing, connecting to TechUi");
            this.tech = JWTestControl.popShared((String)TestUtils.APP_TECH_UI, (int)120000);
        }

        @Override
        public void robustRun() throws Throwable {
            System.out.println("[TechUi Monitoring] TechUi Monitoring Driver Running");
            JWTesting.countdownStatus((String)this.name, (String)"Beginning", (int)((int)(Math.random() * 3.0)));
            while (true) {
                JWTesting.countdownStatus((String)this.name, (String)"Will cycle Tech UI tabs", (int)15);
                this.tech.call(TestUtils.TU_CMD_testCycleUi, null);
            }
        }
    }

    class TechUiSessionsDriver
    extends RobustThread {
        JWTestable tech;
        String name = "Tech UI Session Launcher " + this.hashCode() % 1000;

        @Override
        public String getRobustName() {
            return "TechUi Sessions Driver";
        }

        @Override
        public boolean isShutdown() {
            return false;
        }

        @Override
        public void reInit() throws Throwable {
            System.out.println("[TechUi Sessions] TechUi Sessions Driver re-initing, connecting to TechUi");
            this.tech = JWTestControl.popShared((String)TestUtils.APP_TECH_UI, (int)120000);
        }

        @Override
        public void robustRun() throws Throwable {
            System.out.println("[TechUi Sessions] TechUi Sessions Driver Running");
            JWTesting.countdownStatus((String)this.name, (String)"Beginning", (int)(1 + (int)(Math.random() * 3.0)));
            while (true) {
                if (Math.random() < 0.5) {
                    System.out.println("[TechUi Sessions] Launching short access session");
                    this.tech.call(TestUtils.TU_CMD_launchAccessSession, null);
                } else {
                    System.out.println("[TechUi Sessions] Launching short support session");
                    this.tech.call(TestUtils.TU_CMD_launchCustomerSession, null);
                }
                new ShortRunningSessionDriver().start();
                System.out.println("[TechUi Sessions] Continuing...");
                JWTesting.countdownStatus((String)this.name, (String)"Will launch one short running session", (int)7);
            }
        }
    }
}

