/*
 * Decompiled with CFR 0.152.
 */
package com.aem.tests.suites;

import com.aem.tests.TestUtils;
import com.aem.tests.suites.AvailabilityDriver;
import com.aem.tests.suites.ContinuousTestSpec;
import java.io.IOException;
import java.util.Properties;
import jwrapper.jwutils.test.JWTestControl;
import utils.message.Message;
import utils.message.TypedMap;

public abstract class LargeContinuousTest {
    protected ContinuousTestSpec spec;

    public LargeContinuousTest(ContinuousTestSpec spec) {
        this.spec = spec;
    }

    public abstract Properties getLaunchProperties();

    public void launch() {
        try {
            Properties props = this.getLaunchProperties();
            if (props == null) {
                props = new Properties();
            }
            TypedMap map = new TypedMap();
            map.setProperties("all", props);
            JWTestControl.callAll((String)TestUtils.APP_TECH_TEST, (String)TestUtils.TT_CMD_setLaunchProps, (Message)map.toCompressedMessage());
            System.out.println("[TestControl] Launching RA service Availability Driver");
            new AccessAvailabilityDriver().start();
            System.out.println("[TestControl] Launching Customer Availability Driver");
            new CustomerAvailabilityDriver().start();
            System.out.println("[TestControl] Launching Tech Ui Availability Driver");
            new TechUiAvailabilityDriver().start();
            System.out.println("[TestControl] Launching RA Session Availability Driver");
            new RaSessionsAvailabilityDriver().start();
            System.out.println("[TestControl] Launching Churn Threads");
            this.launchTestControl();
            System.out.println("[TestControl] Finished launches");
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    protected abstract void launchTestControl() throws Exception;

    class AccessAvailabilityDriver
    extends AvailabilityDriver {
        boolean udp;

        public AccessAvailabilityDriver() {
            super(LargeContinuousTest.this.spec.N_remoteAccess);
            this.udp = true;
        }

        @Override
        public int checkCount() {
            return JWTestControl.getConnected((String)TestUtils.APP_RA_SERVICE);
        }

        @Override
        public void launchOne() throws IOException {
            boolean bl = this.udp = !this.udp;
            if (this.udp) {
                JWTestControl.callOne((String)TestUtils.APP_RA_TEST, (String)TestUtils.RAT_CMD_startUdpService);
            } else {
                JWTestControl.callOne((String)TestUtils.APP_RA_TEST, (String)TestUtils.RAT_CMD_startHttpService);
            }
        }
    }

    class CustomerAvailabilityDriver
    extends AvailabilityDriver {
        public CustomerAvailabilityDriver() {
            super(LargeContinuousTest.this.spec.N_cust);
        }

        @Override
        public int checkCount() {
            return JWTestControl.getConnected((String)TestUtils.APP_RS_CUST);
        }

        @Override
        public void launchOne() throws IOException {
            JWTestControl.callOne((String)TestUtils.APP_RS_CUST_TEST, (String)TestUtils.RSC_CMD_startCustomer);
        }
    }

    class RaSessionsAvailabilityDriver
    extends AvailabilityDriver {
        public RaSessionsAvailabilityDriver() {
            super(LargeContinuousTest.this.spec.N_accessSessions);
        }

        @Override
        public long getTimeBetweenLaunches() {
            return 30000L;
        }

        @Override
        public int checkCount() {
            return JWTestControl.getConnected((String)TestUtils.APP_TECH_SESSION_GUI);
        }

        @Override
        public void launchOne() throws IOException {
            int techUis = JWTestControl.getConnected((String)TestUtils.APP_TECH_UI);
            if (techUis >= LargeContinuousTest.this.spec.N_techUi && techUis > 0) {
                JWTestControl.callOne((String)TestUtils.APP_TECH_UI, (String)TestUtils.TU_CMD_launchAccessSession);
            }
        }
    }

    class TechUiAvailabilityDriver
    extends AvailabilityDriver {
        public TechUiAvailabilityDriver() {
            super(LargeContinuousTest.this.spec.N_techUi);
        }

        @Override
        public int checkCount() {
            return JWTestControl.getConnected((String)TestUtils.APP_TECH_UI);
        }

        @Override
        public void launchOne() throws IOException {
            JWTestControl.callOne((String)TestUtils.APP_TECH_TEST, (String)TestUtils.TT_CMD_startTechUi);
        }
    }
}

