/*
 * Decompiled with CFR 0.152.
 */
package com.aem.tests;

import com.aem.tests.TestUtils;
import java.io.IOException;
import java.net.Socket;
import jwrapper.jwutils.JWSockIPC;
import jwrapper.jwutils.JWSockIPCListener;
import utils.message.BasicMTTransactionClient;
import utils.message.Message;

public class HeadlessAccessAPI
implements JWSockIPCListener {
    public static int PORT = 7357;
    public static short IPC_KEEPALIVE = (short)999;
    public static short IPC_TRANS = 0;
    public static int IPC_TIMEOUT = 600000;
    public static int MSG_OK = 0;
    public static int MSG_SET_URL = 1;
    public static int MSG_LAUNCH = 2;
    public static int MSG_SERVICES_CMD = 3;
    public static int MSG_RUN = 4;
    JWSockIPC ipc;
    boolean closed = false;
    BasicMTTransactionClient mtc;
    String host;

    public HeadlessAccessAPI(String host, String aes) throws IOException {
        this.host = host;
        int attempts = 20;
        long msquit = 120000L;
        long timeout = System.currentTimeMillis() + msquit;
        Socket sock = null;
        System.out.println("[HeadlessAccessAPI] Connecting headless access API to " + host + " on " + PORT + " (max " + attempts + " attempts, " + msquit / 1000L + "sec timeout)");
        for (int i = 1; i <= attempts; ++i) {
            try {
                sock = new Socket(host, PORT);
                break;
            }
            catch (IOException x) {
                if (i == attempts) {
                    System.out.println("[HeadlessAccessApi] Connection failed: " + x);
                    throw x;
                }
                try {
                    Thread.sleep(2000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                continue;
            }
        }
        this.ipc = JWSockIPC.createNewIPC(sock);
        this.ipc.setupMultipleChannels();
        this.ipc.setupPingsAndReportClosure((JWSockIPCListener)this, IPC_KEEPALIVE, (long)IPC_TIMEOUT);
        this.mtc = new BasicMTTransactionClient(this.ipc.getInChannel(IPC_TRANS), this.ipc.getOutChannel(IPC_TRANS));
        this.mtc.setAutoHandleExceptions(true);
    }

    public String toString() {
        return this.host;
    }

    public boolean isAlive() {
        return !this.closed;
    }

    public void ipcClosed() {
        System.out.println("***WARNING*** HeadlessAccessAPI for " + this.host + " closed!");
        this.closed = true;
    }

    public String run(String command) throws IOException {
        Message m = new Message(MSG_RUN);
        m.append(command);
        Message ret = this.mtc.doTransaction(m);
        return ret.getNextString();
    }

    public void setServerURL(String url) throws IOException {
        Message m = new Message(MSG_SET_URL);
        m.append(url);
        this.mtc.doTransaction(m);
    }

    private void doServiceCommand(String cmd) throws IOException {
        Message m = new Message(MSG_SERVICES_CMD);
        m.append(cmd);
        this.mtc.doTransaction(m);
    }

    public void startThinHttpService(int N) throws IOException {
        Message m = new Message(MSG_LAUNCH);
        m.append(TestUtils.RAT_CMD_startThinHttpService);
        m.append(N);
        this.mtc.doTransaction(m);
    }

    public void startThinHttpsService(int N) throws IOException {
        Message m = new Message(MSG_LAUNCH);
        m.append(TestUtils.RAT_CMD_startThinHttpsService);
        m.append(N);
        this.mtc.doTransaction(m);
    }

    public void startHttpService(int N) throws IOException {
        Message m = new Message(MSG_LAUNCH);
        m.append(TestUtils.RAT_CMD_startHttpService);
        m.append(N);
        this.mtc.doTransaction(m);
    }

    public void startHttpsService(int N) throws IOException {
        Message m = new Message(MSG_LAUNCH);
        m.append(TestUtils.RAT_CMD_startHttpsService);
        m.append(N);
        this.mtc.doTransaction(m);
    }

    public void startUdpService(int N) throws IOException {
        Message m = new Message(MSG_LAUNCH);
        m.append(TestUtils.RAT_CMD_startUdpService);
        m.append(N);
        this.mtc.doTransaction(m);
    }

    public void pollingOn() throws IOException {
        this.doServiceCommand("COM_RA_START");
        this.doServiceCommand("COM_RA_NOCYCLE");
    }

    public void pollingCycle() throws IOException {
        this.doServiceCommand("COM_RA_START");
        this.doServiceCommand("COM_RA_CYCLE");
    }

    public void pollingOff() throws IOException {
        this.doServiceCommand("COM_RA_STOP");
        this.doServiceCommand("COM_RA_NOCYCLE");
    }

    public void renegotiate() throws IOException {
        this.doServiceCommand("COM_RA_RENEGOTIATE");
    }

    public void testLiveness() throws IOException {
        this.doServiceCommand("COM_RA_NOOP");
    }

    public void nukeHttpSockets() throws IOException {
        this.doServiceCommand("COM_RA_KILL_HTTP");
    }

    public static void main(String[] args) throws Exception {
        HeadlessAccessAPI api = new HeadlessAccessAPI("localhost", "aesSampleKey");
        api.setServerURL("http://localhost:8008");
        api.startHttpService(1);
    }
}

