/*
 * Decompiled with CFR 0.152.
 */
package com.aem.tests;

import com.aem.TestResourceBundle;
import com.aem.nodelink.Node;
import com.aem.nodelink.NodeLink;
import com.aem.nodelink.attempt.NodelinkAttempt;
import com.aem.nodelink.http.HttpEndpoint;
import com.aem.nodelink.tcp.TcpEndpoint;
import com.aem.nodelink.utils.SafeClock;
import com.aem.sgateway.SimpleGatewayConfig;
import com.aem.shelp.common.login.TechCredentials;
import com.aem.shelp.licence.OemBranding;
import com.aem.shelp.mdupload.fs.TechClientFS;
import com.aem.shelp.proxy.common.Notification;
import com.aem.shelp.proxy.techclient.TechClient;
import com.aem.shelp.proxy.techclient.TechClientAdapter;
import com.aem.shelp.proxy.techclient.TechClientListener;
import com.aem.shelp.proxy.types.AccessSession;
import com.aem.shelp.proxy.types.Machine;
import com.aem.shelp.proxy.types.ResourceContainer;
import com.aem.shelp.tech.authentication.TwoTierCodeEntryGlassDialog;
import com.aem.shelp.util.SHelpNodelinkConnector;
import com.aem.utils.StreamUtils;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Proxy;
import java.net.Socket;
import java.net.URL;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import jwrapper.jwutils.JWSystem;
import jwrapper.updater.JWLaunchProperties;
import utils.progtools.JobPool;
import utils.progtools.net.URLParser;
import utils.stream.SSLHelper;

public class FrameworkBattery
extends TechClientAdapter {
    StringBuffer errors = new StringBuffer();
    StringBuffer info = new StringBuffer();
    TechClient client;
    Object conc_LOCK = new Object();
    int concDone = 0;

    public String getErrors() {
        return this.errors.toString();
    }

    public String getInfo() {
        return this.info.toString();
    }

    public FrameworkBattery(String host, int port, String password) throws Exception {
        TechCredentials creds = new TechCredentials();
        creds.setUsername(OemBranding.OEM_ADMIN_USERNAME);
        creds.setPassword(password);
        this.client = new TechClient("en", (ResourceBundle)new TestResourceBundle(), host, port, creds, false, this);
        int attendeeLimit = this.client.getAttendeeLimit();
        System.out.println("Attendee limit: " + attendeeLimit);
        Machine[] machines = this.client.getEntireMachineList_Expensive();
        ArrayList<Machine> macs = new ArrayList<Machine>();
        Machine http = null;
        Machine udp = null;
        Machine https = null;
        for (Machine machine : machines) {
            String name;
            if (!machine.isAvailable() || !(name = machine.getMachineName().getName()).toLowerCase().contains("accepttestsessions")) continue;
            macs.add(machine);
            System.out.println("Available test machine: " + machine.getMachineName() + " " + machine.getPollingProtocolAsString());
            if (machine.getPollingProtocol() == 2) {
                http = machine;
                continue;
            }
            if (machine.getPollingProtocol() == 3) {
                https = machine;
                continue;
            }
            if (machine.getPollingProtocol() != 1) continue;
            udp = machine;
        }
        ArrayList<Machine> targets = new ArrayList<Machine>();
        if (http == null) {
            this.errors.append("Unable to test HTTP RA service (none found)\n");
            System.out.println("***WARNING*** Unable to test HTTP RA service");
        } else {
            targets.add(http);
        }
        if (udp == null) {
            this.errors.append("Unable to test UDP RA service (none found)\n");
            System.out.println("***WARNING*** Unable to test UDP RA service");
        } else {
            targets.add(udp);
        }
        if (https == null) {
            this.errors.append("Unable to test HTTPS RA service (none found)\n");
            System.out.println("***WARNING*** Unable to test HTTPS RA service");
        } else {
            targets.add(https);
        }
        for (Machine machine : targets) {
            this.testLossyTransactionsPerSecond(machine);
        }
        for (Machine machine : targets) {
            this.testConfigureFetches(machine);
        }
        for (Machine machine : targets) {
            this.testConcurrent(machine);
        }
    }

    private void testConcurrentHttpSessions(boolean http, boolean concurrent, boolean download) throws Exception {
        Proxy proxy = JWSystem.getDefaultDetectedProxy();
        if (proxy == null) {
            System.out.println(new Date() + ": - No HTTP Proxy (null)\n");
        } else {
            System.out.println(new Date() + ": " + proxy.toString() + "\n");
        }
        Node them = new Node();
        Node tmpme = new Node();
        tmpme.setSingleUse(false);
        if (http) {
            tmpme.setRemoteNodeAddress(them, new HttpEndpoint(new URL("http://" + this.client.getHost() + ":" + this.client.getPort() + "/data")));
        } else {
            tmpme.setRemoteNodeAddress(them, new TcpEndpoint(this.client.getHost(), this.client.getPort()));
        }
        NodelinkAttempt attempt = new NodelinkAttempt("NL Connection on Port " + this.client.getPort(), tmpme, them, 0, null);
        if (concurrent) {
            JobPool pool = new JobPool();
            for (int i = 0; i < 10; ++i) {
                pool.addStart(new ConcurrentNlEcho(attempt, download));
            }
            pool.joinAll();
        } else {
            for (int i = 0; i < 50; ++i) {
                new ConcurrentNlEcho(attempt, download).run();
            }
        }
        Thread.sleep(2000L);
        System.out.println("****************************************************");
        System.out.println("All concurrent NL echo attempts completed OK");
        System.out.println("****************************************************");
        System.exit(0);
    }

    public static void testBadNlVersionConnects(String url, int N) throws Exception {
        URLParser parser = new URLParser(url);
        String host = parser.getHostname();
        int port = parser.getPort(true);
        for (int i = 0; i < N; ++i) {
            try {
                NodeLink NL = SHelpNodelinkConnector.getSpecificConnection(4, host, port, null);
                OutputStream out = NL.getOutputStream();
                StreamUtils.writeLong(out, 1234L);
                out.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
            System.out.println("Finished FDHTTP Bad NL connection " + i);
            if (i % 10 != 0) continue;
            try {
                Thread.sleep(250L);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void testHungSgSocketTimeouts(String url, int N) throws Exception {
        SSLContext ssc = SSLContext.getInstance("SSL");
        ssc.init(null, SSLHelper.getTrustAllCertsTrustManagerArray(), new SecureRandom());
        SSLSocketFactory factory = ssc.getSocketFactory();
        URLParser parser = new URLParser(url);
        System.out.println("TESTING: Creating 300 RA ping attempts that will hang during select and leave the socket open, check on server using PX_DEBUG_SOCKET_LEAKS or PX_DEBUG_SOCKET_ALL");
        for (int i = 0; i < N; ++i) {
            Socket sock = parser.getProtocol(true).equals("https") ? factory.createSocket(parser.getHostname(), parser.getPort(true)) : new Socket(parser.getHostname(), parser.getPort(true));
            OutputStream out = sock.getOutputStream();
            InputStream in = sock.getInputStream();
            out.write("GET /machine-1490075339743?ping=0B04034DCB70010800011753475F2D3530393939343134383939373936333032323500010132000103342E3407EE0206015AEF694CA800011A5353756974652D342D342D32303137303331352D313332303535000110386561343738396234333735386237310800 HTTP/1.1\n\n".getBytes());
            out.flush();
            Thread.sleep(200L);
        }
    }

    private void testConcurrent(Machine machine) throws Exception {
        System.out.println("TESTING: Concurrent transactions against " + machine.getName() + " (" + machine.getPollingProtocolAsString() + ")");
    }

    private void testConfigureFetches(Machine machine) throws Exception {
        System.out.println("TESTING: Secmsg fetch SG configure against " + machine.getName() + " (" + machine.getPollingProtocolAsString() + ")");
        for (int i = 0; i < 8; ++i) {
            Thread.sleep((long)(Math.random() * 2500.0));
            long T = SafeClock.currentTimeMillis();
            SimpleGatewayConfig config = this.client.getServiceConfigViaSecMsg(machine.getMachineID(), null);
            T = SafeClock.currentTimeMillis() - T;
            if (config == null) {
                System.out.println("***WARNING*** problem fetching configuration file");
                continue;
            }
            System.out.println(T + "ms");
        }
    }

    private void testLossyTransactionsPerSecond(Machine machine) throws Exception {
        long cur;
        long longest;
        long T;
        long N;
        int i;
        System.out.println("TESTING: Secmsg transactions per second against " + machine.getName() + " (" + machine.getPollingProtocolAsString() + ")");
        TechClientFS fs = new TechClientFS(this.client, "SG_Server");
        for (i = 0; i < 3; ++i) {
            N = 0L;
            T = SafeClock.currentTimeMillis() + 1000L;
            longest = 0L;
            while (SafeClock.currentTimeMillis() < T) {
                cur = SafeClock.currentTimeMillis();
                fs.getRemoteTime();
                cur = SafeClock.currentTimeMillis() - cur;
                if (cur > longest) {
                    longest = cur;
                }
                ++N;
            }
            System.out.println(N + " server FS transactions per second");
            if (i != 1) continue;
            this.info.append("(" + machine.getPollingProtocolAsString() + " / " + machine.getName() + ") " + N + " server FS transact/s (max " + longest + "ms)\n");
        }
        fs = new TechClientFS(this.client, machine.getMachineID());
        for (i = 0; i < 3; ++i) {
            N = 0L;
            T = SafeClock.currentTimeMillis() + 1000L;
            longest = 0L;
            while (SafeClock.currentTimeMillis() < T) {
                cur = SafeClock.currentTimeMillis();
                fs.getRemoteTime();
                cur = SafeClock.currentTimeMillis() - cur;
                if (cur > longest) {
                    longest = cur;
                }
                ++N;
            }
            System.out.println(N + " SG FS transactions per second");
            if (i != 1) continue;
            this.info.append("(" + machine.getPollingProtocolAsString() + " / " + machine.getName() + ") " + N + " RA FS transact/s (max " + longest + "ms)\n");
        }
        System.out.println("Remote time: " + fs.getRemoteTime());
    }

    public static void main(String[] args) throws Exception {
        System.setProperty("sun.net.client.defaultConnectTimeout", "30000");
        System.setProperty("sun.net.client.defaultReadTimeout", "30000");
        System.setProperty("http.maxConnections", "1000");
        JWLaunchProperties.setUpTestProperties();
        Properties props = new Properties();
        props.load(new FileInputStream("../Credentials/LocalShServerCredentials.properties"));
        int port = Integer.parseInt(props.getProperty("shPort"));
        String password = props.getProperty("shPassword");
        new FrameworkBattery("localhost", port, password);
    }

    @Override
    public long requestAppAuthenticationSetup(String totpKey, String totpUsername, String hostname, int length) {
        return 0L;
    }

    @Override
    public void closeAppAuthenticationSetup() {
    }

    @Override
    public void configChangedOnServer(long serverConfigInstanceID) {
    }

    @Override
    public void waitingForRemoteUserToAccept() {
    }

    @Override
    public void sgUpdatingDuringConnect() {
    }

    @Override
    public void customerListChanged() {
    }

    @Override
    public void customerLiveListChanged() {
    }

    @Override
    public void demoListChanged() {
    }

    @Override
    public void setWarningMessage(String text) {
    }

    @Override
    public void updateSessionCounts(boolean isJoinedSessionCounts, boolean isEvaluation, boolean isPlan2, int totalSessions, int maxSHSessions, int maxSGSessions, int alertedMachines, int alertLimit, int regMachines, int machineLimit) {
    }

    @Override
    public TechClientListener.TwoTierResponse requestTwoTierCode(boolean showIncorrectWarning, String techEmailAddress, boolean allowRemember) throws TwoTierCodeEntryGlassDialog.SwitchUserException {
        return null;
    }

    @Override
    public TechClientListener.TwoTierResponse processAuthenticationChallenge(boolean showIncorrectWarning, String replyMessage) throws TwoTierCodeEntryGlassDialog.SwitchUserException {
        return null;
    }

    @Override
    public void machineAdded(Machine machine) {
    }

    @Override
    public void machineRemoved(Machine machine) {
    }

    @Override
    public void machinesAdded(Machine[] machine) {
    }

    @Override
    public void machinesRemoved(Machine[] machine) {
    }

    @Override
    public void machineOnline(Machine machine) {
    }

    @Override
    public void machineOffline(Machine machine) {
    }

    @Override
    public void machineDataChanged(Machine machine) {
    }

    @Override
    public void machineFilterableInfoChanged(Machine machine) {
    }

    @Override
    public void sessionAdded(AccessSession session) {
    }

    @Override
    public void sessionRemoved(AccessSession session) {
    }

    @Override
    public void licenseChanged() {
    }

    @Override
    public void peersChanged() {
    }

    @Override
    public void alertAdded(ResourceContainer alert) {
    }

    @Override
    public void alertRemoved(ResourceContainer alert) {
    }

    @Override
    public void alertChanged(ResourceContainer alert) {
    }

    @Override
    public void newNotificationReceived(Notification newNotification) {
    }

    @Override
    public void updateAuthenticationStatusMessage(String statusMessage) {
    }

    class ConcurrentNlEcho
    extends Thread {
        NodelinkAttempt attempt;
        boolean download;
        InputStream in;
        OutputStream out;
        int K = 1;
        int N = 1000000;

        public ConcurrentNlEcho(NodelinkAttempt attempt, boolean download) {
            this.attempt = attempt;
            this.download = download;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block20: {
                try {
                    NodelinkAttempt orig = this.attempt.cloneNew();
                    try {
                        orig.attemptNow();
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                    while (!orig.isFinished()) {
                        Thread.sleep(100L);
                    }
                    if (!orig.wasSuccessful()) {
                        System.out.println("Attempt to establish NL FAILED!");
                        break block20;
                    }
                    NodeLink sock = orig.getNodeLink();
                    this.in = sock.getInputStream();
                    this.out = sock.getOutputStream();
                    System.out.println("Writing MAGIC");
                    StreamUtils.writeLong(this.out, 944162751881113601L);
                    this.out.flush();
                    System.out.println("Looking for OK?");
                    if (1 != StreamUtils.readInt(this.in)) {
                        throw new Exception("Server does not allow connection diagnosis (too old?)");
                    }
                    System.out.println("Got OK?");
                    if (this.download) {
                        StreamUtils.writeInt(this.out, 95000);
                    } else {
                        StreamUtils.writeInt(this.out, 94000);
                    }
                    StreamUtils.writeInt(this.out, this.K);
                    StreamUtils.writeInt(this.out, this.N);
                    this.out.flush();
                    System.out.println("Wrote command");
                    long actual = (long)this.K * 1024L * (long)this.N;
                    int tosend = this.K * 1024 * this.N;
                    if (actual != (long)tosend) {
                        throw new Exception("Integer overflow: " + actual + " != " + tosend);
                    }
                    System.out.println("Will send " + tosend);
                    long T = System.currentTimeMillis();
                    if (this.download) {
                        int len = this.K * 1024 * this.N;
                        int tot = 0;
                        byte[] buf = new byte[512];
                        int n = 0;
                        while (tot < len) {
                            n = this.in.read(buf);
                            if (n > 0) {
                                tot += n;
                            }
                            if (n == 0) {
                                throw new Exception("ZERO data length?");
                            }
                            if (n != -1) continue;
                            throw new Exception("Unexpected end of stream");
                        }
                        StreamUtils.writeInt(this.out, 1);
                        this.out.flush();
                    } else {
                        byte[] dat = new byte[1024 * this.K];
                        for (int i = 0; i < this.N; ++i) {
                            this.out.write(dat);
                            this.out.flush();
                        }
                        this.out.flush();
                        System.out.println("All written!");
                        if (1 != StreamUtils.readInt(this.in)) {
                            throw new Exception("Upload test failed?");
                        }
                    }
                    T = System.currentTimeMillis() - T;
                    System.out.println("All done! " + T + "ms");
                    Object object = FrameworkBattery.this.conc_LOCK;
                    synchronized (object) {
                        ++FrameworkBattery.this.concDone;
                    }
                    StreamUtils.writeInt(this.out, 93000);
                    this.out.flush();
                    Thread.sleep(2000L);
                    sock.stopImmediate("done");
                }
                catch (Exception x) {
                    x.printStackTrace();
                }
            }
        }
    }
}

