/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.util.treetable;

import com.aem.shelp.util.treetable.JTreeTable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;

public class TreeTableCellRenderer
extends JTree
implements TableCellRenderer {
    protected int visibleRow;
    private JTreeTable table;

    public TreeTableCellRenderer(JTreeTable table, TreeModel model) {
        super(model);
        this.table = table;
    }

    @Override
    public void updateUI() {
        super.updateUI();
        TreeCellRenderer tcr = this.getCellRenderer();
        if (tcr instanceof DefaultTreeCellRenderer) {
            DefaultTreeCellRenderer dtcr = (DefaultTreeCellRenderer)tcr;
            dtcr.setTextSelectionColor(UIManager.getColor("Table.selectionForeground"));
            dtcr.setBackgroundSelectionColor(UIManager.getColor("Table.selectionBackground"));
            dtcr.setBackground(Color.red);
        }
    }

    @Override
    public void setRowHeight(int rowHeight) {
        if (rowHeight > 0) {
            super.setRowHeight(rowHeight);
            if (this.table != null && this.table.getRowHeight() != rowHeight) {
                this.table.setRowHeight(this.getRowHeight());
            }
        }
    }

    @Override
    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, 0, w, this.table.getHeight());
    }

    @Override
    public void paint(Graphics g) {
        g.translate(0, -this.visibleRow * this.getRowHeight());
        super.paint(g);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (isSelected) {
            ((DefaultTreeCellRenderer)this.getCellRenderer()).setBackgroundNonSelectionColor(table.getSelectionBackground());
            this.setBackground(table.getSelectionBackground());
        } else {
            if (row % 2 == 0) {
                ((DefaultTreeCellRenderer)this.getCellRenderer()).setBackgroundNonSelectionColor(table.getBackground());
            } else {
                ((DefaultTreeCellRenderer)this.getCellRenderer()).setBackgroundNonSelectionColor(UIManager.getColor("Table.alternateRowColor"));
            }
            this.setBackground(table.getBackground());
        }
        this.visibleRow = row;
        return this;
    }
}

