/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.util.swing;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPopupMenu;
import utils.swing.customlaf.SHButtonUI;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanel;

public abstract class ShPopupMenuButton
extends GbPanel
implements MouseListener {
    private JButton button2;
    private JButton button1;
    private ActionListener menuActionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            Rectangle bounds = ShPopupMenuButton.this.button1.getBounds();
            ShPopupMenuButton.this.getPopupMenu().show(ShPopupMenuButton.this.button1, -1, bounds.y + bounds.height);
        }
    };

    public void setHorizontalAlignment(int alignment) {
        this.button1.setHorizontalAlignment(alignment);
    }

    public void setFontSize(float size) {
        this.button1.setFont(this.button1.getFont().deriveFont(size));
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.button1.setEnabled(enabled);
        if (this.button2 != null) {
            this.button2.setEnabled(enabled);
        }
    }

    public int getDropDownButtonWidth() {
        if (this.button2 == null) {
            return 0;
        }
        return this.button2.getPreferredSize().width;
    }

    public void addActionListener(ActionListener listener) {
        this.button1.addActionListener(listener);
    }

    public abstract JPopupMenu getPopupMenu();

    public ShPopupMenuButton(String text, Icon icon) {
        this(text, icon, false);
    }

    public ShPopupMenuButton(String text, Icon icon, boolean makeSingleButton) {
        this.setOpaque(false);
        this.button1 = new JButton(text, icon);
        if (!makeSingleButton) {
            this.button2 = new JButton(ImageLoader.getImageIcon((String)"images/svg/arrows/down.svg,6")){

                @Override
                public Dimension getPreferredSize() {
                    return this.getMinimumSize();
                }

                @Override
                public Dimension getMinimumSize() {
                    Dimension d = super.getPreferredSize();
                    d.width = SimpleHelpLookAndFeel.scale((int)14);
                    return d;
                }
            };
            this.button2.setHorizontalAlignment(0);
        }
        this.add(this.button1, 0, 0, 1, 1, 1000, 1, 10, 1);
        if (!makeSingleButton) {
            this.add(this.button2, 1, 0, 1, 1, 1, 1, 10, 3);
            this.button2.addMouseListener(this);
            SHButtonUI.SegmentedButtonGroup.createSegmentedButtonGroup((AbstractButton[])new JButton[]{this.button1, this.button2});
        } else {
            this.button1.addActionListener(this.menuActionListener);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        Rectangle bounds = e.getComponent().getBounds();
        this.getPopupMenu().show(e.getComponent(), -1, bounds.y + bounds.height);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    public JButton getSourceButton() {
        return this.button1;
    }

    public String getText() {
        return this.button1.getText();
    }

    public void setIcon(Icon icon) {
        this.button1.setIcon(icon);
    }

    public void setText(String string) {
        this.button1.setText(string);
    }
}

