/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.util.swing;

import com.aem.shelp.common.Language;
import com.aem.utils.gui.verifiers.DigitDocument;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.KeyListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import utils.swing.SwingUtil;
import utils.swing.components.ColorPropagatingGBPanel;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.layout.GbPanel;

public class InactivityTimeoutPanel {
    private GbPanel rootComponent = new ColorPropagatingGBPanel();
    private JTextField terminateTime;
    private JLabel minutes;
    private JLabel terminateInactiveSessionLabel;

    public GbPanel getRootComponent() {
        return this.rootComponent;
    }

    public InactivityTimeoutPanel() {
        this.initUI();
    }

    private void initUI() {
        this.terminateInactiveSessionLabel = new JLabel(Language.get("TERMINATE_ALLOW"));
        this.minutes = new JLabel(Language.get("UNIT_MINUTES"));
        this.terminateTime = new JTextField();
        this.terminateTime.setDocument(new DigitDocument());
        SwingUtil.setWidth((JComponent)this.terminateTime, (int)SimpleHelpLookAndFeel.scale((int)40));
        this.rootComponent.add((Component)this.terminateInactiveSessionLabel, 0, 0, 1, 1, 0, 0, 17, 1);
        this.rootComponent.add((Component)this.terminateTime, 1, 0, 1, 1, 0, 0, 17, 1, (Insets)new ScaledInsets(0, 4, 0, 4));
        this.rootComponent.add((Component)this.minutes, 2, 0, 1, 1, 1, 0, 17, 1);
        this.setEnabled(false);
    }

    public void setTimeout(long timeout) {
        this.terminateTime.setText(Long.toString(Math.abs(timeout / 60000L)));
        if (timeout <= 0L) {
            this.setEnabled(false);
        } else {
            this.setEnabled(true);
        }
    }

    public long getTimeout() {
        String text = this.terminateTime.getText();
        if (text.length() == 0) {
            return 0L;
        }
        return 60000 * Integer.parseInt(text);
    }

    public void setEnabled(boolean enabled) {
        this.terminateInactiveSessionLabel.setEnabled(enabled);
        this.terminateTime.setEnabled(enabled);
        this.minutes.setEnabled(enabled);
    }

    public boolean eventIsFromPanel(ActionEvent e) {
        return e.getSource() == this.terminateTime;
    }

    public JTextField getTextField() {
        return this.terminateTime;
    }

    public void addKeyListener(KeyListener listener) {
        this.terminateTime.addKeyListener(listener);
    }
}

