/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.util;

import com.aem.utils.WindowsFirewall;
import java.io.File;
import java.util.Arrays;
import utils.message.Message;
import utils.ostools.OS;

public class WindowsFirewallUtil {
    public static void main(String[] args) {
        FirewallStatus fs = WindowsFirewallUtil.getLocalFirewallStatus(new String[0], new int[]{8309}, new File("C:\\Windows\\system32"));
        System.out.println(fs.toString());
        fs = FirewallStatus.fromMessage(fs.toMessage());
        System.out.println(fs.toString());
    }

    public static FirewallStatus getLocalFirewallStatus(String[] ipList, int[] portList, File shInstallDir) {
        if (ipList == null) {
            ipList = new String[]{};
        }
        if (portList == null) {
            portList = new int[]{};
        }
        System.out.println("[WindowsFirewall] Checking Firewall status.");
        FirewallStatus status = new FirewallStatus();
        status.isWindows = OS.isWindows();
        if (status.isWindows) {
            try {
                status.isRunning = WindowsFirewall.isFirewallRunning() ? 1 : 0;
            }
            catch (Throwable t) {
                System.out.println("[WindowsFirewall] Unable to determine firewall status: " + t.getMessage());
                status.isRunning = -1;
            }
            if (status.isRunning == 1) {
                try {
                    status.shIsExcepted = WindowsFirewall.isSimpleHelpExcepted(shInstallDir) ? 1 : 0;
                }
                catch (Throwable t) {
                    System.out.println("[WindowsFirewall] Unable to determine excepted status: " + t.getMessage());
                    status.shIsExcepted = -1;
                }
                status.portList = portList;
                status.portIsOpen = new int[portList.length];
                status.ipList = ipList;
                status.ipHasEnabledFirewall = new int[ipList.length];
                Arrays.fill(status.portIsOpen, -1);
                if (status.shIsExcepted == 0) {
                    int i;
                    for (i = 0; i < portList.length; ++i) {
                        try {
                            if (WindowsFirewall.isPortOpen(portList[i])) {
                                status.portIsOpen[i] = 1;
                                continue;
                            }
                            status.portIsOpen[i] = 0;
                            continue;
                        }
                        catch (Throwable t) {
                            System.out.println("[WindowsFirewall] Unable to determine port status(" + portList[i] + "): " + t.getMessage());
                            status.portIsOpen[i] = -1;
                        }
                    }
                    for (i = 0; i < ipList.length; ++i) {
                        try {
                            if (WindowsFirewall.isFirewallRunningOn(ipList[i])) {
                                status.ipHasEnabledFirewall[i] = 1;
                                continue;
                            }
                            status.ipHasEnabledFirewall[i] = 0;
                            continue;
                        }
                        catch (Throwable t) {
                            System.out.println("[WindowsFirewall] Unable to determine IP exception status(" + ipList[i] + "): " + t.getMessage());
                            status.ipHasEnabledFirewall[i] = -1;
                        }
                    }
                }
            }
        }
        return status;
    }

    public static class FirewallStatus {
        public boolean isWindows = false;
        public int isRunning = -1;
        public int shIsExcepted = -1;
        public int[] portList = new int[0];
        public int[] portIsOpen = new int[0];
        public String[] ipList = new String[0];
        public int[] ipHasEnabledFirewall = new int[0];

        public String toString() {
            int i;
            StringBuffer buffer = new StringBuffer();
            buffer.append("IsWindows=" + this.isWindows);
            buffer.append("\nisRunning=" + this.isRunning);
            buffer.append("\nshIsExcepted=" + this.shIsExcepted);
            for (i = 0; i < this.portList.length; ++i) {
                buffer.append("\n\tPort " + i + ": " + this.portList[i]);
            }
            for (i = 0; i < this.portIsOpen.length; ++i) {
                buffer.append("\n\tPortIsOpen " + i + ": " + this.portIsOpen[i]);
            }
            for (i = 0; i < this.ipList.length; ++i) {
                buffer.append("\n\tIP " + i + ": " + this.ipList[i]);
            }
            for (i = 0; i < this.ipHasEnabledFirewall.length; ++i) {
                buffer.append("\n\tipHasEnabledFirewall " + i + ": " + this.ipHasEnabledFirewall[i]);
            }
            return buffer.toString();
        }

        public int[] getOpenPortList() {
            int count = 0;
            for (int i = 0; i < this.portIsOpen.length; ++i) {
                if (this.portIsOpen[i] != 1) continue;
                ++count;
            }
            int[] result = new int[count];
            count = 0;
            for (int i = 0; i < this.portIsOpen.length; ++i) {
                if (this.portIsOpen[i] != 1) continue;
                result[count++] = this.portList[i];
            }
            return result;
        }

        public String[] getUnblockedIPList() {
            int count = 0;
            for (int i = 0; i < this.ipHasEnabledFirewall.length; ++i) {
                if (this.ipHasEnabledFirewall[i] != 0) continue;
                ++count;
            }
            String[] result = new String[count];
            count = 0;
            for (int i = 0; i < this.ipHasEnabledFirewall.length; ++i) {
                if (this.ipHasEnabledFirewall[i] != 0) continue;
                result[count++] = this.ipList[i];
            }
            return result;
        }

        public Message toMessage() {
            int i;
            Message message = new Message();
            message.append(this.isWindows);
            message.append(this.isRunning);
            message.append(this.shIsExcepted);
            message.append(this.portList.length);
            for (i = 0; i < this.portList.length; ++i) {
                message.append(this.portList[i]);
            }
            message.append(this.portIsOpen.length);
            for (i = 0; i < this.portIsOpen.length; ++i) {
                message.append(this.portIsOpen[i]);
            }
            message.append(this.ipList.length);
            for (i = 0; i < this.ipList.length; ++i) {
                message.append(this.ipList[i]);
            }
            message.append(this.ipHasEnabledFirewall.length);
            for (i = 0; i < this.ipHasEnabledFirewall.length; ++i) {
                message.append(this.ipHasEnabledFirewall[i]);
            }
            return message;
        }

        public static FirewallStatus fromMessage(Message message) {
            int i;
            int index = 0;
            FirewallStatus status = new FirewallStatus();
            status.isWindows = message.getAsBoolean(index++);
            status.isRunning = message.getAsInt(index++);
            status.shIsExcepted = message.getAsInt(index++);
            int length = message.getAsInt(index++);
            status.portList = new int[length];
            for (i = 0; i < length; ++i) {
                status.portList[i] = message.getAsInt(index++);
            }
            length = message.getAsInt(index++);
            status.portIsOpen = new int[length];
            for (i = 0; i < length; ++i) {
                status.portIsOpen[i] = message.getAsInt(index++);
            }
            length = message.getAsInt(index++);
            status.ipList = new String[length];
            for (i = 0; i < length; ++i) {
                status.ipList[i] = message.getAsString(index++);
            }
            length = message.getAsInt(index++);
            status.ipHasEnabledFirewall = new int[length];
            for (i = 0; i < length; ++i) {
                status.ipHasEnabledFirewall[i] = message.getAsInt(index++);
            }
            return status;
        }
    }
}

