/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.util;

import com.aem.sdesktop.ClientBranding;
import com.aem.shelp.common.Language;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import utils.ostools.osx.OSXAdapter;
import utils.swing.components.JWrapLabel;
import utils.swing.components.avatar.AvatarPanel;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.customlaf.SimpleHelpFrame;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanel;

public class TechPresenceVisibilityDialog
extends SimpleHelpFrame
implements ActionListener {
    private GbPanel main;
    private JButton chatButton;
    private JButton endSessionsButton;
    private Object UI_LOCK = new Object();
    private boolean isAccessSession;

    public TechPresenceVisibilityDialog(String title, boolean isAccessSession) {
        super(title);
        this.isAccessSession = isAccessSession;
        int W = SimpleHelpLookAndFeel.scale((int)500);
        this.setDefaultCloseOperation(0);
        this.setResizable(false);
        try {
            this.setIconImage(ClientBranding.get().getLogo32(true).getImage());
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        this.chatButton = new JButton(Language.get("CHAT_CUSTOMER_TITLE"), ImageLoader.getImageIcon((String)"images/svg/chat/chat.svg,16"));
        this.endSessionsButton = new JButton(Language.get("CLOSE_SESSION"), ImageLoader.getImageIcon((String)"images/svg/general/cancel.svg,16"));
        this.main = new GbPanel(new ScaledInsets(3, 3, 3, 3));
        GbPanel buttonPanel = new GbPanel();
        JPanel buttons = new JPanel(new GridLayout(1, 2, SimpleHelpLookAndFeel.scale((int)10), SimpleHelpLookAndFeel.scale((int)10)));
        buttons.add(this.endSessionsButton);
        if (isAccessSession) {
            buttons.add(this.chatButton);
        }
        buttonPanel.add((Component)buttons, 0, 0, 1, 1, 1, 1, 13, 0, (Insets)new ScaledInsets(3, 3, 5, 5));
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.main, "Center");
        panel.add((Component)buttonPanel, "South");
        this.getContentPane().add(panel);
        int H = SimpleHelpLookAndFeel.scale((int)buttonPanel.getPreferredSize().height) + SimpleHelpFrame.EMPTY_WINDOW_DECORATIONS_HEIGHT;
        this.setLocationRelativeTo(null);
        this.setSizeUnscaled(W, H);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTechnicianInfo(String name, long startTime, String from) {
        Object object = this.UI_LOCK;
        synchronized (object) {
            int componentCount = this.main.getComponentCount();
            for (int i = 0; i < componentCount; ++i) {
                final TechnicianInfoPanel infoPanel = (TechnicianInfoPanel)((Object)this.main.getComponent(i));
                if (!infoPanel.technicianName.equals(name) || infoPanel.sessionStartTime != startTime || !infoPanel.hostname.equals(from)) continue;
                if (componentCount == 1) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            TechPresenceVisibilityDialog.this.setVisible(false);
                        }
                    });
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TechPresenceVisibilityDialog.this.main.remove((Component)((Object)infoPanel));
                        int heightToRemove = infoPanel.getPreferredSize().height;
                        int W = TechPresenceVisibilityDialog.this.getWidth();
                        int H = TechPresenceVisibilityDialog.this.getHeight() - heightToRemove;
                        TechPresenceVisibilityDialog.this.setLocationRelativeTo(null);
                        TechPresenceVisibilityDialog.this.setSizeUnscaled(W, H);
                    }
                });
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTechnicianAvatar(String name, Image avatar) {
        Object object = this.UI_LOCK;
        synchronized (object) {
            int componentCount = this.main.getComponentCount();
            for (int i = 0; i < componentCount; ++i) {
                TechnicianInfoPanel tip;
                Component c = this.main.getComponent(i);
                if (!(c instanceof TechnicianInfoPanel) || !(tip = (TechnicianInfoPanel)((Object)c)).technicianName.equals(name)) continue;
                tip.setAvatar(avatar);
            }
        }
        this.main.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTechnicianInfo(String name, long startTime, Image avatar, String from) {
        Object object = this.UI_LOCK;
        synchronized (object) {
            int componentCount = this.main.getComponentCount();
            int extraSpace = 0;
            if (componentCount == 0) {
                extraSpace = 5;
            }
            TechnicianInfoPanel infoPanel = new TechnicianInfoPanel(name, startTime, avatar, from, this.isAccessSession);
            int additionalHeightNeeded = infoPanel.getPreferredSize().height + this.main.getGbPanelInsets().top + this.main.getGbPanelInsets().bottom + extraSpace;
            int W = this.getWidth();
            int H = this.getHeight() + additionalHeightNeeded;
            this.setLocationRelativeTo(null);
            this.setSizeUnscaled(W, H);
            this.main.add((Component)((Object)infoPanel), 0, componentCount, 1, 1, 1, 1, 10, 2);
            this.main.revalidate();
            if (componentCount > 0) {
                this.endSessionsButton.setText(Language.get("CLOSE_SESSIONS"));
            } else {
                this.endSessionsButton.setText(Language.get("CLOSE_SESSION"));
            }
        }
    }

    public void addActionListeners(ActionListener endSessionListener, ActionListener chatListener) {
        this.endSessionsButton.addActionListener(endSessionListener);
        this.chatButton.addActionListener(chatListener);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.toFront();
            this.requestFocus();
            OSXAdapter.requestForeground((boolean)false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.setVisible(false);
    }

    public static class TechnicianInfoPanel
    extends GbPanel {
        private Image avatar;
        private long sessionStartTime;
        private String technicianName;
        private AvatarPanel avatarPanel;
        private String hostname;
        private boolean isAccessSession;
        private JWrapLabel connectedLabel;
        private JLabel sinceLabel;
        private JLabel fromLabel;
        private boolean finished = false;

        public TechnicianInfoPanel(String technicianName, long sessionStartTime, Image avatar, String hostname, boolean isAccessSession) {
            super(new ScaledInsets(3, 3, 3, 3));
            this.technicianName = technicianName;
            this.isAccessSession = isAccessSession;
            this.sessionStartTime = sessionStartTime;
            this.avatar = avatar;
            this.hostname = hostname;
            this.initUI();
        }

        public void setAvatar(Image avatar) {
            this.avatar = avatar;
            this.avatarPanel.setAvatarImage(avatar);
        }

        private void initUI() {
            if (this.avatar == null) {
                this.avatar = ImageLoader.getAsImage((String)"images/svg/users/technician.svg,48");
            }
            this.avatarPanel = new AvatarPanel(56, 56, this.avatar, ImageLoader.getAsImage((String)"images/svg/users/technician.svg,48"), null);
            this.avatarPanel.setBorder(SHBorderFactory.createCompoundBorder((Border)SHBorderFactory.createLineBorder((Color)SHStyle.BORDER_COLOR), (Border)SHBorderFactory.createEmptyBorder((int)3, (int)3, (int)3, (int)3)));
            String formattedStartDate = DateFormat.getDateTimeInstance(3, 3).format(new Date(this.sessionStartTime));
            String fontColor = Integer.toHexString(SHStyle.EXAMPLE_TEXT_COLOR.getRGB());
            fontColor = fontColor.substring(2, fontColor.length());
            String text = this.isAccessSession ? this.technicianName + " " + Language.get("REMOTE_TECHNICIAN_CONNECTED_MSG_2") + "." : Language.get("REMOTE_TECHNICIAN_CONNECTED_MSG_SH") + " " + this.technicianName + ".";
            this.connectedLabel = new JWrapLabel("<html>" + text + "</html>");
            this.fromLabel = new JLabel("<html><font color=" + fontColor + ">" + Language.get("FROM") + ":</font> " + this.hostname);
            this.sinceLabel = new JLabel("<html><font color=" + fontColor + ">" + Language.get("SINCE") + ":</font> " + formattedStartDate);
            this.fromLabel.setFont(this.fromLabel.getFont().deriveFont(SHStyle.EXAMPLE_TEXT_FONT_SIZE));
            this.sinceLabel.setFont(this.sinceLabel.getFont().deriveFont(SHStyle.EXAMPLE_TEXT_FONT_SIZE));
            int Y = 0;
            this.add((Component)this.connectedLabel, 1, Y++, 1, 1, 1, 0, 17, 2, (Insets)new ScaledInsets(2, 3, 2, 3));
            if (!this.isAccessSession) {
                this.add(this.fromLabel, 1, Y++, 1, 1, 1, 0, 17, 2, (Insets)new ScaledInsets(1, 3, 1, 3));
            }
            this.add(this.sinceLabel, 1, Y++, 1, 1, 1, 0, 17, 2, (Insets)new ScaledInsets(1, 3, 2, 3));
            this.add((Component)((Object)this.avatarPanel), 0, 0, 1, Y + 1, 0, 0, 11, 0);
            this.add(new JPanel(), 1, Y++, 1, 1, 1, 1000, 10, 1);
        }

        public void setFinished() {
            if (this.finished) {
                return;
            }
            this.finished = true;
            System.out.println("[TechnicianInfoPanel] Setting finished");
            this.setEnabled(false);
            String text = this.isAccessSession ? Language.get("NO_LONGER_CONNECTED_SG", this.technicianName) + "." : Language.get("NO_LONGER_CONNECTED_SH", this.technicianName) + ".";
            System.out.println("[TechnicianInfoPanel] Message is " + text);
            this.connectedLabel.setText(text);
            this.connectedLabel.repaint();
        }

        public void setEnabled(boolean enabled) {
            System.out.println("[TechnicianInfoPanel] Setting enabled to " + enabled);
            this.connectedLabel.setEnabled(enabled);
            this.fromLabel.setEnabled(enabled);
            this.sinceLabel.setEnabled(enabled);
            this.avatarPanel.setEnabled(enabled);
        }

        public String getTechnicianName() {
            return this.technicianName;
        }
    }
}

