/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.util;

import build.BuildConstants;
import com.aem.sgateway.SimpleGatewayConfig;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.Properties;
import jwrapper.allplatformwrapper.AllPlatformWrapper;
import jwrapper.jwutils.JWSystem;
import jwrapper.logging.LogPoller;
import jwrapper.logging.ProcessOutputUtil;
import jwrapper.logging.ProcessResult;
import jwrapper.proxy.JWProxyCredentials;
import utils.message.Message;
import utils.string.HexData;

public class SimpleGatewayInstaller {
    private SimpleGatewayConfig config;
    private String updateURL;
    private ProcessOutputUtil outputUtil = null;
    private String supportedLanguages;
    private JWProxyCredentials.Credentials proxyCredentials;
    private Proxy proxy;
    private boolean installShortcuts = true;

    public SimpleGatewayInstaller(String updateURL, String supportedLanguages, File serviceConfigFile) throws Exception {
        this.updateURL = updateURL;
        this.supportedLanguages = supportedLanguages;
        this.config = new SimpleGatewayConfig(serviceConfigFile);
    }

    public SimpleGatewayInstaller(Message installMessage) throws Exception {
        this.updateURL = installMessage.getAsString(0);
        byte[] configBytes = (byte[])installMessage.get(1);
        String logFileLocation = installMessage.getAsString(2);
        this.outputUtil = SimpleGatewayInstaller.initLog(new File(logFileLocation));
        this.config = new SimpleGatewayConfig(configBytes);
        this.supportedLanguages = installMessage.getAsString(3);
        String proxyHost = installMessage.getAsString(4);
        int proxyPort = installMessage.getAsInt(5);
        String proxyUser = installMessage.getAsString(6);
        String proxyPass = installMessage.getAsString(7);
        System.out.println("[SimpleGatewayInstall] Host = " + proxyHost + " Port = " + proxyPort + " User = " + proxyUser);
        if (proxyHost != null && proxyHost.length() > 0) {
            this.proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, proxyPort));
            this.proxyCredentials = null;
            if (proxyUser != null && proxyUser.length() > 0) {
                this.proxyCredentials = new JWProxyCredentials.Credentials(proxyUser, proxyPass);
            }
        }
        this.installShortcuts = installMessage.getAsBoolean(8);
    }

    private static ProcessOutputUtil initLog(File logFile) throws FileNotFoundException {
        ProcessOutputUtil output = new ProcessOutputUtil("SimpleGatewayInstaller", logFile);
        output.logMessage("Created log file: " + logFile.getAbsolutePath());
        return output;
    }

    public static String getSGUpdateURL() {
        int doubleSlash;
        String updateURL = JWSystem.getUpdateURL();
        int nextSlash = updateURL.indexOf(47, (doubleSlash = updateURL.indexOf("://")) + 3);
        if (nextSlash != -1) {
            updateURL = updateURL.substring(0, nextSlash);
        }
        updateURL = updateURL + "/access";
        return updateURL;
    }

    public static Message getInstallMessageFor(String updateURL, String supportedLanguages, byte[] configBytes, String logFileToWriteTo, String proxyHost, int proxyPort, String proxyUser, String proxyPass, boolean installShortcuts) {
        Message m = new Message();
        m.append(updateURL);
        m.append(configBytes);
        m.append(logFileToWriteTo);
        m.append(supportedLanguages);
        m.append(proxyHost != null ? proxyHost : "");
        m.append(proxyPort);
        m.append(proxyUser != null ? proxyUser : "");
        m.append(proxyPass != null ? proxyPass : "");
        m.append(installShortcuts);
        return m;
    }

    public void installSimpleGateway(boolean waitForResult) {
        try {
            this.doInstallSimpleGateway(waitForResult);
            this.outputUtil.writeResult(1);
        }
        catch (Throwable t) {
            this.error(t.getMessage());
            this.stacktrace(t);
            this.outputUtil.writeResult(2);
        }
        finally {
            this.outputUtil.close();
        }
    }

    public void installSimpleGatewayAndThrowErrors(boolean waitForResult) throws Throwable {
        try {
            this.doInstallSimpleGateway(waitForResult);
            this.outputUtil.writeResult(1);
        }
        catch (Throwable t) {
            this.error(t.getMessage());
            this.stacktrace(t);
            this.outputUtil.writeResult(2);
            throw t;
        }
        finally {
            this.outputUtil.close();
        }
    }

    private void checkUpdateURL() {
        if (this.updateURL.endsWith("/")) {
            this.updateURL = this.updateURL.substring(0, this.updateURL.length() - 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doInstallSimpleGateway(boolean waitForResult) throws Exception {
        block10: {
            this.checkUpdateURL();
            this.println("[SimpleGatewayInstaller] Initiating all platforms installation");
            String appName = BuildConstants.BUNDLE_SG_SERVICE;
            String installType = "perm_all";
            boolean matchVersions = false;
            Properties lprops = new Properties();
            lprops.setProperty("sg_silent_install", "true");
            lprops.setProperty("sg_silent_install_config_xml", HexData.byteArrayToHexString((byte[])this.config.save(true)));
            if (!this.installShortcuts) {
                lprops.setProperty("sg_install_shortcuts", "false");
            }
            lprops.setProperty("supported_langs", this.supportedLanguages);
            lprops.setProperty("show_no_ui", "true");
            long WAIT = 300000L;
            lprops.setProperty("debug_logging_until", "" + (System.currentTimeMillis() + WAIT));
            this.println("[SimpleGatewayInstaller] Launching JW All Platforms Wrapper now, redirecting all output to log");
            PrintStream originalSout = System.out;
            System.setOut(this.outputUtil.getPrintStream());
            try {
                AllPlatformWrapper apw = new AllPlatformWrapper(appName, this.updateURL, installType, false, null, matchVersions, lprops, false, "5", false);
                try {
                    apw.setProxyToUse(this.proxy, this.proxyCredentials);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                LogPoller lp = apw.getLogPoller();
                lp.addReturnIfAutoupdateFailed();
                lp.addReturnOnErrorCase("Remote Access Configure");
                lp.addReturnOnAnyCase("Remote Access Service");
                apw.prepareForLaunch();
                apw.launchNow();
                if (!waitForResult) {
                    this.println("[SimpleGatewayInstaller] JW All Platforms Wrapper launched, ignoring result");
                    return;
                }
                this.println("[SimpleGatewayInstaller] JW All Platforms Wrapper launched, waiting for result");
                ProcessResult result = lp.waitForResult(WAIT);
                this.println("[SimpleGatewayInstaller] Got result");
                if (result != null && result.isOK()) {
                    this.println("[SimpleGatewayInstaller] Silent install worked");
                    break block10;
                }
                if (result == null) {
                    this.println("[SimpleGatewayInstaller] Silent install timed out");
                    throw new Exception("SimpleGateway installation timed out");
                }
                this.println("[SimpleGatewayInstaller] Silent install failed " + result);
                throw new Exception("SimpleGateway installation failed - " + result);
            }
            finally {
                System.setOut(originalSout);
            }
        }
    }

    private void error(String err) {
        System.err.println(err);
        if (this.outputUtil != null) {
            this.outputUtil.logError(err);
        }
    }

    private void stacktrace(Throwable t) {
        t.printStackTrace();
        if (this.outputUtil != null) {
            this.outputUtil.logStackTrace(t);
        }
    }

    private void println(String s) {
        System.out.println(s);
        if (this.outputUtil != null) {
            this.outputUtil.logMessage(s);
        }
    }
}

