/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.util;

import com.aem.utils.LogicalArray;
import com.aem.utils.StreamUtils;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.PrintStream;
import utils.swing.png.PngEncoder;

public class ScreenDataDump {
    public static PngEncoder enc;

    public static void dumpToPng(String file, LogicalArray la, int xs, int ys, int w, int h) {
        if (enc == null) {
            enc = new PngEncoder();
        }
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            for (int y = ys; y < ys + h; ++y) {
                for (int x = xs; x < xs + w; ++x) {
                    StreamUtils.writeRgbOnlyInt(bout, la.getXY(x, y));
                }
            }
            FileOutputStream fout = new FileOutputStream(file);
            fout.write(enc.encode(w, h, bout.toByteArray()));
            fout.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void dumpToInts(String file, LogicalArray la, int xs, int ys, int w, int h) {
        try {
            PrintStream fout = new PrintStream(new FileOutputStream(file));
            for (int y = ys; y < ys + h; ++y) {
                for (int x = xs; x < xs + w; ++x) {
                    fout.print(Integer.toHexString(la.getXY(x, y)) + ",");
                }
                fout.println("");
            }
            fout.flush();
            fout.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

