/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.util;

import com.kitfox.svg.SVGDiagram;
import com.kitfox.svg.SVGUniverse;
import com.kitfox.svg.app.beans.SVGIcon;
import com.kitfox.svg.xml.cpx.ColorOp;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.HashMap;
import javax.swing.Icon;
import utils.swing.images.HSLColor;
import utils.swing.images.ImageLoader;

public class SVGImageLoaderExtension
implements ImageLoader.ImageLoaderExtension {
    private static final HashMap<Color, Color> colorReplacementMap = new HashMap();
    private double scaling = 1.0;
    private static ColorOp contrastColorOp;
    private static ColorOp noGradientColorOp;
    private static ColorOp grayscaleColorOp;
    private static ColorOp lighterColorOp;
    private static ColorOp lightGreyColorOp;
    private static ColorOp dimmerColorOp;
    private static ColorOp lowSaturationOp;
    private static SVGUniverse universe;
    private static SVGUniverse originalUniverse;
    private static SVGUniverse disabledUniverse;
    private static SVGUniverse lighterUniverse;
    private static SVGUniverse dimmerUniverse;
    private static SVGUniverse testUniverse;
    private static SVGUniverse lowSaturationUniverse;
    private static SVGUniverse lightGreyUniverse;
    public static boolean forceDefaultTestOp;

    private static Color replace(Color color) {
        Color c = colorReplacementMap.get(color);
        if (c == null) {
            return color;
        }
        return c;
    }

    public static ImageLoader.ImageLoaderExtension getInstance() {
        return new SVGImageLoaderExtension();
    }

    private SVGImageLoaderExtension() {
    }

    public String getExtension() {
        return "svg";
    }

    public static void clearUniverse() {
        universe = null;
    }

    public static void setSVGTestBaseColor(Color c) {
        testUniverse = new SVGUniverse(new CommonBaseColorOp(c));
    }

    private static SVGUniverse getSVGUniverse(int op) {
        if (forceDefaultTestOp || op == 5) {
            if (testUniverse == null) {
                testUniverse = new SVGUniverse(new CommonBaseColorOp(new Color(70, 157, 246)));
            }
            return testUniverse;
        }
        if (op == 0) {
            if (universe == null) {
                universe = new SVGUniverse(contrastColorOp);
            }
            return universe;
        }
        if (op == 4) {
            if (originalUniverse == null) {
                originalUniverse = new SVGUniverse(noGradientColorOp);
            }
            return originalUniverse;
        }
        if (op == 1) {
            if (disabledUniverse == null) {
                disabledUniverse = new SVGUniverse(grayscaleColorOp);
            }
            return disabledUniverse;
        }
        if (op == 2) {
            if (lighterUniverse == null) {
                lighterUniverse = new SVGUniverse(lighterColorOp);
            }
            return lighterUniverse;
        }
        if (op == 3) {
            if (dimmerUniverse == null) {
                dimmerUniverse = new SVGUniverse(dimmerColorOp);
            }
            return dimmerUniverse;
        }
        if (op == 6) {
            if (lowSaturationUniverse == null) {
                lowSaturationUniverse = new SVGUniverse(lowSaturationOp);
            }
            return lowSaturationUniverse;
        }
        if (op == 7) {
            if (lightGreyUniverse == null) {
                lightGreyUniverse = new SVGUniverse(lightGreyColorOp);
            }
            return lightGreyUniverse;
        }
        return universe;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Icon loadImageIcon(String name, int op) throws IOException {
        URI uri;
        int w = -1;
        int h = -1;
        int commaIndex = name.indexOf(44);
        if (commaIndex == -1) {
            throw new IOException("Icon " + name + " does not have a size specified.");
        }
        String sizeString = name.substring(commaIndex + 1);
        if (sizeString.charAt(0) == 'h') {
            h = Integer.parseInt(sizeString.substring(1));
        } else {
            w = Integer.parseInt(sizeString);
        }
        name = name.substring(0, commaIndex);
        InputStream iconInputStream = null;
        SVGUniverse universe = SVGImageLoaderExtension.getSVGUniverse(op);
        SVGImageLoaderExtension sVGImageLoaderExtension = this;
        synchronized (sVGImageLoaderExtension) {
            File f;
            boolean loaded = universe.haveLoaded(name);
            if (!loaded && (iconInputStream = (f = ImageLoader.getFileForImage((String)name)) != null ? new BufferedInputStream(new FileInputStream(f)) : ImageLoader.getResourceInputStreamForImage((String)name)) == null) {
                throw new IOException("Unable to load SVG resource: " + name);
            }
            uri = universe.loadSVG(iconInputStream, name);
        }
        if (this.scaling != 1.0) {
            if (w != -1) {
                w = (int)((double)w * this.scaling);
            }
            if (h != -1) {
                h = (int)((double)h * this.scaling);
            }
        }
        SVGDiagram diagram = universe.getDiagram(uri);
        double ratio = diagram.getWidth() / diagram.getHeight();
        if (w == -1) {
            w = (int)(ratio * (double)h);
            if (ratio % (double)h > 0.0) {
                ++w;
            }
        } else {
            h = (int)((double)w / ratio);
            if ((double)w % ratio > 0.0) {
                ++h;
            }
        }
        SVGIcon icon = new SVGIcon(universe);
        icon.setAutosize(3);
        icon.setPreferredSize(new Dimension(w, h));
        icon.setAntiAlias(true);
        icon.setInterpolation(2);
        icon.setSvgURI(uri);
        return new ImageLoader.ReferencedIcon(name + "," + sizeString, op, (Icon)icon);
    }

    public void setScaling(double scaling) {
        this.scaling = scaling;
    }

    private Color scaleColor(double factor, Color col) {
        int red = col.getRed();
        int green = col.getGreen();
        int blue = col.getBlue();
        red = (int)Math.min(255.0, Math.max(0.0, factor * (double)red));
        green = (int)Math.min(255.0, Math.max(0.0, factor * (double)green));
        blue = (int)Math.min(255.0, Math.max(0.0, factor * (double)blue));
        return new Color(red, green, blue);
    }

    static {
        colorReplacementMap.put(new Color(239, 211, 88), new Color(250, 200, 50));
        colorReplacementMap.put(new Color(230, 230, 230), new Color(215, 215, 215));
        contrastColorOp = new ColorModificationOp(true);
        noGradientColorOp = new ColorModificationOp(false);
        grayscaleColorOp = new ColorOp(){

            @Override
            public Color filter(Color c) {
                HSLColor hsl = new HSLColor(c);
                return hsl.adjustSaturation(0.0f);
            }

            @Override
            public Paint modifyFillPaint(Paint p) {
                return p;
            }
        };
        lighterColorOp = new ColorOp(){

            @Override
            public Color filter(Color c) {
                HSLColor hsl = new HSLColor(c);
                return hsl.adjustLuminance(Math.min(hsl.getLuminance() + 10.0f, 100.0f));
            }

            @Override
            public Paint modifyFillPaint(Paint p) {
                return p;
            }
        };
        lightGreyColorOp = new ColorOp(){

            @Override
            public Color filter(Color c) {
                HSLColor hsl = new HSLColor(c);
                hsl = new HSLColor(hsl.adjustSaturation(0.0f));
                return hsl.adjustLuminance(Math.min(hsl.getLuminance() + 20.0f, 100.0f));
            }

            @Override
            public Paint modifyFillPaint(Paint p) {
                return p;
            }
        };
        dimmerColorOp = new ColorOp(){

            @Override
            public Color filter(Color c) {
                HSLColor hsl = new HSLColor(c);
                return hsl.adjustLuminance(Math.max(hsl.getLuminance() - 10.0f, 0.0f));
            }

            @Override
            public Paint modifyFillPaint(Paint p) {
                return p;
            }
        };
        lowSaturationOp = new ColorOp(){

            @Override
            public Color filter(Color c) {
                HSLColor hsl = new HSLColor(c);
                return hsl.adjustSaturation(Math.max(hsl.getSaturation() - 80.0f, 0.0f));
            }

            @Override
            public Paint modifyFillPaint(Paint p) {
                return p;
            }
        };
        forceDefaultTestOp = false;
    }

    public static class ColorModificationOp
    implements ColorOp {
        private final boolean includeGradient;

        public ColorModificationOp(boolean includeGradient) {
            this.includeGradient = includeGradient;
        }

        @Override
        public Color filter(Color c) {
            if (c == null) {
                return null;
            }
            HSLColor hsl = new HSLColor(c = SVGImageLoaderExtension.replace(c));
            if (hsl.getLuminance() < 80.0f) {
                return hsl.adjustTone(-10.0f);
            }
            return c;
        }

        @Override
        public Paint modifyFillPaint(Paint p) {
            Color c;
            HSLColor hsl;
            if (this.includeGradient && p instanceof Color && (hsl = new HSLColor(c = SVGImageLoaderExtension.replace((Color)p))).getLuminance() < 80.0f) {
                return new GradientPaint(0.0f, 0.0f, hsl.adjustTone(15.0f), 0.0f, 48.0f, hsl.adjustTone(-10.0f));
            }
            return p;
        }
    }

    public static class CommonBaseColorOp
    implements ColorOp {
        private final HSLColor hslBaseColor;
        private final Color baseColor;
        private final boolean includeGradient = false;

        public CommonBaseColorOp(Color baseColor) {
            this.baseColor = baseColor;
            this.hslBaseColor = new HSLColor(baseColor);
        }

        @Override
        public Color filter(Color c) {
            if (c == null) {
                return null;
            }
            c = SVGImageLoaderExtension.replace(c);
            String debug = c + " -> ";
            HSLColor hsl = new HSLColor(c);
            float targetSat = hsl.getLuminance();
            c = new Color(this.baseColor.getRed(), this.baseColor.getGreen(), this.baseColor.getBlue(), this.baseColor.getAlpha());
            hsl = new HSLColor(c);
            Color result = hsl.adjustLuminance(targetSat);
            debug = debug + result + " (targetSat:" + targetSat + ")";
            return result;
        }

        public static void main(String[] args) {
            Color[] tests;
            Color baseColor = new Color(70, 157, 246);
            for (Color test : tests = new Color[]{new Color(175, 175, 175), new Color(100, 100, 100)}) {
                System.out.print(test + " -> ");
                HSLColor hsl = new HSLColor(test);
                System.out.println(hsl.getLuminance());
                float targetSat = 40.0f + hsl.getLuminance() / 100.0f * 60.0f;
                Color c = new Color(baseColor.getRed(), baseColor.getGreen(), baseColor.getBlue(), baseColor.getAlpha());
                hsl = new HSLColor(c);
                Color result = hsl.adjustLuminance(targetSat);
                System.out.println(result + " (targetSat:" + targetSat + ")");
            }
        }

        @Override
        public Paint modifyFillPaint(Paint p) {
            return p;
        }
    }
}

