/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.util;

import com.aem.nodelink.NodeLink;
import com.aem.nodelink.NodeLinkStatusListener;
import com.aem.shelp.common.Language;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.font.TextAttribute;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.HashMap;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JWindow;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import utils.ostools.OS;
import utils.ostools.osx.OSXAdapter;
import utils.swing.JTextLabel;
import utils.swing.SafeAwtUtilities;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHButtonUI;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.customlaf.SimpleHelpFrame;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.images.ColorFader;
import utils.swing.images.ImageHelper;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanel;

public class PopupNotificationWindow
implements ActionListener {
    private JWindow dialog = new JWindow();
    private final Object LOCK = new Object();
    private boolean okPressed = false;
    private JButton allow;
    private JButton deny;
    public static final int ORIENTATION_TOP = 1;
    public static final int ORIENTATION_BOTTOM = 1;
    private ColorFader borderColorFader = new ColorFader(SHStyle.ROW_SELECTION_BACKGROUND, new Color(250, 0, 22), 20, true);
    private ColorFader iconBackgroundFader = new ColorFader(SHStyle.PANEL_BACKGROUND_BLUE_LIGHTER, new Color(255, 190, 190), 20, true);
    private Color borderColor = this.borderColorFader.nextColor();
    private Color backgroundColor = this.iconBackgroundFader.nextColor();
    private JLabel iconLabel;
    private ModifiableLineBorder alarmBorder = new ModifiableLineBorder(this.borderColor, SimpleHelpLookAndFeel.scale((int)5));
    GbPanel contentPanel = new GbPanel(){

        public void paintComponent(Graphics g) {
            PopupNotificationWindow.this.iconLabel.setBackground(PopupNotificationWindow.this.backgroundColor);
            PopupNotificationWindow.this.alarmBorder.setColor(PopupNotificationWindow.this.borderColor);
            super.paintComponent(g);
        }
    };

    public boolean showMessage(ImageIcon icon, ImageIcon questionIcon, String text, long timeout) throws NotificationTimedOut {
        if (OS.isMacOS()) {
            return this.showMessage(icon, questionIcon, text, 1, timeout);
        }
        Insets toolHeight = Toolkit.getDefaultToolkit().getScreenInsets(this.dialog.getGraphicsConfiguration());
        if (toolHeight.bottom > toolHeight.top) {
            return this.showMessage(icon, questionIcon, text, 1, timeout);
        }
        return this.showMessage(icon, questionIcon, text, 1, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean showMessage(ImageIcon icon, ImageIcon questionIcon, String text, int dialogOrientation, long timeout) throws NotificationTimedOut {
        System.out.println("[PopupNotificationWindow] Showing message dialog...");
        OSXAdapter.requestForeground((boolean)true);
        this.dialog.setAlwaysOnTop(true);
        this.dialog.getRootPane().putClientProperty("apple.awt.draggableWindowBackground", Boolean.FALSE);
        this.initContent(icon, questionIcon, text);
        Dimension scrSize = Toolkit.getDefaultToolkit().getScreenSize();
        Insets toolHeight = Toolkit.getDefaultToolkit().getScreenInsets(this.dialog.getGraphicsConfiguration());
        int x = scrSize.width - this.dialog.getWidth() - 20;
        int y = scrSize.height - toolHeight.bottom - this.dialog.getHeight() - 20;
        if (dialogOrientation == 1) {
            y = toolHeight.top + 20;
        }
        this.dialog.setLocation(x, y);
        System.out.println("[PopupNotificationWindow] Location is " + x + "," + y);
        this.dialog.getContentPane().add((Component)this.contentPanel);
        TimeoutThread thread = null;
        if (timeout > 0L) {
            thread = new TimeoutThread(timeout);
        }
        Object object = this.LOCK;
        synchronized (object) {
            new WindowFader(this.dialog).start();
            try {
                this.LOCK.wait();
            }
            catch (InterruptedException ex) {
                return false;
            }
            if (thread != null && thread.isTimedOut) {
                this.closeDialog();
                throw new NotificationTimedOut();
            }
        }
        return this.okPressed;
    }

    private void initContent(ImageIcon icon, ImageIcon questionIcon, String text) {
        JLabel accessIcon = questionIcon == null ? new JLabel(ImageLoader.getImageIcon((String)"images/svg/dialogs/question.svg,48")) : new JLabel(questionIcon);
        JLabel title = new JLabel(Language.DEFLANG.getString("ACCESS_REQUEST"));
        this.iconLabel = new JLabel(icon);
        HashMap<TextAttribute, Float> textAttributes = new HashMap<TextAttribute, Float>();
        textAttributes.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
        textAttributes.put(TextAttribute.SIZE, Float.valueOf(SimpleHelpLookAndFeel.scale((float)18.0f)));
        Font font = title.getFont().deriveFont(textAttributes);
        title.setFont(font);
        textAttributes.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_REGULAR);
        textAttributes.put(TextAttribute.SIZE, Float.valueOf(SimpleHelpLookAndFeel.scale((float)12.0f)));
        font = title.getFont().deriveFont(textAttributes);
        JTextLabel message = new JTextLabel(text);
        message.fixSizeByWidth(SimpleHelpLookAndFeel.scale((int)400));
        message.setWrapStyleWord(true);
        message.setFont(font);
        int Y = 0;
        if (icon != null) {
            this.iconLabel.setBorder(SHBorderFactory.createCompoundBorder((Border)SHBorderFactory.createMatteBorder((int)0, (int)0, (int)1, (int)0, (Color)SHStyle.LIGHT_GRAY_HORIZONTAL_LINE), (Border)SHBorderFactory.createEmptyBorder((int)10, (int)0, (int)10, (int)0)));
            this.iconLabel.setHorizontalAlignment(0);
            this.iconLabel.setVerticalAlignment(0);
            this.iconLabel.setBackground(SHStyle.PANEL_BACKGROUND_BLUE);
            this.iconLabel.setOpaque(true);
            this.contentPanel.add((Component)this.iconLabel, 0, Y++, 2, 1, 0, 0, 11, 1);
        }
        this.contentPanel.add((Component)accessIcon, 0, Y, 1, 2, 0, 0, 11, 0, (Insets)new ScaledInsets(15, 15, 0, 15));
        this.contentPanel.add((Component)title, 1, Y++, 1, 1, 1, 0, 18, 2, (Insets)new ScaledInsets(20, 0, 0, 0));
        this.contentPanel.add((Component)message, 1, Y++, 1, 1, 1, 100, 11, 1, (Insets)new ScaledInsets(5, 2, 0, 10));
        this.allow = new JButton(Language.DEFLANG.getString("ALLOW"));
        if (Language.exists("GRANT_ACCESS")) {
            this.allow.setText(Language.get("GRANT_ACCESS"));
        }
        this.allow.setIcon(ImageLoader.getImageIcon((String)"images/svg/general/ok.svg,16"));
        SHButtonUI.makeButtonGreen((JButton)this.allow);
        this.deny = new JButton(Language.DEFLANG.getString("DENY"));
        this.deny.setOpaque(false);
        this.deny.setIcon(ImageLoader.getImageIconDisabled((String)"images/svg/general/cancel.svg,16"));
        this.allow.setMargin((Insets)new ScaledInsets(7, 10, 7, 10));
        this.deny.setMargin((Insets)new ScaledInsets(7, 10, 7, 10));
        GbPanel buttonsPanel = new GbPanel();
        buttonsPanel.setOpaque(false);
        buttonsPanel.add((Component)this.deny, 0, 0, 1, 1, 1, 0, 17, 3);
        buttonsPanel.add((Component)this.allow, 1, 0, 1, 1, 0, 0, 17, 3);
        this.contentPanel.add((Component)buttonsPanel, 1, Y++, 1, 1, 1, 1, 13, 1, (Insets)new ScaledInsets(20, 0, 20, 20));
        this.contentPanel.setBorder((Border)this.alarmBorder);
        int totalHeight = this.alarmBorder.getThickness() * 2;
        totalHeight += this.iconLabel.getPreferredSize().height;
        totalHeight += buttonsPanel.getPreferredSize().height;
        totalHeight += message.getPreferredSize().height;
        this.dialog.setSize(SimpleHelpLookAndFeel.scale((int)400), totalHeight += SimpleHelpLookAndFeel.scale((int)100));
        title.setForeground(new Color(100, 100, 100));
        message.setForeground(new Color(50, 50, 50));
        this.allow.addActionListener(this);
        this.deny.addActionListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeDialog() {
        Object object = this.LOCK;
        synchronized (object) {
            this.dialog.setVisible(false);
            this.LOCK.notify();
        }
    }

    public static void main(String[] args) throws Exception {
        SimpleHelpFrame.getTestFrame();
        BufferedImage read = ImageIO.read(new File("SimpleHelp/installer/builds/access/JWrapper-Remote Access-splash.png"));
        read = ImageHelper.scaleDownToFitInside((BufferedImage)read, (int)300, (int)96);
        Language.loadTranslations();
        System.setProperty("apple.awt.UIElement", "true");
        SimpleHelpFrame.setLnf();
        new PopupNotificationWindow().showMessage(new ImageIcon(read), null, "George has requested access to this machine", 15000L);
        System.out.println("DONE");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        Object object = this.LOCK;
        synchronized (object) {
            this.okPressed = e.getSource() == this.allow;
            this.dialog.setVisible(false);
            this.LOCK.notify();
        }
    }

    public static class ClosablePopupNotificationWindow
    extends PopupNotificationWindow
    implements NodeLinkStatusListener {
        @Override
        public void linkDown(NodeLink link, Throwable reason) {
            System.out.println("[ClosablePopupNotificationWindow] Link down");
            this.closeDialog();
        }

        @Override
        public void linkOK(NodeLink link) {
        }

        @Override
        public void linkDead(NodeLink link, String reason) {
            System.out.println("[ClosablePopupNotificationWindow] Link dead");
            this.closeDialog();
        }
    }

    private static class ModifiableLineBorder
    extends LineBorder {
        public ModifiableLineBorder(Color color) {
            super(color);
        }

        public ModifiableLineBorder(Color color, int thickness) {
            super(color, thickness);
        }

        public void setColor(Color lineColor) {
            this.lineColor = lineColor;
        }
    }

    public class NotificationTimedOut
    extends Exception {
    }

    class TimeoutThread
    extends Thread {
        private final long timeout;
        private boolean isTimedOut = false;

        public TimeoutThread(long timeout) {
            this.timeout = timeout;
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Thread.sleep(this.timeout);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.isTimedOut = true;
            Object object = PopupNotificationWindow.this.LOCK;
            synchronized (object) {
                PopupNotificationWindow.this.LOCK.notifyAll();
            }
        }
    }

    class WindowFader
    extends Thread {
        private JWindow dialog;

        public WindowFader(JWindow dialog) {
            this.dialog = dialog;
        }

        @Override
        public void run() {
            if (!SafeAwtUtilities.isSupported()) {
                this.dialog.setVisible(true);
            } else {
                SafeAwtUtilities.setWindowOpacity(this.dialog, 0.0f);
                this.dialog.setVisible(true);
                float f = 0.0f;
                while (f <= 1.0f) {
                    SafeAwtUtilities.setWindowOpacity(this.dialog, f);
                    try {
                        Thread.sleep(30L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    f = (float)((double)f + 0.2);
                }
            }
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            while (this.dialog.isVisible()) {
                try {
                    if (PopupNotificationWindow.this.borderColorFader.atStart()) {
                        Thread.sleep(3000L);
                    } else {
                        Thread.sleep(30L);
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                PopupNotificationWindow.this.borderColor = PopupNotificationWindow.this.borderColorFader.nextColor();
                PopupNotificationWindow.this.backgroundColor = PopupNotificationWindow.this.iconBackgroundFader.nextColor();
                this.dialog.repaint();
            }
        }
    }

    class WindowMover
    extends Thread {
        private JWindow dialog;
        private Insets toolHeight;
        private Dimension scrSize;
        private int x;

        public WindowMover(int x, Dimension scrSize, Insets toolHeight, JWindow dialog) {
            this.x = x;
            this.scrSize = scrSize;
            this.toolHeight = toolHeight;
            this.dialog = dialog;
        }

        @Override
        public void run() {
            int endHeight = this.scrSize.height - this.toolHeight.bottom - this.dialog.getHeight() - 20;
            for (int offset = this.dialog.getHeight(); offset >= 0; offset -= 2) {
                int y = endHeight + offset;
                this.dialog.setLocation(this.x, y);
                try {
                    Thread.sleep(7L);
                    continue;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

