/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.util;

import com.aem.utils.NativeLibraryLoader;
import com.aem.utils.NativeScreenUtil;
import java.awt.MouseInfo;
import java.awt.Point;
import java.io.File;
import java.io.OutputStream;
import jwrapper.jwutils.JWSystem;
import utils.files.PermissionsUtil;
import utils.ostools.OS;
import utils.progtools.ProcessPrinter;

public class MousePositionUtil {
    private static final Object[] emptyObject = new Object[0];
    private static final Class[] emptyClass = new Class[0];
    private boolean available = false;
    private boolean osxNativeAvailable = false;
    static final Object LOCK = new Object();
    private static MousePositionUtil INSTANCE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MousePositionUtil get() {
        Object object = LOCK;
        synchronized (object) {
            if (INSTANCE == null) {
                INSTANCE = new MousePositionUtil();
            }
            return INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MousePositionUtil() {
        Object object = LOCK;
        synchronized (object) {
            try {
                MouseInfo.getPointerInfo().getLocation();
                this.available = true;
            }
            catch (Throwable t) {
                t.printStackTrace();
                this.available = false;
            }
            if (OS.isMacOS() && NativeScreenUtil.getInstance() != null) {
                this.osxNativeAvailable = true;
                System.out.println("[MousePositionUtil] OSX native available");
            }
            INSTANCE = this;
        }
    }

    public Point getLocation() {
        if (this.osxNativeAvailable) {
            Point p = new Point();
            NativeScreenUtil.getInstance().getMouseLocation(p);
            return p;
        }
        try {
            return MouseInfo.getPointerInfo().getLocation();
        }
        catch (Throwable t) {
            this.available = false;
            t.printStackTrace();
            return null;
        }
    }

    public Point getRobustLocationSum() {
        if (OS.isWindowsVistaOrAbove()) {
            File nativeLibsFile = JWSystem.getAppFolder();
            String path = nativeLibsFile.getAbsolutePath();
            try {
                Process p = Runtime.getRuntime().exec(new String[]{path + "\\session_win.exe", "--slWaitForCompletion", path + "\\elev_win.exe", "--mouselocation"});
                new ProcessPrinter(p, (OutputStream)new PermissionsUtil.NullOutputStream(), (OutputStream)new PermissionsUtil.NullOutputStream());
                int returnCode = p.waitFor();
                Point point = new Point();
                point.x = returnCode;
                point.y = returnCode;
                return point;
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return this.getLocation();
    }

    public static void main(String[] args) throws InterruptedException {
        NativeLibraryLoader.loadLibrary();
        MousePositionUtil mpUtil = new MousePositionUtil();
        mpUtil.getLocation();
        long t = System.currentTimeMillis();
        for (int i = 0; i < 10000; ++i) {
            System.out.println("1) " + mpUtil.getLocation());
            int shortX = mpUtil.getLocation().x;
            int shortY = mpUtil.getLocation().y;
            int tmp = mpUtil.getLocation().x + 1 << 16 | mpUtil.getLocation().y + 1;
            System.out.println(tmp);
            int pointerx = (0xFFFF & tmp >>> 16) - 1;
            int pointery = (0xFFFF & tmp) - 1;
            System.out.println("Back: " + pointerx + " " + pointery);
            Thread.sleep(1000L);
        }
        System.out.println(System.currentTimeMillis() - t);
    }

    public boolean isAvailable() {
        return this.available || this.osxNativeAvailable;
    }
}

