/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.util;

public class ByteModder {
    int bits;
    public byte[] ref = new byte[256];

    public ByteModder(int coldepth) {
        if (coldepth < 2) {
            coldepth = 2;
        }
        if (coldepth > 255) {
            coldepth = 255;
        }
        this.bits = 255 / coldepth;
        this.init();
    }

    private void init() {
        int k;
        for (k = 0; k < 128; ++k) {
            this.ref[k + 128] = this.modSlow((byte)(0xFF & k));
        }
        for (k = 128; k < 256; ++k) {
            this.ref[k - 128] = this.modSlow((byte)(0xFF & k));
        }
    }

    public int getBits() {
        return this.bits;
    }

    public byte modFast(byte dat) {
        return this.ref[dat + 128];
    }

    private byte modSlow(byte dat) {
        if (this.bits > 1) {
            int tmp = 0xFF & dat;
            tmp = tmp % this.bits <= this.bits / 2 ? (tmp -= tmp % this.bits) : (tmp += this.bits - tmp % this.bits);
            if (tmp > 255) {
                tmp = 255;
            }
            if (tmp < 0) {
                tmp = 0;
            }
            dat = (byte)(0xFF & tmp);
        }
        if (dat == 0) {
            return 1;
        }
        return dat;
    }

    public int modRGBDEBUG(int rgb) {
        byte b1 = this.ref[128 + (byte)(rgb >>> 16)];
        byte b2 = this.ref[128 + (byte)(rgb >>> 8)];
        byte b3 = this.ref[128 + (byte)rgb];
        int colorModded = 0;
        colorModded = colorModded << 8 | 0xFF & b1;
        colorModded = colorModded << 8 | 0xFF & b2;
        colorModded = colorModded << 8 | 0xFF & b3;
        return colorModded;
    }
}

