/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.util;

import com.aem.nodelink.utils.SafeClock;
import java.util.Arrays;
import java.util.HashMap;
import utils.progtools.PrintingUtil;
import utils.progtools.time.Times;

public class BandwidthReporting {
    private static final String PERIOD_ALL = "All Bandwidth Usage";
    private static Object LOCK = new Object();
    private static HashMap<String, Period> map = new HashMap();
    private static long lastPeriodStart = 0L;
    private static long periodLength = Times.ONE_MINUTE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void printPeriods() {
        Object object = LOCK;
        synchronized (object) {
            Object[] keys = map.keySet().toArray(new String[0]);
            Arrays.sort(keys);
            long secs = (SafeClock.currentTimeMillis() - lastPeriodStart) / 1000L;
            System.out.println("Bandwidth Usage Sample : " + secs + " seconds, x" + keys.length);
            for (Object key : keys) {
                Period period = map.get(key);
                period.seconds = secs;
                System.out.println(period);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Period getPeriod(String desc) {
        Object object = LOCK;
        synchronized (object) {
            Period period;
            if (lastPeriodStart == 0L) {
                lastPeriodStart = SafeClock.currentTimeMillis();
                map.clear();
            }
            if (System.currentTimeMillis() - lastPeriodStart > periodLength) {
                BandwidthReporting.printPeriods();
                lastPeriodStart = SafeClock.currentTimeMillis();
                map.clear();
            }
            if ((period = map.get(desc)) == null) {
                period = new Period(desc);
                map.put(desc, period);
            }
            return period;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sentHttp(String desc, int serialisedLength) {
        Object object = LOCK;
        synchronized (object) {
            BandwidthReporting.getPeriod((String)desc).sent += (long)serialisedLength;
            BandwidthReporting.getPeriod((String)PERIOD_ALL).sent += (long)serialisedLength;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void receivedHttp(String desc, int serialisedLength) {
        Object object = LOCK;
        synchronized (object) {
            BandwidthReporting.getPeriod((String)desc).received += (long)serialisedLength;
            BandwidthReporting.getPeriod((String)PERIOD_ALL).received += (long)serialisedLength;
        }
    }

    public static void main(String[] args) throws Exception {
        periodLength = 10000L;
        for (int i = 0; i < 31; ++i) {
            BandwidthReporting.sentHttp("Poopies", 500);
            Thread.sleep(1000L);
        }
    }

    static class Period {
        String name;
        long sent;
        long received;
        double seconds;

        public Period(String name) {
            this.name = name;
        }

        public long getSent() {
            return this.sent;
        }

        public long getReceived() {
            return this.received;
        }

        public double getTransferred() {
            return this.sent + this.received;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            double bytesPerSecond = this.getTransferred() / this.seconds;
            double bytesPerMinute = bytesPerSecond * 60.0;
            double mbit10k = 8.0 * bytesPerSecond * 10000.0 / 1000000.0;
            sb.append("    " + this.name + " : " + PrintingUtil.df0((double)bytesPerMinute) + " B/min, " + PrintingUtil.df0((double)bytesPerSecond) + " B/sec, " + PrintingUtil.df2((double)mbit10k) + " Mbit for n=10k (^" + PrintingUtil.df0((double)this.getSent()) + "/v" + PrintingUtil.df0((double)this.getReceived()) + ")");
            return sb.toString();
        }
    }
}

