/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.video;

import com.aem.shelp.proxy.types.AbstractSession;
import java.awt.Dimension;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import utils.message.Message;
import utils.message.MessageUtils;

public class VideoMetadata {
    private static final int RECORDER_VERSION = 3;
    private long startTime = System.currentTimeMillis();
    private long duration;
    private int maxScreenWidth = 0;
    private int maxScreenHeight = 0;
    private boolean useColourRLE = true;
    private AbstractSession session;
    private boolean changed = false;

    public String toString() {
        return "VideoMetadata (duration=" + this.duration + ") (start=" + this.startTime + ") (size=" + this.maxScreenWidth + "," + this.maxScreenHeight + ")";
    }

    public VideoMetadata(AbstractSession session) {
        this.session = session;
    }

    public byte[] serialise() throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        DataOutputStream dout = new DataOutputStream(bout);
        dout.writeInt(3);
        dout.writeLong(this.startTime);
        dout.writeLong(this.duration);
        byte[] message = MessageUtils.messageToBytes((Message)this.session.toMessage());
        dout.writeInt(message.length);
        dout.write(message);
        dout.writeInt(this.maxScreenWidth);
        dout.writeInt(this.maxScreenHeight);
        dout.writeBoolean(this.useColourRLE);
        dout.flush();
        return bout.toByteArray();
    }

    public static VideoMetadata deserialise(byte[] data) throws IOException {
        ByteArrayInputStream bin = new ByteArrayInputStream(data);
        DataInputStream dis = new DataInputStream(bin);
        long startTime = 0L;
        long duration = 0L;
        AbstractSession session = null;
        boolean useColourRLE = true;
        int width = 0;
        int height = 0;
        int version = dis.readInt();
        if (version >= 1) {
            startTime = dis.readLong();
            duration = dis.readLong();
            int messageLength = dis.readInt();
            byte[] msgBytes = new byte[messageLength];
            dis.read(msgBytes);
            Message m = MessageUtils.bytesToMessage((byte[])msgBytes);
            session = AbstractSession.fromMessage(m);
        }
        if (version >= 2) {
            width = dis.readInt();
            height = dis.readInt();
        }
        if (version >= 3) {
            useColourRLE = dis.readBoolean();
        }
        VideoMetadata vm = new VideoMetadata(session);
        vm.setDuration(duration);
        vm.setStartTime(startTime);
        vm.setScreenSize(width, height);
        vm.useColourRLE = useColourRLE;
        return vm;
    }

    public void setIsSaved() {
        this.changed = false;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void setScreenSize(int width, int height) {
        int newMaxScreenWidth = Math.max(width, this.maxScreenWidth);
        int newMaxScreenHeight = Math.max(height, this.maxScreenHeight);
        if (newMaxScreenWidth == this.maxScreenWidth && newMaxScreenHeight == this.maxScreenHeight) {
            return;
        }
        this.maxScreenWidth = newMaxScreenWidth;
        this.maxScreenHeight = newMaxScreenHeight;
        this.changed = true;
    }

    public void setDuration(long totalRecordedTime) {
        if (this.duration != totalRecordedTime) {
            this.changed = true;
            this.duration = totalRecordedTime;
        }
    }

    public long getDuration() {
        return this.duration;
    }

    public void setStartTime(long startTime) {
        if (this.startTime != startTime) {
            this.startTime = startTime;
            this.changed = true;
        }
    }

    public Dimension getScreenSize() {
        if (this.maxScreenWidth == 0 || this.maxScreenHeight == 0) {
            return null;
        }
        return new Dimension(this.maxScreenWidth, this.maxScreenHeight);
    }

    public boolean useColorRLE() {
        return this.useColourRLE;
    }
}

