/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.utils.tools;

import com.aem.shelp.common.toolbox.ToolBox;
import com.aem.shelp.common.toolbox.ToolBoxGroup;
import com.aem.shelp.common.toolbox.ToolBoxItem;
import com.aem.shelp.proxy.types.Machine;
import com.aem.shelp.tech.access.utils.MachineSelection;
import com.aem.shelp.tech.properties.ToolBoxPropertiesPanel;
import com.aem.shelp.tech.toolbox.ToolBoxResultWrapper;
import com.aem.shelp.tech.toolbox.ToolBoxUI;

public abstract class AbstractToolPopup
extends ToolBoxUI {
    protected AbstractToolPopup(int machineCount, int[] operatingSystemsIncluded) {
        super(false, operatingSystemsIncluded, machineCount);
    }

    @Override
    public void performSave() {
    }

    @Override
    public void synchroniseResources(ToolBoxUI ui, ToolBoxItem item, ToolBoxPropertiesPanel.SyncCancelledListener listener) {
    }

    @Override
    public void synchroniseResourcesAndBlock(ToolBox toolbox, ToolBoxItem item, ToolBoxPropertiesPanel.SyncCancelledListener listener) {
    }

    @Override
    public ToolBoxGroup[] getSharedToolboxGroups() {
        return null;
    }

    protected abstract void hidePopup();

    @Override
    public ToolBoxResultWrapper runItem(ToolBoxItem item) {
        this.hidePopup();
        System.out.println("[PickAToolPopup] Tool selected for execution " + item);
        int sessionsToUse = this.getSessionsToUse();
        this.runToolBoxItem(item, sessionsToUse);
        return null;
    }

    public abstract void runToolBoxItem(ToolBoxItem var1, int var2);

    public static int[] getOSFor(Machine machine) {
        int[] result = new int[1];
        if (machine.getOsBaseType() == 0) {
            result[0] = 0;
        }
        if (machine.getOsBaseType() == 1) {
            result[0] = 1;
        }
        if (machine.getOsBaseType() == 2) {
            result[0] = 2;
        }
        return result;
    }

    public static int[] getForAllOS() {
        return new int[]{0, 1, 2};
    }

    public static int[] getOSFor(MachineSelection machines, boolean onlineOnly) {
        int count = 0;
        if (onlineOnly) {
            if (machines.windows > 0) {
                ++count;
            }
            if (machines.osx > 0) {
                ++count;
            }
            if (machines.linux > 0) {
                ++count;
            }
        } else {
            if (machines.getTotalWindows() > 0) {
                ++count;
            }
            if (machines.getTotalMacos() > 0) {
                ++count;
            }
            if (machines.getTotalLinux() > 0) {
                ++count;
            }
        }
        int[] result = new int[count];
        count = 0;
        if (onlineOnly) {
            if (machines.windows > 0) {
                result[count++] = 0;
            }
            if (machines.osx > 0) {
                result[count++] = 1;
            }
            if (machines.linux > 0) {
                result[count++] = 2;
            }
        } else {
            if (machines.getTotalWindows() > 0) {
                result[count++] = 0;
            }
            if (machines.getTotalMacos() > 0) {
                result[count++] = 1;
            }
            if (machines.getTotalLinux() > 0) {
                result[count++] = 2;
            }
        }
        return result;
    }
}

