/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.utils.filters;

import com.aem.shelp.proxy.types.Machine;
import com.aem.shelp.proxy.types.filters.Filter;
import com.aem.shelp.proxy.types.filters.MachineFilter;
import com.aem.shelp.proxy.types.filters.SimpleMachineFilter;
import java.util.ArrayList;
import java.util.Iterator;

public class FilterLogicUtil {
    public static ArrayList<Machine> getShownMachines(Filter[] filters, SimpleMachineFilter simpleMachineFilter, ArrayList<Machine> allMachines) {
        FilterResult result = new FilterResult();
        result.allMachines = new ArrayList();
        boolean allHide = FilterLogicUtil.areAllHide(filters, simpleMachineFilter);
        for (Machine m : allMachines) {
            FilterLogicUtil.processFilter(m, filters, simpleMachineFilter, result, allHide);
        }
        return result.allMachines;
    }

    public static FilterResult applyFiltersToMachines(Filter[] filters, SimpleMachineFilter simpleMachineFilter, Iterator<Machine> descendentElements) {
        FilterResult result = new FilterResult();
        result.allMachines = new ArrayList();
        boolean allHide = FilterLogicUtil.areAllHide(filters, simpleMachineFilter);
        while (descendentElements.hasNext()) {
            Machine m = descendentElements.next();
            FilterLogicUtil.processFilter(m, filters, simpleMachineFilter, result, allHide);
        }
        return result;
    }

    private static boolean areAllHide(Filter[] filters, SimpleMachineFilter simpleFilter) {
        boolean areAllHide = false;
        if (simpleFilter != null) {
            return !simpleFilter.containsAnyIncludes();
        }
        if (filters.length > 0) {
            areAllHide = true;
            for (Filter f : filters) {
                if (!f.isShow()) continue;
                areAllHide = false;
            }
        }
        return areAllHide;
    }

    private static void processFilter(Machine m, Filter[] filters, SimpleMachineFilter simpleFilter, FilterResult result, boolean allHide) {
        block8: {
            boolean machineProcessed;
            block10: {
                block9: {
                    block7: {
                        if (filters != null && filters.length != 0 || simpleFilter != null && !simpleFilter.isEmpty()) break block7;
                        result.allMachines.add(m);
                        ++result.included;
                        break block8;
                    }
                    machineProcessed = false;
                    if (simpleFilter == null) break block9;
                    Boolean state = simpleFilter.getStateFor(m, true);
                    if (state == null) break block10;
                    if (state.booleanValue()) {
                        machineProcessed = true;
                        result.allMachines.add(m);
                        ++result.included;
                    } else {
                        machineProcessed = true;
                        ++result.excluded;
                    }
                    break block10;
                }
                for (Filter f : filters) {
                    MachineFilter ff;
                    if (!(f instanceof MachineFilter) || !(ff = (MachineFilter)f).include(m)) continue;
                    machineProcessed = true;
                    if (ff.isShow()) {
                        result.allMachines.add(m);
                        ++result.included;
                        break;
                    }
                    ++result.excluded;
                    break;
                }
            }
            if (!machineProcessed) {
                if (allHide) {
                    result.allMachines.add(m);
                    ++result.included;
                } else {
                    ++result.excluded;
                }
            }
        }
    }

    static class FilterResult {
        ArrayList<Machine> allMachines;
        int included = 0;
        int excluded = 0;

        FilterResult() {
        }
    }
}

