/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.utils.filters;

import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.types.filters.CombinedMachineFilter;
import com.aem.shelp.tech.access.model.machine.MachineTreeModel;
import com.aem.shelp.tech.utils.filters.AdvancedFiltersUI;
import com.aem.shelp.tech.utils.filters.FilterChangeListener;
import com.aem.shelp.tech.utils.filters.MachineTestFiltersDialog;
import com.aem.shelp.tech.utils.filters.SimpleMachineFiltersUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import utils.swing.SwingUtil;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHButtonUI;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanel;

public class CombinedMachineFiltersUI
implements ActionListener {
    private final boolean showAllMachinesOption;
    private final FilterChangeListener filterChangeListener;
    private GbPanel rootComponent = new GbPanel();
    private JComboBox optionsBox;
    private SimpleMachineFiltersUI simpleUI;
    private AdvancedFiltersUI advancedUI;
    private JButton actionButton = new JButton(ImageLoader.getImageIcon((String)"images/svg/general/add.svg,16"));
    private JButton viewMachinesButton = new JButton();
    private MachineTreeModel model;
    private CombinedMachineFilter machineFilter;
    private boolean blockSaves = false;
    private JPanel rightButtonPanel;

    public CombinedMachineFiltersUI(FilterChangeListener listener, boolean showAllMachinesOption) {
        this.filterChangeListener = listener;
        this.showAllMachinesOption = showAllMachinesOption;
        try {
            this.blockSaves = true;
            this.initUI(listener);
        }
        finally {
            this.blockSaves = false;
        }
    }

    public GbPanel getRootComponent() {
        return this.rootComponent;
    }

    private void initUI(FilterChangeListener listener) {
        this.optionsBox = this.showAllMachinesOption ? new JComboBox<String>(new String[]{Language.get("ALL_MACHINES"), Language.get("MACHINE_FILTERS_SIMPLE"), Language.get("MACHINE_FILTERS_ADVANCED")}) : new JComboBox<String>(new String[]{Language.get("MACHINE_FILTERS_SIMPLE"), Language.get("MACHINE_FILTERS_ADVANCED")});
        this.optionsBox.addActionListener(this);
        this.simpleUI = new SimpleMachineFiltersUI(listener);
        this.advancedUI = new AdvancedFiltersUI(listener, true);
        this.rightButtonPanel = new JPanel(new BorderLayout());
        this.rightButtonPanel.add((Component)this.actionButton, "West");
        this.rightButtonPanel.add((Component)this.viewMachinesButton, "East");
        SHButtonUI.SegmentedButtonGroup.createSegmentedButtonGroup((AbstractButton)this.actionButton, (AbstractButton)this.viewMachinesButton);
        JPanel buttonsPanel = new JPanel(new BorderLayout(SimpleHelpLookAndFeel.scale((int)5), SimpleHelpLookAndFeel.scale((int)5)));
        buttonsPanel.setBorder(SHBorderFactory.createEmptyBorder((int)5, (int)0, (int)5, (int)0));
        buttonsPanel.add((Component)this.optionsBox, "West");
        buttonsPanel.add((Component)this.rightButtonPanel, "East");
        this.actionButton.addActionListener(this);
        this.viewMachinesButton.setText(Language.get("MACHINE_TEST_BUTTON"));
        this.viewMachinesButton.addActionListener(this);
        this.rootComponent.setLayout((LayoutManager)new BorderLayout());
        this.rootComponent.add((Component)this.simpleUI.getRootComponent(), (Object)"Center");
        this.rootComponent.add((Component)buttonsPanel, (Object)"North");
        this.updateSelection();
    }

    private void updateSelection() {
        if (this.showAllMachinesOption && this.optionsBox.getSelectedIndex() == 0) {
            if (this.machineFilter != null) {
                this.machineFilter.setType(0);
            }
            this.rootComponent.remove((Component)this.simpleUI.getRootComponent());
            this.rootComponent.remove(this.advancedUI.getRootComponent());
            this.rightButtonPanel.setVisible(false);
        } else if (this.showAllMachinesOption && this.optionsBox.getSelectedIndex() == 1 || !this.showAllMachinesOption && this.optionsBox.getSelectedIndex() == 0) {
            if (this.machineFilter != null) {
                this.machineFilter.setType(1);
            }
            this.rightButtonPanel.setVisible(true);
            this.actionButton.setText(Language.get("FILTER_PICK"));
            this.rootComponent.remove(this.advancedUI.getRootComponent());
            this.rootComponent.add((Component)this.simpleUI.getRootComponent());
        } else if (this.showAllMachinesOption && this.optionsBox.getSelectedIndex() == 2 || !this.showAllMachinesOption && this.optionsBox.getSelectedIndex() == 1) {
            if (this.machineFilter != null) {
                this.machineFilter.setType(2);
            }
            this.rightButtonPanel.setVisible(true);
            this.actionButton.setText(Language.get("FILTER_ADD"));
            this.rootComponent.remove((Component)this.simpleUI.getRootComponent());
            this.rootComponent.add(this.advancedUI.getRootComponent());
        }
        this.rootComponent.revalidate();
        this.rootComponent.repaint();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.actionButton) {
            if (this.isSimpleMachineFilter()) {
                this.simpleUI.showPicker();
            } else {
                this.advancedUI.addNewFilter();
            }
        } else if (e.getSource() == this.viewMachinesButton) {
            if (this.isSimpleMachineFilter()) {
                MachineTestFiltersDialog.showDialog(SwingUtil.getRootPaneContainer((Component)this.rootComponent), this.model, null, this.simpleUI.getFilter());
            } else {
                MachineTestFiltersDialog.showDialog(SwingUtil.getRootPaneContainer((Component)this.rootComponent), this.model, this.advancedUI.getFilters(), null);
            }
        } else {
            this.updateSelection();
            if (!this.blockSaves) {
                this.filterChangeListener.filterChanged();
            }
        }
    }

    public boolean isSimpleMachineFilter() {
        return this.showAllMachinesOption && this.optionsBox.getSelectedIndex() == 1 || !this.showAllMachinesOption && this.optionsBox.getSelectedIndex() == 0;
    }

    public void setDetailKeys(String[] result) {
        this.advancedUI.setDetailKeys(result);
    }

    public void setExistingFilters(CombinedMachineFilter machineFilter) {
        try {
            this.blockSaves = true;
            this.machineFilter = machineFilter;
            if (this.showAllMachinesOption) {
                if (machineFilter.showAllMachines()) {
                    this.optionsBox.setSelectedIndex(0);
                } else if (machineFilter.useSimpleFilter()) {
                    this.optionsBox.setSelectedIndex(1);
                } else {
                    this.optionsBox.setSelectedIndex(2);
                }
            } else if (machineFilter.useSimpleFilter() || machineFilter.showAllMachines()) {
                this.optionsBox.setSelectedIndex(0);
            } else {
                this.optionsBox.setSelectedIndex(1);
            }
            this.simpleUI.setExistingFilter(machineFilter.getSimpleMachineFilter());
            this.advancedUI.setExistingFilters(machineFilter.getAdvancedFilters());
            this.updateSelection();
        }
        finally {
            this.blockSaves = false;
        }
    }

    public void setMachineTreeModel(MachineTreeModel model) {
        this.model = model;
        this.simpleUI.setMachineTreeModel(model);
    }

    public void setEnabled(boolean enabled) {
        this.simpleUI.setEnabled(enabled);
        this.advancedUI.setEnabled(enabled);
    }

    public CombinedMachineFilter getMachineFilter() {
        this.machineFilter.setAdvancedFilters(this.advancedUI.getFilters());
        this.machineFilter.setSimpleMachineFilter(this.simpleUI.getFilter());
        return this.machineFilter;
    }
}

