/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.utils;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import javax.swing.Icon;
import utils.swing.MiniStatGraph;
import utils.swing.customlaf.SHButtonUI;
import utils.swing.customlaf.SimpleHelpLookAndFeel;

public class WifiIcon
implements Icon {
    int N = 2;
    double signal;

    @Override
    public int getIconHeight() {
        return SimpleHelpLookAndFeel.scale((int)16);
    }

    @Override
    public int getIconWidth() {
        return SimpleHelpLookAndFeel.scale((int)(this.N * 8));
    }

    public WifiIcon(double signal) {
        this.signal = signal;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2 = (Graphics2D)g;
        int w = this.getIconWidth();
        int h = this.getIconHeight();
        g2 = (Graphics2D)g2.create(x, y, w, h);
        g2.setColor(MiniStatGraph.RED[0]);
        g2.setStroke(SHButtonUI.getBorderStroke());
        g2.fillRect(0, 0, w, h);
        double good = this.signal * 0.01 * (double)this.getIconHeight();
        good = good % 1.0 > 0.4 ? Math.floor(good) + 1.0 : Math.floor(good);
        double greenStart = (double)this.getIconHeight() - good;
        double greenHeight = (double)this.getIconHeight() - greenStart;
        g2.setColor(MiniStatGraph.GREEN[0]);
        g2.fill(new Rectangle2D.Double(0.0, greenStart, w, greenHeight));
    }
}

