/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.utils;

import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.config.TransientTechGroup;
import com.aem.shelp.proxy.config.TransientTechUser;
import com.aem.shelp.proxy.techclient.TechClient;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.RootPaneContainer;
import javax.swing.UIManager;
import testing.classes.access.AccessPanelTester;
import utils.swing.SwingUtil;
import utils.swing.components.ColorPropagatingPanel;
import utils.swing.components.JSearchTextField;
import utils.swing.components.messagefields.MessageFieldHandler;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.SimpleHelpFrame;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.dialog.contents.FixedWidthComponent;
import utils.swing.dialog.contents.FixedWidthPanel;
import utils.swing.dialog.glassdialog.AbstractGlassDialog;
import utils.swing.dialog.panels.AbstractDialogPanel;
import utils.swing.dialog.panels.OKCancelDialogPanel;
import utils.swing.images.ImageLoader;
import utils.swing.simplelist.SimpleList;
import utils.swing.simplelist.jlist.SimpleListModel;
import utils.swing.simplelist.wrapper.SortWrapper;
import utils.swing.simplelist.wrapper.filter.FilterWrapper;

public class TechnicianPicker
extends OKCancelDialogPanel
implements MessageFieldHandler.FilterListener {
    private SimpleList<OptionWrapper> optionList;
    private JPanel rootComponent;
    private JList optionJList;
    private SimpleListModel<OptionWrapper> optionListModel;
    private JSearchTextField filterField;
    private FilterWrapper<OptionWrapper> optionWrapper;
    private boolean allTechniciansSelected = false;
    private static final TransientTechGroup ALL_TECHS = new TransientTechGroup(-1, Language.get("ALL_TECHNICIANS"));
    private boolean allowAllTechnicians = true;

    public TechnicianPicker(TechClient techClient, boolean notifyAll) {
        this(techClient, notifyAll, null, null);
    }

    public TechnicianPicker(TechClient techClient, int[] selectedTechIDs, int[] selectedGroupIDs) {
        this(techClient, false, selectedTechIDs, selectedGroupIDs);
    }

    private TechnicianPicker(TechClient techClient, boolean notifyAll, int[] selectedTechIDs, int[] selectedGroupIDs) {
        super(Language.get("CLOSE"));
        JPanel contentPanel = this.getContentPanel();
        contentPanel.setPreferredSize(SimpleHelpLookAndFeel.scale((Dimension)new Dimension(500, 300)));
        FixedWidthPanel panel = new FixedWidthPanel((JComponent)contentPanel);
        this.setContent((FixedWidthComponent)panel);
        this.allTechniciansSelected = notifyAll;
        new QueryServerForTechs(techClient, selectedTechIDs, selectedGroupIDs, notifyAll);
    }

    public void showDialog(RootPaneContainer rootPane) {
        AbstractGlassDialog abstractGlassDialog = new AbstractGlassDialog(rootPane, 500, (AbstractDialogPanel)this);
        abstractGlassDialog.setTitle(Language.get("TECHNICIAN_PICKER_TITLE"));
        abstractGlassDialog.showDialog();
    }

    public void setAllowAllTechnicians(boolean allowAllTechnicians) {
        this.allowAllTechnicians = allowAllTechnicians;
    }

    protected JPanel getContentPanel() {
        this.rootComponent = new JPanel(new BorderLayout(SimpleHelpLookAndFeel.scale((int)10), SimpleHelpLookAndFeel.scale((int)10)));
        this.rootComponent.setBackground(SHStyle.PANEL_BACKGROUND_WHITE);
        this.optionList = new SimpleList<OptionWrapper>(new TechGroupComparator());
        this.optionWrapper = new FilterWrapper(this.optionList){

            protected boolean isIncluded(Object object) {
                if (object instanceof LineOption) {
                    return true;
                }
                return super.isIncluded(object);
            }
        };
        this.optionJList = new JList();
        this.optionJList.setCellRenderer(new PickerListCellRenderer());
        this.optionJList.setSelectionMode(0);
        this.optionJList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                JList list = (JList)event.getSource();
                int index = list.locationToIndex(event.getPoint());
                if (index != -1) {
                    Object it = list.getModel().getElementAt(index);
                    OptionWrapper wrapper = (OptionWrapper)it;
                    if (wrapper instanceof GroupOption && ((GroupOption)wrapper).group == ALL_TECHS) {
                        boolean bl = wrapper.selected = !wrapper.selected;
                        if (wrapper.selected) {
                            TechnicianPicker.this.allTechniciansSelected = true;
                        } else {
                            TechnicianPicker.this.allTechniciansSelected = false;
                        }
                        list.repaint();
                    } else if (!TechnicianPicker.this.allTechniciansSelected) {
                        wrapper.selected = !wrapper.selected;
                        list.repaint(list.getCellBounds(index, index));
                    }
                }
            }
        });
        this.optionJList.setFixedCellHeight(SimpleHelpLookAndFeel.scale((int)26));
        this.optionListModel = new SimpleListModel<OptionWrapper>(this.optionWrapper);
        this.optionJList.setModel(this.optionListModel);
        this.filterField = new JSearchTextField(Language.get("SEARCH_TREE_TEXT"));
        this.filterField.addIcon(ImageLoader.getImageIcon((String)"images/svg/general/cancel.svg,16"), true, true, "CLEAR");
        this.filterField.addIcon(ImageLoader.getImageIcon((String)"images/svg/general/magnifying-glass.svg,16"), false, false, "SEARCH");
        this.filterField.setFilterListener(this);
        JPanel filterPanel = new JPanel(new GridLayout(1, 1));
        filterPanel.add(this.filterField);
        SwingUtil.setHeight((JComponent)this.filterField, (int)SimpleHelpLookAndFeel.scale((int)26));
        JScrollPane pane = new JScrollPane(this.optionJList);
        this.rootComponent.add((Component)filterPanel, "North");
        this.rootComponent.add((Component)pane, "Center");
        JPanel userPanel = new JPanel(new GridLayout(1, 1));
        userPanel.add(this.rootComponent);
        return userPanel;
    }

    public boolean notifyAllTechnicians() {
        for (OptionWrapper wrapper : this.optionList) {
            if (!(wrapper instanceof GroupOption)) continue;
            GroupOption go = (GroupOption)wrapper;
            if (go.group != ALL_TECHS || !go.selected) continue;
            return true;
        }
        return false;
    }

    public String[] getGroupNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (OptionWrapper wrapper : this.optionList) {
            if (!(wrapper instanceof GroupOption) || !wrapper.selected) continue;
            result.add(((GroupOption)wrapper).group.name);
        }
        return result.toArray(new String[0]);
    }

    public String[] getTechNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (OptionWrapper wrapper : this.optionList) {
            if (!(wrapper instanceof TechOption) || !wrapper.selected) continue;
            String displayName = ((TechOption)wrapper).techUser.displayName;
            String loginName = ((TechOption)wrapper).techUser.username;
            if (displayName == null || displayName.length() == 0) {
                result.add(loginName);
                continue;
            }
            result.add(displayName);
        }
        return result.toArray(new String[0]);
    }

    public int[] getChosenTechnicians() {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (OptionWrapper wrapper : this.optionList) {
            if (!(wrapper instanceof TechOption) || !wrapper.selected) continue;
            result.add(((TechOption)wrapper).techUser.uniqueID);
        }
        int[] resultArray = new int[result.size()];
        for (int i = 0; i < result.size(); ++i) {
            resultArray[i] = (Integer)result.get(i);
        }
        return resultArray;
    }

    public int[] getChosenGroups() {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (OptionWrapper wrapper : this.optionList) {
            if (!(wrapper instanceof GroupOption) || !wrapper.selected) continue;
            result.add(((GroupOption)wrapper).group.uniqueID);
        }
        int[] resultArray = new int[result.size()];
        for (int i = 0; i < result.size(); ++i) {
            resultArray[i] = (Integer)result.get(i);
        }
        return resultArray;
    }

    public void setFilter(String filter, boolean immediately) {
        this.optionWrapper.setCaseSensitive(false);
        this.optionWrapper.setFilterText(filter);
    }

    public static void main(String[] args) throws Exception {
        Language.loadTranslations();
        TechClient techClient = AccessPanelTester.getTechClient();
        SimpleHelpFrame frame = SimpleHelpFrame.getTestFrame();
        frame.setVisible(true);
        TechnicianPicker dialog = new TechnicianPicker(techClient, null, null);
        dialog.showDialog(SwingUtil.getRootPaneContainer((Component)frame));
        dialog = dialog.notifyAllTechnicians() ? new TechnicianPicker(techClient, true) : new TechnicianPicker(techClient, dialog.getChosenTechnicians(), dialog.getChosenGroups());
        dialog.showDialog(SwingUtil.getRootPaneContainer((Component)frame));
    }

    class GroupOption
    extends OptionWrapper {
        TransientTechGroup group;

        public GroupOption(TransientTechGroup group, boolean selected) {
            this.selected = selected;
            this.group = group;
        }

        public String toString() {
            return this.group.name;
        }
    }

    private class HorizontalLineLabel
    extends JLabel {
        private HorizontalLineLabel() {
        }

        @Override
        public void paintComponent(Graphics g) {
            int y = this.getHeight() / 2;
            g.setColor(SHStyle.LIGHT_GRAY_HORIZONTAL_LINE);
            g.drawLine(0, y, this.getWidth(), y);
        }
    }

    class LineOption
    extends OptionWrapper {
        LineOption() {
        }
    }

    class OptionWrapper {
        boolean selected;

        OptionWrapper() {
        }
    }

    class PickerListCellRenderer
    extends ColorPropagatingPanel
    implements ListCellRenderer {
        private JCheckBox box = new JCheckBox();
        private JLabel label = new JLabel();

        public PickerListCellRenderer() {
            this.initUI();
        }

        private void initUI() {
            this.setLayout(new BorderLayout());
            this.add(this.box, "West");
            this.add(this.label, "Center");
        }

        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            this.box.setEnabled(enabled);
            this.label.setEnabled(enabled);
        }

        /*
         * Enabled aggressive block sorting
         */
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (!(value instanceof GroupOption) || ((GroupOption)value).group != ALL_TECHS) {
                this.setEnabled(!TechnicianPicker.this.allTechniciansSelected && list.isEnabled());
            } else {
                this.setEnabled(list.isEnabled());
            }
            this.box.setSelected(this.isObjectSelected(value));
            this.setFont(list.getFont());
            if (isSelected) {
                this.setBackground(SHStyle.SELECTION_BACKGROUND);
                this.label.setForeground(UIManager.getColor("List.selectionForeground"));
            } else {
                this.setBackground(list.getBackground());
                this.label.setForeground(UIManager.getColor("List.foreground"));
            }
            if (value == null) {
                this.label.setIcon(null);
                return this;
            }
            if (value instanceof TechOption) {
                this.label.setIcon(ImageLoader.getImageIcon((String)"images/svg/users/technician.svg,16"));
                this.label.setText(((TechOption)value).techUser.displayName);
                return this;
            }
            if (value instanceof GroupOption) {
                this.label.setIcon(ImageLoader.getImageIcon((String)"images/svg/users/group.svg,16"));
                this.label.setText(((GroupOption)value).group.name);
                return this;
            }
            HorizontalLineLabel lineLabel = new HorizontalLineLabel();
            lineLabel.setSize(this.getSize());
            lineLabel.setPreferredSize(new Dimension(100, 2));
            return lineLabel;
        }

        public boolean isObjectSelected(Object it) {
            return ((OptionWrapper)it).selected;
        }
    }

    class QueryServerForTechs
    extends Thread {
        private TechClient techClient;
        private int[] selectedGroupIDs;
        private int[] selectedTechIDs;
        private boolean notifyAllTechnicins;

        public QueryServerForTechs(TechClient techClient, int[] selectedTechIDs, int[] selectedGroupIDs, boolean notifyAllTechnicins) {
            this.techClient = techClient;
            this.selectedTechIDs = selectedTechIDs;
            this.selectedGroupIDs = selectedGroupIDs;
            this.notifyAllTechnicins = notifyAllTechnicins;
            this.start();
        }

        private boolean isAlreadySelected(int id, int[] array) {
            if (array == null) {
                return false;
            }
            for (int i : array) {
                if (id != i) continue;
                return true;
            }
            return false;
        }

        @Override
        public void run() {
            boolean addLine = false;
            if (TechnicianPicker.this.allowAllTechnicians) {
                TechnicianPicker.this.optionList.add(new GroupOption(ALL_TECHS, this.notifyAllTechnicins));
                addLine = true;
            }
            try {
                TransientTechGroup[] groups = this.techClient.getVisibleGroups();
                Arrays.sort(groups, SortWrapper.LEXICAL_COMPARATOR_IGNORE_CASE);
                for (TransientTechGroup group : groups) {
                    if (addLine) {
                        TechnicianPicker.this.optionList.add(new LineOption());
                        addLine = false;
                    }
                    TechnicianPicker.this.optionList.add(new GroupOption(group, !this.notifyAllTechnicins && this.isAlreadySelected(group.uniqueID, this.selectedGroupIDs)));
                }
                if (groups.length > 0) {
                    addLine = true;
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            try {
                TransientTechUser[] technicians = this.techClient.getVisibleTechnicians();
                Arrays.sort(technicians, SortWrapper.LEXICAL_COMPARATOR_IGNORE_CASE);
                for (TransientTechUser user : technicians) {
                    if (addLine) {
                        TechnicianPicker.this.optionList.add(new LineOption());
                        addLine = false;
                    }
                    TechnicianPicker.this.optionList.add(new TechOption(user, !this.notifyAllTechnicins && this.isAlreadySelected(user.uniqueID, this.selectedTechIDs)));
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    class TechGroupComparator
    implements Comparator<OptionWrapper> {
        TechGroupComparator() {
        }

        @Override
        public int compare(OptionWrapper o1, OptionWrapper o2) {
            if (o1.getClass() == o2.getClass()) {
                return o1.toString().compareTo(o2.toString());
            }
            if (o1 instanceof GroupOption) {
                return 1;
            }
            return -1;
        }
    }

    class TechOption
    extends OptionWrapper {
        TransientTechUser techUser;

        public TechOption(TransientTechUser techUser, boolean selected) {
            this.selected = selected;
            this.techUser = techUser;
        }

        public String toString() {
            return this.techUser.displayName;
        }
    }
}

