/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.utils;

import com.aem.shelp.common.Language;
import com.aem.shelp.images.Icons;
import com.aem.shelp.proxy.types.Machine;
import com.aem.shelp.proxy.types.filters.SimpleMachineFilter;
import com.aem.shelp.tech.access.AccessStyle;
import com.aem.shelp.tech.access.model.machine.MachineGroup;
import com.aem.shelp.tech.access.model.machine.MachineTreeModel;
import com.aem.shelp.tech.hierarchy.model.AbstractTreeModel;
import com.aem.shelp.tech.hierarchy.model.TreeElement;
import com.aem.shelp.tech.utils.filters.SimpleMachineFilterTreeModel;
import com.aem.shelp.tech.utils.filters.simplemachinemodel.MachineGroupNode;
import com.aem.shelp.tech.utils.filters.simplemachinemodel.MachineNode;
import com.aem.shelp.tech.utils.filters.simplemachinemodel.SimpleMachineNode;
import com.aem.shelp.util.filter.FilterTreeModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.RootPaneContainer;
import javax.swing.border.Border;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import utils.swing.SwingUtil;
import utils.swing.components.JSearchTextField;
import utils.swing.components.SHJTree;
import utils.swing.components.messagefields.MessageFieldHandler;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHCheckBoxIcon;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.dialog.contents.FixedWidthComponent;
import utils.swing.dialog.contents.FixedWidthPanel;
import utils.swing.dialog.glassdialog.AbstractGlassDialog;
import utils.swing.dialog.panels.AbstractDialogPanel;
import utils.swing.dialog.panels.OKCancelDialogPanel;
import utils.swing.images.ImageLoader;

public class MachinePickerTree
implements MessageFieldHandler.FilterListener,
MouseListener {
    private final boolean threeState;
    private final boolean allowPicking;
    private AbstractTreeModel<MachineGroup, Machine> model;
    private FilterTreeModel filterModel;
    private SimpleMachineFilter machineStateFilter;
    private JPanel rootComponent;
    private JSearchTextField filterField;
    private SHJTree tree;
    private PickerRenderer renderer;
    private String[] filter;
    private boolean paintTicks = true;
    private boolean showMachines = true;

    public JPanel getRootComponent() {
        return this.rootComponent;
    }

    public MachinePickerTree(SimpleMachineFilter filter, boolean allowPicking, boolean threeState) {
        this.machineStateFilter = filter;
        this.threeState = threeState;
        this.allowPicking = allowPicking;
        this.initUI();
    }

    public void showMachines(boolean showMachines) {
        this.showMachines = showMachines;
    }

    public void setPaintTicks(boolean paintTicks) {
        this.paintTicks = paintTicks;
    }

    public void setMachineTreeModel(AbstractTreeModel<MachineGroup, Machine> model) {
        this.model = model;
        PrunedTreeModel prunedModel = new PrunedTreeModel(model, model.getAvailableMachinesGroup());
        this.filterModel = new FilterTreeModel(prunedModel);
        this.tree.setModel(this.filterModel);
    }

    public void setMachineTreeModel(TreeModel treeModel) {
        this.filterModel = new FilterTreeModel(treeModel);
        this.tree.setModel(this.filterModel);
        for (int i = 0; i < this.tree.getRowCount(); ++i) {
            this.tree.expandRow(i);
        }
    }

    private void initUI() {
        this.renderer = new PickerRenderer();
        this.tree = new SHJTree(SHStyle.SELECTION_BACKGROUND);
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        this.tree.setCellRenderer(this.renderer);
        JScrollPane pane = new JScrollPane(this.tree);
        this.rootComponent = new JPanel(new BorderLayout());
        this.rootComponent.add((Component)pane, "Center");
        pane.setPreferredSize(new Dimension(10, 10));
        if (this.allowPicking) {
            this.tree.addMouseListener(this);
            this.filterField = new JSearchTextField(Language.get("SEARCH_TREE_TEXT"));
            this.filterField.addIcon(ImageLoader.getImageIcon((String)"images/svg/general/cancel.svg,16"), true, true, "CLEAR");
            this.filterField.addIcon(ImageLoader.getImageIcon((String)"images/svg/general/magnifying-glass.svg,16"), false, false, "SEARCH");
            this.filterField.setFilterListener(this);
            JPanel filterPanel = new JPanel(new GridLayout(1, 1));
            filterPanel.setBorder(SHBorderFactory.createCompoundBorder((Border)SHBorderFactory.createMatteBorder((int)0, (int)0, (int)1, (int)0, (Color)SHStyle.BORDER_COLOR_LIGHT), (Border)SHBorderFactory.createEmptyBorder((int)5, (int)0, (int)5, (int)0)));
            filterPanel.add(this.filterField);
            SwingUtil.setHeight((JComponent)this.filterField, (int)SimpleHelpLookAndFeel.scale((int)25));
            this.rootComponent.add((Component)filterPanel, "North");
        }
    }

    public void setFilter(String filter, boolean immediately) {
        this.filter = filter == null ? null : filter.split("\\s");
        this.filterModel.setFilters(this.filter);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        int row = this.tree.getRowForLocation(e.getX(), e.getY());
        if (row == -1) {
            return;
        }
        TreePath path = this.tree.getPathForRow(row);
        Rectangle bounds = this.tree.getRowBounds(row);
        if (e.getX() > bounds.x && e.getX() < bounds.x + this.renderer.checkBoxIcon.getIconWidth()) {
            Object clickedObject = path.getLastPathComponent();
            Boolean currentState = clickedObject instanceof TreeElement ? this.machineStateFilter.getStateFor((TreeElement)clickedObject, false) : this.machineStateFilter.getStateFor((MachineGroup)clickedObject, false);
            currentState = this.threeState ? (currentState == null ? Boolean.TRUE : (currentState == Boolean.TRUE ? Boolean.FALSE : null)) : (currentState == null ? Boolean.TRUE : null);
            if (clickedObject instanceof TreeElement) {
                this.machineStateFilter.set((TreeElement)clickedObject, currentState);
            } else {
                this.machineStateFilter.set((MachineGroup)clickedObject, currentState);
            }
            this.tree.repaint(this.tree.getRowBounds(row));
            e.consume();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    public boolean containsIncludes() {
        return this.machineStateFilter.containsAnyIncludes();
    }

    public void showInDialog(RootPaneContainer rootPaneContainer) {
        this.setFilter(null, true);
        new MachinePickerDialog(false).showDialog(rootPaneContainer);
    }

    public String[] getSelectedGroup() {
        Object lastcomponent = this.tree.getLastSelectedPathComponent();
        if (lastcomponent == null) {
            return null;
        }
        if (lastcomponent instanceof MachineGroup) {
            return SimpleMachineFilter.getPathToRootFor((MachineGroup)lastcomponent);
        }
        return null;
    }

    public static void createTestDialog(RootPaneContainer rpc, boolean threeState) throws IOException {
        MachineTreeModel model = new MachineTreeModel();
        ArrayList<Machine> machines = new ArrayList<Machine>();
        for (int i = 0; i < 10000; ++i) {
            machines.add(Machine.createTestMachine());
        }
        model.addElements(machines.toArray(new Machine[0]));
        MachinePickerTree tree = new MachinePickerTree(new SimpleMachineFilter(), true, threeState);
        tree.setMachineTreeModel(model);
        MachinePickerTree machinePickerTree = tree;
        machinePickerTree.getClass();
        MachinePickerDialog mpd = machinePickerTree.new MachinePickerDialog(false);
        mpd.showDialog(rpc);
        SimpleMachineFilter filter = tree.machineStateFilter;
        SimpleMachineFilterTreeModel smpm = new SimpleMachineFilterTreeModel(filter, model);
        tree = new MachinePickerTree(filter, false, true);
        tree.setMachineTreeModel(smpm);
        MachinePickerTree machinePickerTree2 = tree;
        machinePickerTree2.getClass();
        mpd = machinePickerTree2.new MachinePickerDialog(false);
        mpd.showDialog(rpc);
    }

    public class MachinePickerDialog
    extends OKCancelDialogPanel {
        public MachinePickerDialog(boolean allowCancel) {
            super(allowCancel ? Language.get("SELECT") : Language.get("CLOSE"), allowCancel ? Language.get("CANCEL") : null);
            JPanel contentPanel = this.getContentPanel();
            contentPanel.setPreferredSize(SimpleHelpLookAndFeel.scale((Dimension)new Dimension(500, 400)));
            FixedWidthPanel panel = new FixedWidthPanel((JComponent)contentPanel);
            this.setContent((FixedWidthComponent)panel);
        }

        protected JPanel getContentPanel() {
            JPanel userPanel = new JPanel(new GridLayout(1, 1));
            userPanel.add(MachinePickerTree.this.rootComponent);
            return userPanel;
        }

        public void showDialog(RootPaneContainer rpc) {
            AbstractGlassDialog abstractGlassDialog = new AbstractGlassDialog(rpc, 500, (AbstractDialogPanel)this);
            abstractGlassDialog.setTitle(Language.get("ACP_PICK_MACHINES"));
            abstractGlassDialog.showDialog();
        }
    }

    class PickerRenderer
    extends DefaultTreeCellRenderer {
        private Icon groupIcon = ImageLoader.getImageIcon((String)"images/svg/general/machine-group.svg,16");
        private Icon machineIcon = ImageLoader.getImageIcon((String)"images/svg/technology/screen.svg,16");
        private Icon threeStateIcon;
        private JCheckBox dummyBox = new JCheckBox();
        private SHCheckBoxIcon checkBoxIcon = new SHCheckBoxIcon();
        private int buffer = SimpleHelpLookAndFeel.scale((int)25);
        private boolean selected = false;

        public PickerRenderer() {
            this.setBackgroundSelectionColor(null);
            this.setBorderSelectionColor(null);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            JLabel component = (JLabel)super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (value instanceof MachineGroup || value instanceof MachineGroupNode) {
                component.setIcon(this.groupIcon);
            } else {
                if (value instanceof Machine) {
                    component.setText(((Machine)value).getMachineName().getName());
                } else if (value instanceof MachineNode) {
                    component.setText(((MachineNode)value).machineName);
                }
                component.setIcon(this.machineIcon);
            }
            this.selected = sel;
            if (value instanceof Machine || value instanceof MachineGroup) {
                Boolean state = value instanceof Machine ? MachinePickerTree.this.machineStateFilter.getStateFor((Machine)value, false) : MachinePickerTree.this.machineStateFilter.getStateFor((MachineGroup)value, false);
                if (MachinePickerTree.this.threeState) {
                    if (MachinePickerTree.this.allowPicking) {
                        if (state == null) {
                            this.threeStateIcon = ImageLoader.getImageIcon((String)Icons.MACHINE_NONE);
                        } else if (state == Boolean.TRUE) {
                            this.threeStateIcon = ImageLoader.getImageIcon((String)"images/svg/general/ok.svg,16");
                        } else if (state == Boolean.FALSE) {
                            this.threeStateIcon = ImageLoader.getImageIcon((String)"images/svg/general/accessdenied.svg,16");
                        }
                    }
                } else {
                    this.dummyBox.setSelected(state != null);
                }
            } else if (value instanceof SimpleMachineNode) {
                SimpleMachineNode mgn = (SimpleMachineNode)value;
                this.threeStateIcon = mgn.getState() == Boolean.TRUE ? ImageLoader.getImageIcon((String)"images/svg/general/ok.svg,16") : (mgn.getState() == Boolean.FALSE ? ImageLoader.getImageIcon((String)"images/svg/general/accessdenied.svg,16") : null);
            }
            return component;
        }

        @Override
        public void paintComponent(Graphics g) {
            if (!MachinePickerTree.this.paintTicks) {
                super.paintComponent(g);
                return;
            }
            int y = (this.getHeight() - this.checkBoxIcon.getIconHeight()) / 2;
            g.translate(this.buffer, 0);
            super.paintComponent(g);
            g.translate(-this.buffer, 0);
            if (MachinePickerTree.this.threeState) {
                if (this.threeStateIcon != null) {
                    this.threeStateIcon.paintIcon(null, g, 0, y);
                }
            } else {
                this.checkBoxIcon.paintIcon((Component)this.dummyBox, g, 0, y);
            }
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (this.selected) {
                g2d.setColor(Color.WHITE);
            } else {
                g2d.setColor(AccessStyle.TREE_SELECTION_COLOR);
            }
        }
    }

    class PrunedTreeModel
    implements TreeModel {
        private final MachineGroup prunedRoot;
        private AbstractTreeModel<MachineGroup, Machine> delegate;

        public PrunedTreeModel(AbstractTreeModel<MachineGroup, Machine> model, MachineGroup prunedRoot) {
            this.delegate = model;
            this.prunedRoot = prunedRoot;
        }

        @Override
        public Object getRoot() {
            return this.prunedRoot;
        }

        @Override
        public Object getChild(Object parent, int index) {
            if (parent instanceof MachineGroup) {
                MachineGroup machineGroup = (MachineGroup)parent;
                MachineGroup[] childGroups = (MachineGroup[])this.delegate.getGroupsIn(machineGroup);
                if (index < childGroups.length) {
                    return childGroups[index];
                }
                return machineGroup.getElements().get(index -= childGroups.length);
            }
            return null;
        }

        @Override
        public int getChildCount(Object parent) {
            if (parent instanceof MachineGroup) {
                MachineGroup machineGroup = (MachineGroup)parent;
                MachineGroup[] childGroups = (MachineGroup[])this.delegate.getGroupsIn(machineGroup);
                if (MachinePickerTree.this.showMachines) {
                    return childGroups.length + machineGroup.getElementCount();
                }
                return childGroups.length;
            }
            return 0;
        }

        @Override
        public boolean isLeaf(Object node) {
            return this.getChildCount(node) == 0;
        }

        @Override
        public void valueForPathChanged(TreePath path, Object newValue) {
        }

        @Override
        public int getIndexOfChild(Object parent, Object child) {
            if (parent instanceof MachineGroup) {
                MachineGroup machineGroup = (MachineGroup)parent;
                if (child instanceof MachineGroup) {
                    MachineGroup childGroup = (MachineGroup)child;
                    return this.delegate.getIndexOf(childGroup);
                }
                return this.delegate.getChildGroupCount(machineGroup) + machineGroup.getElements().indexOf(child);
            }
            return -1;
        }

        @Override
        public void addTreeModelListener(TreeModelListener l) {
        }

        @Override
        public void removeTreeModelListener(TreeModelListener l) {
        }
    }
}

