/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.toolbox;

import com.aem.shelp.common.Language;
import java.awt.Component;
import java.awt.GridLayout;
import java.io.IOException;
import java.util.Hashtable;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.SimpleHelpFrame;

public class ToolBoxRunnerSlider
implements ChangeListener {
    public static final int FACTOR = 10;
    private JPanel rootComponent = new JPanel();
    private JSlider slider = new JSlider();
    private JLabel summaryLabel = new JLabel();
    private JLabel titleLabel = new JLabel();
    private int machineCount;

    public JPanel getRootComponent() {
        return this.rootComponent;
    }

    public ToolBoxRunnerSlider(int machineCount) {
        this.machineCount = machineCount;
        this.initUI();
    }

    private int getTickCount() {
        int count = this.machineCount / 10;
        if (this.machineCount % 10 > 0) {
            ++count;
        }
        return Math.min(10, count);
    }

    private void initUI() {
        this.rootComponent.setLayout(new GridLayout(3, 1));
        this.rootComponent.add((Component)this.titleLabel, "North");
        this.rootComponent.add((Component)this.slider, "North");
        this.rootComponent.add((Component)this.summaryLabel, "South");
        this.titleLabel.setFont(SHStyle.mediumFont);
        int tickCount = this.getTickCount();
        this.slider.setMinimum(10);
        this.slider.setMaximum(tickCount * 10);
        this.slider.setSnapToTicks(true);
        this.slider.setValue(this.slider.getMinimum());
        this.slider.addChangeListener(this);
        this.slider.setPaintLabels(true);
        this.slider.setMajorTickSpacing(10);
        if (tickCount <= 1) {
            this.rootComponent.setVisible(false);
        } else {
            Hashtable<Integer, JComponent> createStandardLabels = this.slider.createStandardLabels(10, 10);
            ((JLabel)createStandardLabels.get(new Integer(this.slider.getMaximum()))).setText(Language.get("ALL"));
            this.slider.setLabelTable(createStandardLabels);
            this.slider.setFont(SHStyle.smallFont);
            this.summaryLabel.setHorizontalAlignment(0);
            this.titleLabel.setHorizontalAlignment(0);
            this.titleLabel.setText(Language.get("TOOLBOX_RUNNER_SLIDER_TITLE"));
            this.updateLabel();
        }
    }

    public int getSessionsToUse() {
        return this.slider.getValue() / 10;
    }

    private void updateLabel() {
        String s = Language.get("TOOLBOX_WILL_USE");
        int value = this.slider.getValue() / 10;
        s = s + " " + value + " ";
        s = value == 1 ? s + Language.get("SESSION") : s + Language.get("SESSIONS");
        this.summaryLabel.setText(s);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.updateLabel();
    }

    public static void main(String[] args) throws IOException {
        Language.loadTranslations();
        SimpleHelpFrame frame = SimpleHelpFrame.getTestFrame();
        ToolBoxRunnerSlider slider = new ToolBoxRunnerSlider(500);
        frame.getContentPane().add(slider.getRootComponent());
        frame.setVisible(true);
    }
}

