/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.toolbox;

import com.aem.shelp.common.toolbox.ToolBoxItem;
import com.aem.shelp.common.toolbox.ToolBoxResult;
import com.aem.shelp.common.toolbox.ToolBoxStatus;
import com.aem.shelp.tech.hierarchy.model.TreeNodeFilterProcessor;

public class ToolBoxResultWrapper {
    private final ServerRunIDProvider serverRunIDProvider;
    private final long internalRunID;
    private final TreeNodeFilterProcessor filterProcessor;
    public byte statusCode;
    public StringBuffer stdout = new StringBuffer();
    public StringBuffer stderr = new StringBuffer();
    public String launchError;
    public int returnCode;
    public ToolBoxItem tool;

    public ToolBoxResultWrapper(long internalRunID, ServerRunIDProvider serverRunIDProvider, TreeNodeFilterProcessor filterProcessor) {
        this.internalRunID = internalRunID;
        this.serverRunIDProvider = serverRunIDProvider;
        this.filterProcessor = filterProcessor;
    }

    public long getServerRunID() {
        return this.serverRunIDProvider.getServerSideRunID();
    }

    public long getInternalRunID() {
        return this.internalRunID;
    }

    public String toString() {
        return "ToolBoxStatus Status:" + this.statusCode + " Error:" + this.launchError + " Return:" + this.returnCode + " Std:" + this.stdout.length() + "/" + this.stderr.length();
    }

    public boolean equals(Object o) {
        if (o instanceof ToolBoxResultWrapper) {
            return ((ToolBoxResultWrapper)o).getInternalRunID() == this.getInternalRunID();
        }
        return false;
    }

    public void updateStatus(ToolBoxStatus status) {
        if (status.statusCode > this.statusCode) {
            this.statusCode = status.statusCode;
        }
        if (status.stdout != null) {
            this.stdout.append(status.stdout);
        }
        if (status.stderr != null) {
            this.stderr.append(status.stderr);
        }
        if (status.error != null) {
            this.launchError = status.error;
        }
    }

    public void updateStatus(ToolBoxResult result) {
        this.returnCode = result.returnCode;
        if (result.stdout != null) {
            this.stdout.append(result.stdout);
        }
        if (result.stderr != null) {
            this.stderr.append(result.stderr);
        }
        if (result.preLaunchError != null) {
            this.launchError = result.preLaunchError;
        }
    }

    public TreeNodeFilterProcessor getFilterProcessor() {
        return this.filterProcessor;
    }

    public static interface ServerRunIDProvider {
        public long getServerSideRunID();
    }
}

