/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.software;

import com.aem.shelp.common.Language;
import com.aem.shelp.tech.access.AccessPanelListener;
import com.aem.shelp.tech.software.AbstractSoftwareTable;
import com.aem.shelp.tech.software.AbstractSoftwareTableCellRenderer;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import utils.software.windows.WindowsSoftware;
import utils.software.windows.WindowsUpdate;
import utils.swing.simplelist.jtable.TableStructure;

public class WindowsUpdatesTable
extends AbstractSoftwareTable<WindowsUpdate> {
    public WindowsUpdatesTable(AccessPanelListener accessPanelListener) {
        super(accessPanelListener);
    }

    @Override
    protected TableCellRenderer createTableRenderer() {
        return new SoftwareRenderer();
    }

    @Override
    protected TableStructure getTableStructure() {
        return TableStructure.createTableStructure(WindowsUpdate.class, new String[]{"id", "name", "updateVersion", "isRecommended", "restartRequired", "severity", "description", "rebootBehaviour"}, new String[]{Language.get("SOFTWARE_UPDATE_ID"), Language.get("SOFTWARE_APP_NAME"), Language.get("SOFTWARE_APP_VERSION"), Language.get("SOFTWARE_UPDATE_RECOMMENDED"), Language.get("SOFTWARE_UPDATE_RESTART"), Language.get("SOFTWARE_UPDATE_SEVERITY"), Language.get("SOFTWARE_UPDATE_REBOOT"), Language.get("SOFTWARE_APP_DESCRIPTION")});
    }

    public void load(WindowsSoftware software) {
        ArrayList applications = software.getUpdatesArray();
        this.list.startBatch();
        try {
            this.list.setListContents(applications);
        }
        finally {
            this.list.endBatch();
        }
    }

    public class SoftwareRenderer
    extends AbstractSoftwareTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (column == 3) {
                boolean recommended = (Boolean)value;
                if (recommended) {
                    label.setText(Language.get("YES"));
                } else {
                    label.setText("");
                }
            } else if (column == 4) {
                boolean restartRequired = (Boolean)value;
                if (restartRequired) {
                    label.setText(Language.get("YES"));
                } else {
                    label.setText("");
                }
            } else if (column == 7) {
                int reboot = (Integer)value;
                if (reboot == 1) {
                    label.setText(Language.get("REQUIRED"));
                } else if (reboot == 0) {
                    label.setText(Language.get("NO"));
                } else {
                    label.setText(Language.get("POSSIBLY"));
                }
            } else if (column == 5) {
                // empty if block
            }
            return label;
        }
    }
}

