/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.software;

import com.aem.sdesktop.client.gui.diag.StringRowFilter;
import com.aem.shelp.proxy.techclient.TechClient;
import com.aem.shelp.tech.access.AccessPanelListener;
import com.aem.shelp.util.EasyDateTimeFormatter;
import java.util.ArrayList;
import java.util.Comparator;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import utils.swing.components.SHJTable;
import utils.swing.components.scrollpane.LockableViewPort;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.renderers.BorderedTableCellRendererWrapper;
import utils.swing.simplelist.SimpleList;
import utils.swing.simplelist.jtable.SimpleTableModel;
import utils.swing.simplelist.jtable.TableStructure;

public abstract class AbstractSoftwareTable<T> {
    private final AccessPanelListener accessPanelListener;
    private JScrollPane pane;
    private LockableViewPort viewPort;
    private TechClient techClient;
    protected SimpleList<T> list = new SimpleList();
    private SHJTable table;
    private SimpleTableModel model;
    private TableRowSorter<TableModel> tableRowSorter;
    private StringRowFilter tableRowFilter;
    private TableCellRenderer renderer;
    protected EasyDateTimeFormatter dateFormatter = new EasyDateTimeFormatter();

    public AbstractSoftwareTable(AccessPanelListener accessPanelListener) {
        this.accessPanelListener = accessPanelListener;
        this.initUI();
    }

    public JScrollPane getRootComponent() {
        return this.pane;
    }

    private void initUI() {
        this.pane = new JScrollPane();
        this.viewPort = new LockableViewPort();
        this.pane.setViewport(this.viewPort);
        this.pane.setHorizontalScrollBarPolicy(31);
        this.pane.setBorder(SHBorderFactory.createEmptyBorder());
        TableStructure ts = this.getTableStructure();
        this.model = new SimpleTableModel(this.list, ts);
        this.table = new SHJTable(this.model);
        this.table.setRowHeight(SimpleHelpLookAndFeel.scale((int)26));
        this.tableRowFilter = new StringRowFilter();
        this.tableRowSorter = new TableRowSorter<SimpleTableModel>(this.model);
        this.tableRowSorter.setSortsOnUpdates(true);
        this.tableRowSorter.setRowFilter(this.tableRowFilter);
        this.table.setRowSorter(this.tableRowSorter);
        SoftwareSorter serviceSorter = new SoftwareSorter();
        for (int i = 0; i < this.table.getColumnModel().getColumnCount(); ++i) {
            this.tableRowSorter.setComparator(i, serviceSorter);
        }
        ArrayList<RowSorter.SortKey> sortKeys = new ArrayList<RowSorter.SortKey>();
        sortKeys.add(new RowSorter.SortKey(0, SortOrder.ASCENDING));
        this.tableRowSorter.setSortKeys(sortKeys);
        this.renderer = new BorderedTableCellRendererWrapper(this.createTableRenderer(), BorderFactory.createEmptyBorder(0, 3, 0, 3));
        this.table.setDefaultRenderer(Object.class, this.renderer);
        this.table.setDefaultRenderer(Long.class, this.renderer);
        this.table.setDefaultRenderer(Boolean.class, this.renderer);
        this.table.setDefaultRenderer(Byte.class, this.renderer);
        this.table.setDefaultRenderer(Integer.class, this.renderer);
        ts.initTableDimensions(this.table);
        this.viewPort.setView(this.table);
    }

    protected abstract TableCellRenderer createTableRenderer();

    protected abstract TableStructure getTableStructure();

    public void setTechClient(TechClient techClient) {
        this.techClient = techClient;
    }

    class SoftwareSorter
    implements Comparator<Object> {
        SoftwareSorter() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            if (o1 instanceof String && o2 instanceof String) {
                return ((String)o1).compareTo((String)o2);
            }
            return o1.toString().compareTo(o2.toString());
        }
    }
}

