/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.portforward;

import com.aem.shelp.common.GenericVariableUtil;
import com.aem.shelp.common.Language;
import com.aem.shelp.common.properties.TechProperties;
import com.aem.shelp.proxy.LicenseSet;
import com.aem.shelp.proxy.techclient.TechClient;
import com.aem.shelp.proxy.techclient.TechClientIPCHandler;
import com.aem.shelp.proxy.types.AccessSession;
import com.aem.shelp.proxy.types.Machine;
import com.aem.shelp.proxy.types.apptunnel.AppTunnelSpecification;
import com.aem.shelp.proxy.types.apptunnel.AppTunnelTarget;
import com.aem.shelp.tech.access.AccessPanelListener;
import com.aem.shelp.tech.gstarted.TrialUtils;
import com.aem.shelp.tech.portforward.AppTunnelItem;
import com.aem.shelp.tech.portforward.AppTunnelUIRepository;
import com.aem.shelp.tech.portforward.CommonTCPPorts;
import com.aem.shelp.tech.portforward.NewServicePanel;
import com.aem.shelp.tech.utils.SHStrippedContentPanel;
import com.aem.shelp.util.RemoteMachinePasswordDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import utils.message.Message;
import utils.message.MessageUtils;
import utils.progtools.OnDemandThreadPool;
import utils.progtools.ProcessPrinter;
import utils.string.Base64;
import utils.swing.SwingUtil;
import utils.swing.components.StrippedContentPanel;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.ScaledFlowLayout;
import utils.swing.customlaf.SimpleHelpFrame;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanel;

public class AppTunnelUI
implements ActionListener,
Runnable {
    private final AccessPanelListener accessPanelListener;
    private JPanel rootComponent = new JPanel(new BorderLayout());
    private JPanel titleBar = new JPanel(new BorderLayout(SimpleHelpLookAndFeel.scale((int)5), SimpleHelpLookAndFeel.scale((int)5)));
    private JButton newPortForwardConfig = new JButton(Language.get("PF_NEW"), ImageLoader.getImageIcon((String)"images/svg/general/add.svg,16"));
    private GbPanel techPortForwardListPanel = new GbPanel();
    private StrippedContentPanel techPortForwardList = new SHStrippedContentPanel(this.techPortForwardListPanel, false);
    private GbPanel pinnedPortForwardListPanel = new GbPanel();
    private StrippedContentPanel pinnedPortForwardList = new SHStrippedContentPanel(this.pinnedPortForwardListPanel, false);
    private ArrayList<AppTunnelSpecification> currentTechSpecifications = new ArrayList();
    private ArrayList<AppTunnelSpecification> currentPinnedSpecifications = new ArrayList();
    private final ArrayList<AppTunnelItem> currentAppTunnelItems = new ArrayList();
    private Machine machine;
    private JLabel titleLabel = new JLabel(Language.get("PF_TITLE"));
    private JLabel desc = new JLabel(Language.get("PF_DESC"));
    private JLabel pinnedTitle;
    private JScrollPane scroller;
    private OnDemandThreadPool specificationFetcherPool = new OnDemandThreadPool("AppTunnelFetcher", 5, 5, 5);
    private OnDemandThreadPool specificationSaver = new OnDemandThreadPool("AppTunnelSaver", 5, 5, 5);

    public AppTunnelUI(AccessPanelListener accessPanelListener) {
        this.accessPanelListener = accessPanelListener;
        this.specificationFetcherPool.setDumpOldJobsOnBufferMaxed(true);
        this.initUI();
    }

    private void initUI() {
        this.rootComponent.add((Component)this.titleBar, "North");
        GbPanel mainContent = new GbPanel();
        this.pinnedTitle = new JLabel(Language.get("PF_PINNED_TITLE"));
        this.pinnedTitle.setFont(SHStyle.largeFont);
        this.pinnedTitle.setBorder(SHBorderFactory.createEmptyBorder((int)20, (int)5, (int)5, (int)0));
        JPanel footer = new JPanel();
        mainContent.add((Component)this.techPortForwardListPanel, 0, 0, 1, 1, 1, 0, 10, 1);
        mainContent.add((Component)this.pinnedTitle, 0, 1, 1, 1, 1, 0, 10, 1);
        mainContent.add((Component)this.pinnedPortForwardListPanel, 0, 2, 1, 1, 1, 0, 10, 1);
        mainContent.add((Component)footer, 0, 3, 1, 1, 1, 1, 10, 1);
        this.rootComponent.add((Component)mainContent, "Center");
        this.titleLabel.setFont(SHStyle.largeFont);
        this.newPortForwardConfig.addActionListener(this);
        this.scroller = new JScrollPane(this.rootComponent){

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        this.scroller.setBorder(SHBorderFactory.createEmptyBorder());
    }

    private void setHasContents(final boolean hasContents) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AppTunnelUI.this.titleBar.removeAll();
                JPanel buttons = new JPanel((LayoutManager)new ScaledFlowLayout());
                buttons.add(AppTunnelUI.this.newPortForwardConfig);
                if (!hasContents) {
                    AppTunnelUI.this.titleBar.setBorder(SHBorderFactory.createEmptyBorder((int)10, (int)5, (int)0, (int)0));
                    AppTunnelUI.this.titleBar.add((Component)AppTunnelUI.this.titleLabel, "North");
                    AppTunnelUI.this.titleBar.add((Component)AppTunnelUI.this.desc, "Center");
                    AppTunnelUI.this.titleBar.add((Component)buttons, "South");
                } else {
                    AppTunnelUI.this.titleBar.setBorder(SHBorderFactory.createEmptyBorder((int)5, (int)5, (int)5, (int)0));
                    AppTunnelUI.this.titleBar.add((Component)AppTunnelUI.this.titleLabel, "Center");
                    AppTunnelUI.this.titleBar.add((Component)buttons, "East");
                }
                AppTunnelUI.this.titleBar.revalidate();
                AppTunnelUI.this.titleBar.repaint();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initWith(ArrayList<AppTunnelSpecification> techSpecifications, ArrayList<AppTunnelSpecification> pinnedSpecifications) {
        this.setHasContents(techSpecifications.size() > 0 || pinnedSpecifications.size() > 0);
        boolean havePinned = pinnedSpecifications.size() > 0;
        this.pinnedTitle.setVisible(havePinned);
        this.pinnedPortForwardListPanel.setVisible(havePinned);
        this.currentPinnedSpecifications = new ArrayList<AppTunnelSpecification>(pinnedSpecifications);
        this.currentTechSpecifications = new ArrayList<AppTunnelSpecification>(techSpecifications);
        this.techPortForwardListPanel.removeAll();
        this.pinnedPortForwardListPanel.removeAll();
        AppTunnelMessageListener[] allListeners = AppTunnelUIRepository.INSTANCE.getAllListenersFor(this.machine.getMachineID());
        ArrayList<AppTunnelItem> arrayList = this.currentAppTunnelItems;
        synchronized (arrayList) {
            AppTunnelItem item;
            this.currentAppTunnelItems.clear();
            for (AppTunnelSpecification spec : techSpecifications) {
                item = new AppTunnelItem(this, spec, allListeners);
                this.currentAppTunnelItems.add(item);
                this.techPortForwardList.addContent((JComponent)item.getRootComponent(), null);
            }
            for (AppTunnelSpecification spec : pinnedSpecifications) {
                item = new AppTunnelItem(this, spec, allListeners);
                this.currentAppTunnelItems.add(item);
                this.pinnedPortForwardList.addContent((JComponent)item.getRootComponent(), null);
            }
        }
        this.techPortForwardList.addVerticalFiller();
        this.techPortForwardList.setBackgroundColours(true);
        this.pinnedPortForwardList.addVerticalFiller();
        this.pinnedPortForwardList.setBackgroundColours(true);
        this.techPortForwardListPanel.revalidate();
        this.techPortForwardListPanel.repaint();
        this.pinnedPortForwardListPanel.revalidate();
        this.pinnedPortForwardListPanel.repaint();
    }

    public void deleteSpecification(AppTunnelSpecification specification) {
        this.currentPinnedSpecifications.remove(specification);
        this.currentTechSpecifications.remove(specification);
        this.initWith(this.currentTechSpecifications, this.currentPinnedSpecifications);
    }

    public void addSpecification(AppTunnelSpecification specification) {
        this.currentTechSpecifications.add(specification);
        this.initWith(this.currentTechSpecifications, this.currentPinnedSpecifications);
    }

    public void setSpecificationPinned(AppTunnelSpecification spec) {
        boolean pinned = spec.isPinned();
        if (pinned) {
            if (this.currentTechSpecifications.remove(spec)) {
                this.currentPinnedSpecifications.add(spec);
            }
        } else if (this.currentPinnedSpecifications.remove(spec)) {
            this.currentTechSpecifications.add(spec);
        }
        this.initWith(this.currentTechSpecifications, this.currentPinnedSpecifications);
    }

    public static void main(String[] args) throws IOException, InterruptedException {
        Language.loadTranslations();
        SimpleHelpFrame frame = SimpleHelpFrame.getTestFrame();
        AppTunnelUI appTunnelUI = new AppTunnelUI(null);
        appTunnelUI.machine = Machine.createTestMachine();
        frame.getContentPane().add(appTunnelUI.getRootComponent());
        ArrayList<AppTunnelSpecification> specs = new ArrayList<AppTunnelSpecification>();
        specs.add(AppTunnelSpecification.createTestSpec());
        specs.add(AppTunnelSpecification.createTestSpec());
        specs.add(AppTunnelSpecification.createTestSpec());
        appTunnelUI.initWith(specs, new ArrayList<AppTunnelSpecification>());
        frame.setVisible(true);
        for (int i = 0; i < 3; ++i) {
            Thread.sleep(1000L);
            AppTunnelUI appTunnelUI2 = appTunnelUI;
            appTunnelUI2.getClass();
            AppTunnelMessageListener newSession = appTunnelUI2.new AppTunnelMessageListener(appTunnelUI.machine, specs.get(0).getTargets().get(0));
            newSession.newMessage("WOOT " + i);
        }
        AppTunnelUI appTunnelUI3 = appTunnelUI;
        appTunnelUI3.getClass();
        AppTunnelMessageListener newSession = appTunnelUI3.new AppTunnelMessageListener(appTunnelUI.machine, specs.get(0).getTargets().get(0));
        Thread.sleep(1000L);
        newSession.sessionConnected();
        Thread.sleep(1000L);
        newSession.setLocalPort(12345);
    }

    public JComponent getRootComponent() {
        return this.scroller;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.newPortForwardConfig) {
            boolean allowed = false;
            LicenseSet licenseSet = this.accessPanelListener.getTechClient().getServerLicenses();
            if (TrialUtils.amTriallingBizOrEnt()) {
                allowed = true;
            } else if (licenseSet != null && licenseSet.allowsTunnels()) {
                allowed = true;
            }
            if (!allowed) {
                TrialUtils.appConnectionsDisallowedPopup(SwingUtil.getRootPaneContainer((Component)this.rootComponent), this.rootComponent, this.accessPanelListener.getTechClient());
            } else {
                NewServicePanel newServicePanel = new NewServicePanel(SwingUtil.getRootPaneContainer((Component)this.rootComponent));
                if (newServicePanel.isOK()) {
                    CommonTCPPorts.TCPPort newService = newServicePanel.getSelectedPort();
                    int techID = 0;
                    if (this.accessPanelListener != null) {
                        techID = this.accessPanelListener.getTechClient().getTechUser().uniqueID;
                    }
                    AppTunnelSpecification spec = new AppTunnelSpecification(techID, newService.name, newService.port);
                    AppTunnelTarget defaultTarget = new AppTunnelTarget(spec, "localhost");
                    spec.addTarget(defaultTarget);
                    this.addSpecification(spec);
                    this.save(spec);
                }
            }
        }
    }

    public void save(AppTunnelSpecification specThatRequestedSave) {
        boolean specChangedPinnedState = specThatRequestedSave.pinnedStateChanged;
        if (specThatRequestedSave.pinnedStateChanged) {
            this.setSpecificationPinned(specThatRequestedSave);
            specThatRequestedSave.pinnedStateChanged = false;
        }
        if (specThatRequestedSave.isPinned()) {
            this.specificationSaver.runAsync((Runnable)new PinnedStateSaver(specThatRequestedSave, true));
            System.out.println("[AppTunnelUI] Pinned app tunnel");
        } else if (specChangedPinnedState) {
            this.specificationSaver.runAsync((Runnable)new PinnedStateSaver(specThatRequestedSave, false));
            System.out.println("[AppTunnelUI] Unpinned app tunnel");
        }
        if (specChangedPinnedState || !specThatRequestedSave.isPinned()) {
            Message m = new Message();
            int count = 0;
            for (AppTunnelSpecification spec : this.currentTechSpecifications) {
                if (spec.isPinned()) continue;
                ++count;
            }
            m.append(count);
            for (AppTunnelSpecification spec : this.currentTechSpecifications) {
                if (spec.isPinned()) continue;
                m.append(spec.toMessage());
            }
            System.out.println("[AppTunnelUI] Saved " + count + " local app tunnels");
            String portForwardBase64 = Base64.byteArrayToBase64((byte[])MessageUtils.messageToBytes((Message)m));
            TechProperties.INSTANCE.setPropAndSaveIn(TechProperties.PORT_FORWARD_SPECIFICATIONS + "-" + this.machine.getMachineID(), portForwardBase64, 1000);
        }
    }

    public AccessPanelListener getAccessPanelListener() {
        return this.accessPanelListener;
    }

    public void setSelectedMachine(Machine machine) {
        if (this.machine != null && this.machine.equals(machine)) {
            return;
        }
        this.machine = machine;
        this.specificationFetcherPool.runAsync((Runnable)this);
    }

    public void requestServiceConnection(AppTunnelTarget target) {
        AppTunnelMessageListener messageListener = new AppTunnelMessageListener(this.machine, target);
        this.getAccessPanelListener().connectToMachine(this.machine, null, 5, false, false, new TechClient.PortForwardRequest(target.getRemoteHost(), target.getRemotePort(), messageListener));
        messageListener.newMessage(Language.get("CONNECTING"));
    }

    @Override
    public void run() {
        ArrayList<AppTunnelSpecification> techSpecifications = new ArrayList<AppTunnelSpecification>();
        ArrayList<AppTunnelSpecification> pinnedSpecifications = new ArrayList<AppTunnelSpecification>();
        try {
            String portForwardBase64 = TechProperties.INSTANCE.getProp(TechProperties.PORT_FORWARD_SPECIFICATIONS + "-" + this.machine.getMachineID());
            if (portForwardBase64 != null) {
                byte[] data = Base64.base64ToByteArray((String)portForwardBase64);
                Message m = MessageUtils.bytesToMessage((byte[])data);
                int count = m.getNextInt();
                for (int i = 0; i < count; ++i) {
                    Collections.addAll(techSpecifications, AppTunnelSpecification.fromMessage(m.getNextMessage()));
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        try {
            AppTunnelSpecification[] specifications = this.getAccessPanelListener().getTechClient().getPinnedSpecificationsFor(this.machine.getMachineID());
            Collections.addAll(pinnedSpecifications, specifications);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        this.initWith(techSpecifications, pinnedSpecifications);
    }

    public class AppTunnelMessageListener
    implements TechClient.HeadlessMessageListener {
        private final AppTunnelTarget target;
        private String sessionID;
        private Machine messageMachine;
        private String lastMessage = "";
        private boolean connected = false;
        private int localPort = -1;
        private TechClientIPCHandler ipcHandler;

        public AppTunnelMessageListener(Machine machine, AppTunnelTarget target) {
            this.target = target;
            this.messageMachine = machine;
            AppTunnelUIRepository.INSTANCE.add(this.messageMachine.getMachineID(), this);
            AppTunnelItem item = this.getItem();
            if (item != null) {
                item.addSession(target, this);
            }
        }

        @Override
        public void setSessionID(String sessionID) {
            this.sessionID = sessionID;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private AppTunnelItem getItem() {
            if (AppTunnelUI.this.machine != null && AppTunnelUI.this.machine.getMachineID().equals(this.messageMachine.getMachineID())) {
                ArrayList arrayList = AppTunnelUI.this.currentAppTunnelItems;
                synchronized (arrayList) {
                    for (AppTunnelItem item : AppTunnelUI.this.currentAppTunnelItems) {
                        if (!item.isForSpec(this.target.getSpecification())) continue;
                        System.out.println("[AppTunnelUI] Found UI for specification " + item);
                        return item;
                    }
                }
            }
            return null;
        }

        @Override
        public void newMessage(String message) {
            if (this.localPort == -1) {
                this.lastMessage = message;
                System.out.println("[AppTunnelUI] Received message (session: " + this.sessionID + " message: " + message + ")");
                AppTunnelItem item = this.getItem();
                if (item != null) {
                    item.updateMessage(this, this.target);
                }
            } else {
                System.out.println("[AppTunnelUI] [Ignored] Received message (session: " + this.sessionID + " message: " + message + ")");
            }
        }

        @Override
        public void sessionClosed() {
            AppTunnelUIRepository.INSTANCE.remove(this.messageMachine.getMachineID(), this);
            AppTunnelItem item = this.getItem();
            item.sessionClosed(this, this.target);
        }

        @Override
        public void sessionConnected() {
            this.connected = true;
            System.out.println("[AppTunnelUI] Received connected state (session: " + this.sessionID + ")");
            this.newMessage(Language.get("CONNECTED"));
        }

        @Override
        public void setLocalPort(int port) {
            this.connected = true;
            System.out.println("[AppTunnelUI] Received notification of local port (port: " + port + ")");
            this.newMessage(Language.get("CONNECTED_PORT", "" + port));
            this.localPort = port;
            this.launchApplication();
        }

        public boolean hasCommandToLaunch() {
            return this.target.getSpecification().useCommand();
        }

        public void launchApplication() {
            String command;
            if (this.target.getSpecification().useCommand() && (command = this.target.getSpecification().getCommand()).length() > 0) {
                command = GenericVariableUtil.substituteVariable(command, "port", Integer.toString(this.localPort));
                System.out.println("[AppTunnelUI] Launching application " + command);
                try {
                    Process p = Runtime.getRuntime().exec(command);
                    ProcessPrinter.printAllOutputToStdout((Process)p);
                }
                catch (Throwable t) {
                    System.out.println("[AppTunnelUI] Unable to launch application " + command);
                    t.printStackTrace();
                }
            }
        }

        @Override
        public void registerIPCHandler(TechClientIPCHandler ipcHandler) {
            this.ipcHandler = ipcHandler;
        }

        @Override
        public String getMachinePassword() {
            return RemoteMachinePasswordDialog.showPasswordDialog(AppTunnelUI.this.rootComponent);
        }

        public String getMessage() {
            return this.lastMessage;
        }

        public boolean isConnected() {
            return this.connected;
        }

        public void terminate() {
            this.ipcHandler.ipcClosed();
        }

        public boolean matches(AccessSession session) {
            return this.sessionID != null && this.sessionID.equals(session.getSessionID());
        }

        public void reconnect() {
            new Thread(){

                @Override
                public void run() {
                    try {
                        AppTunnelMessageListener.this.ipcHandler.ipcClosed();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    AppTunnelUI.this.getAccessPanelListener().connectToMachine(AppTunnelUI.this.machine, null, 5, false, false, new TechClient.PortForwardRequest(AppTunnelMessageListener.this.target.getRemoteHost(), AppTunnelMessageListener.this.target.getRemotePort(), AppTunnelMessageListener.this));
                    AppTunnelMessageListener.this.newMessage(Language.get("CONNECTING"));
                }
            }.start();
        }
    }

    class PinnedStateSaver
    implements Runnable {
        private final AppTunnelSpecification specThatRequestedSave;
        private final boolean pin;

        public PinnedStateSaver(AppTunnelSpecification specThatRequestedSave, boolean pin) {
            this.specThatRequestedSave = specThatRequestedSave;
            this.pin = pin;
        }

        @Override
        public void run() {
            try {
                if (this.pin) {
                    AppTunnelUI.this.accessPanelListener.getTechClient().pinSpecificationToMachine(AppTunnelUI.this.machine.getMachineID(), this.specThatRequestedSave);
                } else {
                    AppTunnelUI.this.accessPanelListener.getTechClient().unpinSpecificationToMachine(AppTunnelUI.this.machine.getMachineID(), this.specThatRequestedSave);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

