/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.invitations;

import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.techclient.TechClient;
import com.aem.shelp.tech.invitations.InvitationURLPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.RootPaneContainer;
import javax.swing.event.ListSelectionEvent;
import utils.swing.components.JWrapLabel;
import utils.swing.components.RoundBorderPanel;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.dialog.glassdialog.ScaledGlassDialog;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanel;
import utils.swing.layout.GbPanelWrapper;

public class InvitationStandardGlassDialog
extends ScaledGlassDialog
implements ActionListener,
KeyListener {
    private JButton bclose;
    private TechClient client;
    private JTextField emailAddressFieldQuick;
    private JLabel emailStatusLabelQuick;
    private String hostname;
    private RoundBorderPanel quickPanel;
    private JButton sendEmailInvitationButtonQuick;
    private JTextField customerNameQuick;

    public InvitationStandardGlassDialog(RootPaneContainer frame, TechClient client) {
        super(frame, 550, 250, true, true, false);
        if (client != null) {
            this.hostname = client.getVirtualServerHostname();
            this.client = client;
        }
        this.setModal(true);
        this.initUI();
        this.initFocus();
        this.setVisible(true);
    }

    private void initFocus() {
        this.sendEmailInvitationButtonQuick.requestFocusInWindow();
    }

    private void initUI() {
        this.setTitle(Language.get("INVITE_REPOSITORY_TITLE"));
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        JPanel repositoryPanel = new JPanel();
        repositoryPanel.setLayout(new BorderLayout());
        repositoryPanel.add("Center", (Component)this.newQuickSendPanel());
        repositoryPanel.add("South", this.initButtonsPanel());
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        this.getContentPane().add("Center", repositoryPanel);
    }

    private GbPanel newQuickSendPanel() {
        JWrapLabel invitationDescription = new JWrapLabel("<HTML>" + Language.get("INVITATION_QUICK_DESCRIPTION") + " (" + this.hostname + ").</HTML>");
        this.quickPanel = new RoundBorderPanel();
        GbPanelWrapper quickPanelGB = new GbPanelWrapper((Container)this.quickPanel, (Insets)new ScaledInsets(2, 2, 2, 2));
        this.sendEmailInvitationButtonQuick = new JButton(Language.get("SEND_INVITATION"));
        this.emailAddressFieldQuick = new JTextField();
        this.customerNameQuick = new JTextField();
        this.emailStatusLabelQuick = new JLabel();
        JLabel customerNameLabel = new JLabel(Language.get("INVITE_CUSTOMER_NAME"));
        JLabel emailAddressLabel = new JLabel(Language.get("EMAIL_ADDRESS"));
        GbPanel emailStatusPanel = new GbPanel();
        emailStatusPanel.setBackground(SHStyle.PANEL_BACKGROUND_DARKER);
        emailStatusPanel.add((Component)this.sendEmailInvitationButtonQuick, 0, 0, 1, 1, 1, 0, 17, 0);
        emailStatusPanel.add((Component)this.emailStatusLabelQuick, 1, 0, 1, 1, 100, 0, 17, 2, (Insets)new ScaledInsets(0, 10, 0, 0));
        int Y = 0;
        quickPanelGB.add((Component)customerNameLabel, 0, Y, 1, 1, 0, 0, 13, 2, (Insets)new ScaledInsets(5, 10, 2, 5));
        quickPanelGB.add((Component)this.customerNameQuick, 1, Y++, 1, 1, 100, 0, 17, 2, (Insets)new ScaledInsets(5, 2, 2, 150));
        quickPanelGB.add((Component)emailAddressLabel, 0, Y, 1, 1, 0, 0, 13, 0, (Insets)new ScaledInsets(2, 10, 2, 2));
        quickPanelGB.add((Component)this.emailAddressFieldQuick, 1, Y++, 1, 1, 100, 0, 17, 2, (Insets)new ScaledInsets(2, 2, 2, 50));
        quickPanelGB.add((Component)emailStatusPanel, 1, Y, 2, 1, 1, 0, 17, 2);
        this.sendEmailInvitationButtonQuick.setEnabled(false);
        this.emailAddressFieldQuick.addKeyListener(this);
        this.customerNameQuick.addKeyListener(this);
        GbPanel panel = new GbPanel();
        panel.add((Component)invitationDescription, 0, 0, 2, 1, 1, 0, 17, 2, (Insets)new ScaledInsets(5, 5, 5, 5));
        panel.add((Component)this.quickPanel, 0, 2, 2, 1, 1, 0, 10, 2, (Insets)new ScaledInsets(3, 3, 3, 3));
        this.sendEmailInvitationButtonQuick.addActionListener(this);
        return panel;
    }

    private Component initButtonsPanel() {
        this.bclose = new JButton(Language.get("CLOSE"), ImageLoader.getImageIcon((String)"images/svg/general/ok.svg,16"));
        GbPanel buttonsPanel = new GbPanel(new ScaledInsets(2, 30, 2, 10));
        buttonsPanel.add((Component)this.bclose, 0, 0, 1, 1, 1, 1, 10, 0);
        buttonsPanel.setBorder(SHBorderFactory.createEmptyBorder((int)5, (int)10, (int)5, (int)10));
        this.bclose.addActionListener(this);
        return buttonsPanel;
    }

    private void updateEnabled() {
        if (this.emailAddressFieldQuick.getText().length() > 0 && this.customerNameQuick.getText().length() > 0) {
            this.sendEmailInvitationButtonQuick.setEnabled(true);
        } else {
            this.sendEmailInvitationButtonQuick.setEnabled(false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        this.actionPerformed(o);
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            this.actionPerformed(this.sendEmailInvitationButtonQuick);
        } else if (e.getKeyCode() == 27) {
            this.actionPerformed(this.bclose);
        }
    }

    private void actionPerformed(Object o) {
        if (o == this.bclose) {
            this.setVisible(false);
        } else if (o == this.sendEmailInvitationButtonQuick) {
            this.sendEmailInvitationButtonQuick.setEnabled(false);
            this.emailStatusLabelQuick.setText(Language.get("SEND_EMAIL_STATUS1") + "...");
            String customerNameText = this.customerNameQuick.getText();
            String emailAddress = this.emailAddressFieldQuick.getText();
            new SendQuickEmailThread(customerNameText, emailAddress).start();
        }
    }

    @Override
    public void keyReleased(KeyEvent arg0) {
        this.updateEnabled();
    }

    @Override
    public void keyTyped(KeyEvent arg0) {
    }

    public void valueChanged(ListSelectionEvent e) {
        this.updateEnabled();
    }

    class SendQuickEmailThread
    extends Thread {
        private String name;
        private String address;

        public SendQuickEmailThread(String name, String address) {
            super("SendQuickEmailThread");
            this.name = name;
            this.address = address;
        }

        @Override
        public void run() {
            try {
                String url = InvitationURLPanel.getURL(InvitationStandardGlassDialog.this.hostname, null);
                InvitationStandardGlassDialog.this.client.sendInvitationQuickEmail(this.name, this.address, url);
                InvitationStandardGlassDialog.this.emailStatusLabelQuick.setText(Language.get("SEND_EMAIL_STATUS2") + ".");
            }
            catch (Throwable t) {
                String message = t.getMessage();
                if (message != null) {
                    InvitationStandardGlassDialog.this.emailStatusLabelQuick.setText(Language.get("SEND_EMAIL_STATUS3") + ": " + message);
                } else {
                    InvitationStandardGlassDialog.this.emailStatusLabelQuick.setText(Language.get("SEND_EMAIL_STATUS3") + ".");
                }
            }
            finally {
                InvitationStandardGlassDialog.this.sendEmailInvitationButtonQuick.setEnabled(true);
            }
        }
    }
}

