/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.history.summarypanels;

import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.types.AccessSession;
import com.aem.shelp.proxy.types.Machine;
import com.aem.shelp.proxy.types.MachineInfo;
import com.aem.shelp.proxy.types.MachineName;
import com.aem.shelp.tech.utils.MachineGroupLabel;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import utils.swing.components.ColorPropagatingGBPanel;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.layout.GbPanel;

public class MachineSummaryPanel {
    private GbPanel machinePanel = new ColorPropagatingGBPanel(new ScaledInsets(2, 2, 2, 2)){};
    private MachineName machineName;
    private JLabel hostname;
    private JLabel osValue;
    private JLabel tunnel;
    private JLabel groupLabel;
    private MachineGroupLabel machineGroupLabel;

    public JComponent getRootComponent() {
        return this.machinePanel;
    }

    public MachineSummaryPanel() {
        this.initUI();
    }

    private void initUI() {
        this.machinePanel.setBorder(SHBorderFactory.createEmptyBorder((int)10, (int)0, (int)10, (int)0));
        this.hostname = new JLabel();
        this.tunnel = new JLabel();
        JLabel hostnameLabel = new JLabel();
        hostnameLabel.setForeground(SHStyle.EXAMPLE_TEXT_COLOR);
        hostnameLabel.setText(Language.get("HOSTNAME") + " ");
        this.groupLabel = new JLabel();
        this.groupLabel.setForeground(SHStyle.EXAMPLE_TEXT_COLOR);
        this.groupLabel.setText(Language.get("GROUP") + " ");
        JLabel osLabel = new JLabel();
        osLabel.setText(Language.get("OPERATING_SYSTEM") + " ");
        osLabel.setForeground(SHStyle.EXAMPLE_TEXT_COLOR);
        CompoundLabel compoundLabel = new CompoundLabel(this.hostname, this.tunnel);
        this.osValue = new JLabel();
        this.machineGroupLabel = new MachineGroupLabel();
        this.machinePanel.add((Component)this.groupLabel, 0, 1, 1, 1, 0, 0, 13, 0);
        this.machinePanel.add((Component)((Object)this.machineGroupLabel), 1, 1, 1, 1, 1, 0, 17, 2);
        this.machinePanel.add((Component)hostnameLabel, 0, 0, 1, 1, 0, 0, 13, 0);
        this.machinePanel.add((Component)compoundLabel, 1, 0, 1, 1, 0, 0, 17, 2);
        this.machinePanel.add((Component)osLabel, 0, 2, 1, 1, 0, 0, 13, 0);
        this.machinePanel.add((Component)this.osValue, 1, 2, 1, 1, 1, 0, 17, 2);
    }

    public void initWith(Machine remoteMachine, AccessSession session) {
        MachineInfo info = remoteMachine.getMachineInfo();
        this.machineName = remoteMachine.getMachineName();
        String appTunnelPostfix = "";
        if (session.isAppTunnelSession()) {
            appTunnelPostfix = session.getAppTunnelSummaryString();
            this.tunnel.setText(" (" + Language.get("TUNNEL_TO") + " " + appTunnelPostfix + ")");
            this.tunnel.setForeground(SHStyle.EXAMPLE_TEXT_COLOR);
        } else {
            this.tunnel.setText("");
        }
        if (info != null && info.getHostname() != null && info.getHostname().length() > 0) {
            this.hostname.setText(info.getHostname());
        } else {
            this.hostname.setText("-");
        }
        this.osValue.setText(remoteMachine.getOsSummary());
        boolean isInGroup = this.machineName.isInGroup();
        this.machineGroupLabel.setVisible(isInGroup);
        this.groupLabel.setVisible(isInGroup);
        if (isInGroup) {
            this.machineGroupLabel.setGroups(this.machineName.getGroup());
        }
    }

    public class CompoundLabel
    extends JPanel {
        public CompoundLabel(JLabel left, JLabel right) {
            this.setLayout(new BorderLayout());
            this.add((Component)left, "West");
            this.add((Component)right, "Center");
        }
    }
}

